package co.pixelbeard.theanfieldwrap.networking;

import co.pixelbeard.theanfieldwrap.data.responses.ArticleByIdResponse;
import co.pixelbeard.theanfieldwrap.data.responses.ArticlesResponse;
import co.pixelbeard.theanfieldwrap.data.responses.GenericResponse;
import co.pixelbeard.theanfieldwrap.data.responses.GetDevicesResponse;
import co.pixelbeard.theanfieldwrap.data.responses.GetWalletResponse;
import co.pixelbeard.theanfieldwrap.data.responses.GuestUserResponse;
import co.pixelbeard.theanfieldwrap.data.responses.LoginResponse;
import co.pixelbeard.theanfieldwrap.data.responses.NotificationSettingsResponse;
import co.pixelbeard.theanfieldwrap.data.responses.PodcastByIdResponse;
import co.pixelbeard.theanfieldwrap.data.responses.PodcastsResponse;
import co.pixelbeard.theanfieldwrap.data.responses.RegisterUserResponse;
import co.pixelbeard.theanfieldwrap.data.responses.SubscriptionItemResponse;
import co.pixelbeard.theanfieldwrap.data.responses.VideoByIdResponse;
import co.pixelbeard.theanfieldwrap.data.responses.VideosResponse;
import co.pixelbeard.theanfieldwrap.freeSubscription.ActiveSubscriptionResponse;
import io.reactivex.Observable;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.POST;
import retrofit2.http.Path;

public interface ApiInterface {

    @FormUrlEncoded
    @POST(NetworkConstants.RECORD_ANALYTIC_ENDPOINT)
    Observable<GenericResponse> recordAnalytic(@Header("user-api-token") String userApiToken,
                                               @Field("type") String type,
                                               @Field("variable") String variable,
                                               @Field("secondary_variable") String secondaryVar);


    //User Services
    @FormUrlEncoded
    @POST(NetworkConstants.LOGIN_ENDPOINT)
    Observable<LoginResponse> login(@Header("user-api-token") String userApiToken, @Field("email") String email,
                                    @Field("passwd") String password, @Field("device_token") String token,
                                    @Field("device_type") String deviceType);

    @POST(NetworkConstants.REGISTER_GUEST_ENDPOINT)
    Observable<GuestUserResponse> registerGuestUser();

    @FormUrlEncoded
    @POST(NetworkConstants.CONVERT_GUEST_TO_FULL_USER)
    Observable<GenericResponse> convertGuestToFullUser(@Header("user-api-token") String userApiToken, @Field("firstname") String firstName, @Field("lastname") String lastName,
                                                       @Field("email") String email, @Field("password") String password,
                                                       @Field("opt_in") boolean optIn, @Field("username") String username, @Field("country") String country);

    @FormUrlEncoded
    @POST(NetworkConstants.REGISTER_FULL_ENDPOINT)
    Observable<RegisterUserResponse> registerFullUser(@Field("firstname") String firstName, @Field("lastname") String lastName,
                                                      @Field("email") String email, @Field("password") String password,
                                                      @Field("opt_in") boolean optIn, @Field("username") String username, @Field("country") String country);

    @FormUrlEncoded
    @POST(NetworkConstants.CHECK_EMAIL_ENDPOINT)
    Observable<GenericResponse> checkUserEmail(@Field("email") String email);

    @FormUrlEncoded
    @POST(NetworkConstants.CHECK_USERNAME_ENDPOINT)
    Observable<GenericResponse> checkUsername(@Field("username") String username);

    @FormUrlEncoded
    @POST(NetworkConstants.RESEND_ACTIVATION_ENDPOINT)
    Observable<GenericResponse> resendAuthCode(@Field("email") String email);

    @FormUrlEncoded
    @POST(NetworkConstants.ACTIVATE_USER_ENDPOINT)
    Observable<GenericResponse> activateUser(@Field("email") String email, @Field("activation_code") String activationCode);

    @FormUrlEncoded
    @POST(NetworkConstants.REQUEST_PASSWORD_RESET_ENDPOINT)
    Observable<GenericResponse> requestPasswordReset(@Field("email") String email);

    @FormUrlEncoded
    @POST(NetworkConstants.RESET_PASSWORD_ENDPOINT)
    Observable<GenericResponse> resetPassword(@Field("email") String email, @Field("recovery_code") String recoveryCode, @Field("password") String password);

    @FormUrlEncoded
    @POST(NetworkConstants.LOGOUT_USER_ENDPOINT)
    Observable<GenericResponse> logout(@Header("user-api-token") String userApiToken, @Field("device_token") String deviceToken);

    @FormUrlEncoded
    @POST(NetworkConstants.CHANGE_PASSWORD_ENDPOINT)
    Observable<GenericResponse> changePassword(@Header("user-api-token") String userApiToken, @Field("old_password") String oldPassword, @Field("new_password") String newPassword);

    @GET(NetworkConstants.GET_SETTINGS_ENDPOINT)
    Observable<NotificationSettingsResponse> getUserSettings(@Header("user-api-token") String userApiToken);

    @FormUrlEncoded
    @POST(NetworkConstants.UPDATE_SETTINGS_ENDPOINT)
    Observable<GenericResponse> updateUserSettings(@Header("user-api-token") String userApiToken, @Path("type") String type, @Field("value") int value);

    @FormUrlEncoded
    @POST(NetworkConstants.UPDATE_EMAIL_ENDPOINT)
    Observable<GenericResponse> updateUserEmail(@Header("user-api-token") String userApiToken, @Field("new_email") String newEmail, @Field("old_email") String oldEmail);

    @FormUrlEncoded
    @POST(NetworkConstants.UPDATE_DETAILS_ENDPOINT)
    Observable<GenericResponse> updateUserDetails(@Header("user-api-token") String userApiToken, @Field("firstname") String firstName, @Field("lastname") String lastName, @Field("username") String username);


    //Podcasts
    @GET(NetworkConstants.GET_PODCASTS_ENDPOINT)
    Observable<PodcastsResponse> getPodcasts(@Header("user-api-token") String userApiToken, @Path("pageNum") int pageNumber);

    @GET(NetworkConstants.GET_PODCAST_BY_ID_ENDPOINT)
    Observable<PodcastByIdResponse> getPodcastById(@Header("user-api-token") String userApiToken, @Path("podcastId") Long podcastId);


    //Videos
    @GET(NetworkConstants.GET_VIDEOS_ENDPOINT)
    Observable<VideosResponse> getVideos(@Header("user-api-token") String userApiToken, @Path("pageNum") int pageNumber);

    @GET(NetworkConstants.GET_VIDEO_BY_ID_ENDPOINT)
    Observable<VideoByIdResponse> getVideoById(@Header("user-api-token") String userApiToken, @Path("videoId") String videoId);

    //Articles
    @GET(NetworkConstants.GET_ARTICLES_ENDPOINT)
    Observable<ArticlesResponse> getArticles(@Header("user-api-token") String userApiToken, @Path("pageNum") int pageNumber);

    @GET(NetworkConstants.GET_ARTICLE_BY_ID_ENDPOINT)
    Observable<ArticleByIdResponse> getArticleById(@Header("user-api-token") String userApiToken, @Path("articleId") Long articleId);


    //Subs
    @POST(NetworkConstants.CHECK_SUBS_ENDPOINT)
    Observable<LoginResponse> checkUserSubscription(@Header("user-api-token") String userApiToken);


    //Device Management
    @FormUrlEncoded
    @POST(NetworkConstants.UNLINK_DEVICE_ENDPOINT)
    Observable<GenericResponse> unlinkDevice(@Header("user-api-token") String userApiToken, @Field("id") int deviceId);

    @GET(NetworkConstants.GET_ACTIVE_DEVICES_ENDPOINT)
    Observable<GetDevicesResponse> getActiveDevices(@Header("user-api-token") String userApiToken);


    //Wallet
    @GET(NetworkConstants.GET_WALLET_ENDPOINT)
    Observable<GetWalletResponse> getWallet(@Header("user-api-token") String userApiToken);

    @FormUrlEncoded
    @POST(NetworkConstants.CREDIT_ACCOUNT_ENDPOINT)
    Observable<GetWalletResponse> creditUserAccount(@Header("user-api-token") String userApiToken, @Field("value") int value, @Field("title") String title, @Field("entry_variable") String purchaseToken);

    @FormUrlEncoded
    @POST(NetworkConstants.PURCHASE_ITEM_ENDPOINT)
    Observable<GetWalletResponse> purchaseItem(@Header("user-api-token") String userApiToken, @Field("product_id") String productId);

    @GET(NetworkConstants.GET_SUBSCRIPTION_LIST_ENDPOINT)
    Observable<SubscriptionItemResponse> getSubscriptionList();

    @FormUrlEncoded
    @POST(NetworkConstants.ACTIVE_FREE_SUBSCRIPTION)
    Observable<ActiveSubscriptionResponse> getActiveSubscription(@Header("user-api-token") String userApiToken, @Field("subscription_plan") String productId);

    @FormUrlEncoded
    @POST(NetworkConstants.ACTIVE_PAID_SUBSCRIPTION)
    Observable<ActiveSubscriptionResponse> getActivePaidSubscription(
            @Header("user-api-token") String userApiToken,
            @Field("subscription_plan") String productId,
            @Field("subscription_type") String subscriptionType,
            @Field("subscription_days") int days,
            @Field("entry_variable") String purchaseToken);

}
