package co.pixelbeard.theanfieldwrap.podcastDetails;

import android.content.Context;

import com.tonyodev.fetch2.Download;

import co.pixelbeard.theanfieldwrap.data.Podcast;
import co.pixelbeard.theanfieldwrap.data.RealmPodcast;
import co.pixelbeard.theanfieldwrap.utils.BasePresenter;
import co.pixelbeard.theanfieldwrap.utils.BaseView;

public interface PodcastDetailsContract {

    interface View extends BaseView<Presenter> {
        void updateUI(Download download);

        void setPodcast(Podcast podcast);

        void setPodcastPurchased(boolean isPurchased);

        void showErrorDialog(String message);

        void showBalanceTooLowDialog();

        void updateWalletBalance(int balance);

    }

    interface Presenter extends BasePresenter {
        void downloadPodcast(Podcast podcast, Context context);

        void savePodcast(Podcast podcast, Download download);

        void recordAnalytic(String type, String variable, String secondVar);

        RealmPodcast getPodcastByIdLocal(long id);

        void getPodcastByIdRemote(long id);

        void purchaseItem(String id);

        void checkWalletBalance();
    }
}