package co.pixelbeard.theanfieldwrap.utils;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.TextView;

import co.pixelbeard.theanfieldwrap.R;

public class BulletView extends RelativeLayout {
    TextView textView;
    public BulletView(Context context) {
        super(context);
    }

    public BulletView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init(attrs);
    }

    public BulletView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(attrs);
    }

    public BulletView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        init(attrs);
    }

    private void init(AttributeSet attrs) {
        try {
            View view = View.inflate(getContext(), R.layout.bullet_view, this);
            textView = view.findViewById(R.id.descriptionView);
            TypedArray typedArray = getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.bulletView, 0, 0);
            CharSequence text = typedArray.getText(R.styleable.bulletView_android_text);
            textView.setText(text);
            typedArray.recycle();
        } catch (Exception e) {

        }
    }

    public void setText(CharSequence text){
        textView.setText(text);
    }
}
