package co.pixelbeard.theanfieldwrap.utils;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Intent;
import android.provider.Settings;
import android.util.Log;

import androidx.lifecycle.ProcessLifecycleOwner;

import com.facebook.FacebookSdk;
import com.onesignal.OneSignal;
import com.tonyodev.fetch2.Fetch;
import com.tonyodev.fetch2.FetchConfiguration;
import com.tonyodev.fetch2.HttpUrlConnectionDownloader;
import com.tonyodev.fetch2core.Downloader;

import co.pixelbeard.theanfieldwrap.networking.ApiClient;
import co.pixelbeard.theanfieldwrap.playerService.PodcastStorageUtil;
import co.pixelbeard.theanfieldwrap.splash.SplashActivity;
import io.realm.Realm;
import io.realm.RealmConfiguration;

/**
 * Created by Michael Stoddart
 * 20/12/2018.
 */
@SuppressLint("HardwareIds")
public class TawController extends Application {

    private static String androidId;
    private static String currentPage = "";

    public static String getCurrentPage() {
        return currentPage;
    }

    public static void setCurrentPage(String currentPage) {
        TawController.currentPage = currentPage;
    }

    public static String getUniqueId() {
        return androidId;
    }

    @Override
    public void onCreate() {
        super.onCreate();

        ProcessLifecycleOwner.get().getLifecycle().addObserver(new LifecycleListener());

        androidId = Settings.Secure.getString(this.getContentResolver(), Settings.Secure.ANDROID_ID);

        FontUtils.getInstance(this);
        PrefUtils.getInstance(this);
        PodcastStorageUtil.getInstance(this);
        ApiClient.getApiService(this);

        FacebookSdk.setAutoLogAppEventsEnabled(true);

        Realm.init(this);

        setRealmConfig();
        setFetchConfig();

        OneSignal.startInit(this)
                .inFocusDisplaying(OneSignal.OSInFocusDisplayOption.Notification)
                .unsubscribeWhenNotificationsAreDisabled(true)
                .setNotificationReceivedHandler(notification -> Log.d("NOTIF DATA", notification.toJSONObject().toString()))
                .setNotificationOpenedHandler(result -> {
                    Log.d("NOTIF OPENED", result.notification.toJSONObject().toString());

                    Intent intent = new Intent(TawController.this, SplashActivity.class);
                    intent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TASK | Intent.FLAG_ACTIVITY_NEW_TASK);

                    if (result.notification.payload.additionalData != null) {
                        intent.putExtra(ActivityExtraTags.NOTIF_PAYLOAD, result.notification.payload.additionalData.toString());
                    }
                    startActivity(intent);


                })
                .init();

        OneSignal.idsAvailable((userId, registrationId) -> {
            PrefUtils.getInstance().putStringPref(PrefKey.ONESIGNAL_ID, userId);
            Log.d("ONESIGNAL", userId);
        });

//        if (LeakCanary.isInAnalyzerProcess(this)) {
//            // This process is dedicated to LeakCanary for heap analysis.
//            // You should not init your app in this process.
//            return;
//        }
//        LeakCanary.install(this);
    }

    private void setRealmConfig() {

        RealmConfiguration config = new RealmConfiguration.Builder()
                .name("TheAnfieldWrap-Realm")
                .schemaVersion(2)
                .deleteRealmIfMigrationNeeded()
                .build();

        Realm.setDefaultConfiguration(config);
    }

    private void setFetchConfig() {
        FetchConfiguration fetchConfiguration = new FetchConfiguration.Builder(this)
                .enableRetryOnNetworkGain(true)
                .setDownloadConcurrentLimit(2)
                .setHttpDownloader(new HttpUrlConnectionDownloader(Downloader.FileDownloaderType.PARALLEL))
                .build();

        Fetch.Impl.setDefaultInstanceConfiguration(fetchConfiguration);
    }
}
