package co.pixelbeard.theanfieldwrap.walkthrough;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.TextSwitcher;
import android.widget.TextView;

import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentStatePagerAdapter;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager.widget.ViewPager;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;
import butterknife.ButterKnife;
import co.pixelbeard.theanfieldwrap.R;
import co.pixelbeard.theanfieldwrap.buyTokens.IndicatorAdapter;
import co.pixelbeard.theanfieldwrap.login.LoginActivity;
import co.pixelbeard.theanfieldwrap.signUp.SignUpActivity;
import co.pixelbeard.theanfieldwrap.utils.BaseActivity;
import co.pixelbeard.theanfieldwrap.utils.ConnectionUtils;
import co.pixelbeard.theanfieldwrap.utils.FontUtils;
import co.pixelbeard.theanfieldwrap.utils.TawController;
import co.pixelbeard.theanfieldwrap.walkthrough.fragments.WalkthroughOneFragment;
import co.pixelbeard.theanfieldwrap.walkthrough.fragments.WalkthroughThreeFragment;
import co.pixelbeard.theanfieldwrap.walkthrough.fragments.WalkthroughTwoFragment;

public class WalkthroughActivity extends BaseActivity implements WalkthroughContract.View {

    private static final String TAG = WalkthroughActivity.class.getSimpleName();

    @BindView(R.id.btn_login)
    Button btnLogin;
    @BindView(R.id.btn_sign_up)
    Button btnSignUp;
    @BindView(R.id.btn_terms_of_service)
    Button btnTermsOfService;
    @BindView(R.id.rv_pager_indicator)
    RecyclerView rvPagerIndicator;
    @BindView(R.id.txt_walkthrough_header)
    TextView txtWalkthroughHeader;
    @BindView(R.id.txt_walkthrough_header_2)
    TextView txtWalkthroughHeader2;
    @BindView(R.id.text_switcher)
    TextSwitcher textSwitcher;
    @BindView(R.id.pager)
    ViewPager pager;


    private WalkthroughContract.Presenter mPresenter;
    private IndicatorAdapter indicatorAdapter;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_walkthrough);
        ButterKnife.bind(this);


        new WalkthroughPresenter(this);


        Animation fadeIn = AnimationUtils.loadAnimation(this, android.R.anim.fade_in);
        Animation fadeOut = AnimationUtils.loadAnimation(this, android.R.anim.fade_out);

        fadeIn.setDuration(300);
        fadeIn.setStartOffset(300);
        fadeOut.setDuration(300);

        textSwitcher.setInAnimation(fadeIn);
        textSwitcher.setOutAnimation(fadeOut);

        txtWalkthroughHeader.setTypeface(FontUtils.getInstance().getDinProBlack());
        txtWalkthroughHeader2.setTypeface(FontUtils.getInstance().getDinProBlack());

        setButtonFonts();
        setButtonClickListener();

        setupPager();
    }

    @Override
    protected void onResume() {
        super.onResume();
        TawController.setCurrentPage(TAG);
    }

    private void setButtonFonts() {
        btnLogin.setTypeface(FontUtils.getInstance().getDinAlternateBold());
        btnSignUp.setTypeface(FontUtils.getInstance().getDinAlternateBold());
        btnTermsOfService.setTypeface(FontUtils.getInstance().getDinCondensedBold());
    }

    private void setButtonClickListener() {

        btnLogin.setOnClickListener(v -> mPresenter.loginClicked());

        btnSignUp.setOnClickListener(v -> mPresenter.signUpClicked());

        btnTermsOfService.setOnClickListener(v -> {
            //TODO move to presenter

            String url = "https://www.theanfieldwrap.com/taw-player/terms-of-service/";
            Intent i = new Intent(Intent.ACTION_VIEW);
            i.setData(Uri.parse(url));
            startActivity(i);
            overridePendingTransition(R.anim.slide_in_from_right, R.anim.slide_out_left);
        });
    }

    private void setupPager() {
        List<Fragment> fragments = new ArrayList<>();
        fragments.add(WalkthroughOneFragment.newInstance());
        fragments.add(WalkthroughTwoFragment.newInstance());
        fragments.add(WalkthroughThreeFragment.newInstance());

        pager.setAdapter(new FragmentStatePagerAdapter(getSupportFragmentManager()) {
            @Override
            public Fragment getItem(int position) {
                return fragments.get(position);
            }

            @Override
            public int getCount() {
                return fragments.size();
            }
        });

        pager.addOnPageChangeListener(new ViewPager.OnPageChangeListener() {
            @Override
            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {

            }

            @Override
            public void onPageSelected(int position) {
                indicatorAdapter.setSelected(position);

                switch (position) {
                    case 0:
                        textSwitcher.setText(getString(R.string.podcasts));
                        break;
                    case 1:
                        textSwitcher.setText(getString(R.string.videos));
                        break;
                    case 2:
                        textSwitcher.setText(getString(R.string.writing));
                        break;

                }
            }

            @Override
            public void onPageScrollStateChanged(int state) {

            }
        });

        setupPagerIndicator(fragments.size());
    }

    private void setupPagerIndicator(int count) {
        rvPagerIndicator.setLayoutManager(new LinearLayoutManager(this, RecyclerView.HORIZONTAL, false));
        indicatorAdapter = new IndicatorAdapter(count);
        rvPagerIndicator.setAdapter(indicatorAdapter);
    }

    @Override
    public void startLoginActivity() {
        Intent loginIntent = new Intent(this, LoginActivity.class);
        startActivity(loginIntent);
        finish();
        overridePendingTransition(R.anim.slide_in_from_right, R.anim.slide_out_left);
    }

    @Override
    public void startSignUpActivity() {
        Intent signUpIntent = new Intent(this, SignUpActivity.class);
        startActivity(signUpIntent);
        finish();
        overridePendingTransition(R.anim.slide_in_from_right, R.anim.slide_out_left);
    }

    @Override
    public void setPresenter(WalkthroughContract.Presenter presenter) {
        if (presenter != null) {
            this.mPresenter = presenter;
        } else {
            throw new RuntimeException();
        }
    }

    @Override
    public void goBack() {
        //Not needed
    }

    @Override
    public void showLoader(String text) {
        //Not needed
    }

    @Override
    public void hideLoader() {
        //Not needed
    }

    @Override
    public void onUnknownError(String error) {
        //Not needed
    }

    @Override
    public void onTimeout() {
        //Not needed
    }

    @Override
    public void onNetworkError() {
        //Not needed
    }

    @Override
    public void onConnectionError() {
        //Not needed
    }

    @Override
    public void logoutUser() {
        //Not needed
    }

    @Override
    public boolean checkConnection() {
        return ConnectionUtils.userHasConnection(this);
    }
}
