package co.pixelbeard.theanfieldwrap.writing;

import java.util.List;

import co.pixelbeard.theanfieldwrap.data.Article;
import co.pixelbeard.theanfieldwrap.utils.BasePresenter;
import co.pixelbeard.theanfieldwrap.utils.BaseView;

public interface WritingContract {

    interface View extends BaseView<Presenter> {
        void setWritingAdapter(List<Article> articles, Article featuredArticle);

        void showNoConnectionUi();

        void showNoConnectionHeader();

        void showUi();

        void setSwipeRefreshRefreshing(boolean refreshing);

        void showSingleButtonDialog(String error, String message);

    }

    interface Presenter extends BasePresenter {
        void getArticles(int pageNum);

        void checkUserSubs();

        void refreshArticles();

        void recordAnalytic(String type, String variable, String secondVar);
    }
}