<?php
defined('BASEPATH') OR exit('No direct script access allowed');
date_default_timezone_set('Europe/London');

class Front extends CI_Controller {

	function __construct() {
		parent::__construct();
		$this->load->helper('url');
		$this->load->helper('date');
		$this->load->helper('form');
        $this->load->library("braintree_lib");
		// $this->load->model('UsersModel', 'users'); // Load a model
		$this->load->model('PBReusableModel_Subscriptions','subscriptions');
		$this->load->model('PBReusableModel_Global','globals');
		$this->load->model('PBReusableModel_User','users');

	}


	public function hello_world() {
		$data = array();
		$this->load->view('front-header',$data);
		$this->load->view('front-hello',$data);
		$this->load->view('front-footer',$data);
	}

    public function checkout_subscriptions() {
		$data = array();
        $data['subscriptions'] = $this->braintree_lib->getAllPlans();
		$this->load->view('front-header',$data);
		$this->load->view('front-sub-plans',$data);
		$this->load->view('front-footer',$data);
	}

    public function checkout_checkout() {
		$data = array();

        $amount = $_POST["amount"];
        $nonce = $_POST["payment_method_nonce"];

        $this->braintree_lib->checkout_sub($this->input->post('amount'),$this->input->post('payment_method_nonce'));

		$this->load->view('front-header',$data);
		$this->load->view('front-sub-checkout',$data);
		$this->load->view('front-footer',$data);
	}

    public function checkout_result() {
		$data = array();
		$this->load->view('front-header',$data);
		$this->load->view('front-sub-result',$data);
		$this->load->view('front-footer',$data);
	}

    public function checkout_payment() {
		$data = array();
		$data['subscriptions'] = $this->braintree_lib->getAllPlans();
		$data['user_subscription_info'] = $this->subscriptions->front_get_sub_info();
		$this->load->view('front-header',$data);
		$this->load->view('front-sub-payment',$data);
		$this->load->view('front-footer',$data);
	}



    public function create_customer_with_nonce() {
        $customer = array(
            "firstName" => "Will",
            "lastName" => "Roberts",
            "email" => "will@pixelbeard.co",
            "paymentMethodNonce" => $this->input->post('payment_method_nonce')
        );
        $data = array();
        $data['nonce'] = $this->input->post('payment_method_nonce');
        $data['customer'] = $this->braintree_lib->createNewCustomer($customer);
        $data['checkout'] = $this->braintree_lib->checkout_sub(12,$this->input->post('payment_method_nonce'));
        $data['plans'] = $this->braintree_lib->getAllPlans();
        $this->load->view('front-header',$data);
        $this->load->view('front-sub-create-customer',$data);
        $this->load->view('front-footer',$data);
    }

}
