//
//  TAWDeviceLimitViewController.swift
//  TAW
//
//  Created by Andrew Steven on 28/02/2019.
//  Copyright © 2019 PixelBeard. All rights reserved.
//

import UIKit

public enum DeviceWarning {
    case deviceAdded
    case limitReached
}

class TAWDeviceLimitViewController: UIViewController {
    
    @IBOutlet weak var titleLabel: UILabel!
    @IBOutlet weak var descriptionLabel: UILabel!
    @IBOutlet weak var unlinkButton: PBButton!
    @IBOutlet weak var cancelButton: PBButton!
    @IBOutlet weak var gotItButton: PBButton!
    
    @IBOutlet weak var unlinkButtonHeight: NSLayoutConstraint!
    @IBOutlet weak var gotItButtonHeight: NSLayoutConstraint!
    @IBOutlet weak var cancelButtonHeight: NSLayoutConstraint!
    
    var deviceWarning: DeviceWarning = .limitReached
    var devices: [Device] = []

    override func viewDidLoad() {
        super.viewDidLoad()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        
        self.setupView()
    }
    
    private func setupView() {
        
        if UIDevice.isSmallDevice {
            self.view.layoutIfNeeded()
            self.unlinkButtonHeight.constant = 45
            self.gotItButtonHeight.constant = 45
            self.cancelButtonHeight.constant = 45
            self.view.layoutIfNeeded()
        }
        
        switch self.deviceWarning {
        case .deviceAdded:
            self.unlinkButton.isHidden = true
            self.cancelButton.isHidden = true
            self.gotItButton.isHidden = false
        case .limitReached:
            self.titleLabel.text = "DEVICE LIMIT REACHED"
            self.descriptionLabel.text = "Looks like youve already added your maximum of 3 devices to this account. Would you like to unlink a different device to login on this devie?"
            self.unlinkButton.isHidden = false
            self.cancelButton.isHidden = false
            self.gotItButton.isHidden = true
        }
    }
    
    @IBAction func gotIt() {
        
    }
    
    @IBAction func unlinkDevice() {
        if let tawVC = instantiateVC(identifier: "TAWDevicesViewController") as? TAWDevicesViewController {
            tawVC.isUnlinkingDevice = true
            tawVC.devices = devices
            self.navigationController?.pushViewController(tawVC, animated: true)
        }
    }
    
    @IBAction func cancel() {
        self.navigationController?.dismiss(animated: true, completion: nil)
    }
}
