//
//  TAWWalkthroughViewController.swift
//  TAW
//
//  Created by Andrew Steven on 17/12/2018.
//  Copyright © 2018 PixelBeard. All rights reserved.
//

import UIKit

class TAWWalkthroughViewController: PBAnimatedViewController {
    
    // MARK: - Interface Outlets -

    @IBOutlet weak var titleLabel: UILabel!
    @IBOutlet weak var pageControl: UIPageControl!
    @IBOutlet weak var loginButton: PBButton!
    @IBOutlet weak var signUpButton: PBButton!
    @IBOutlet weak var termsOfServiceButton: UIButton!
    
    @IBOutlet weak var loginButtonHeight: NSLayoutConstraint!
    @IBOutlet weak var signUpButtonHeight: NSLayoutConstraint!
    
    // MARK: - Variables -
    
    var titles: [String] = ["PODCASTS", "VIDEOS", "WRITING"]
    
    // MARK: - Life cycle -
    
    override func viewDidLoad() {
        super.viewDidLoad()
        self.pageControl.currentPage = 0
        self.titleLabel.text = self.titles[0]
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        self.setupView()
    }
    
    private func setupView() {
        if UIDevice.isSmallDevice {
            self.view.layoutIfNeeded()
            self.loginButtonHeight.constant = 45
            self.signUpButtonHeight.constant = 45
            self.view.layoutIfNeeded()
        }
    }
    
    // MARK: - Button actions -
    
    @IBAction func termsOfService(_ sender: Any) {
        guard let url = URL(string: TAW.Urls.termsOfService) else {
            return //be safe
        }
        
        UIApplication.shared.open(url, options: [:], completionHandler: nil)
    }
}

extension TAWWalkthroughViewController: UIScrollViewDelegate {
    func scrollViewDidEndDecelerating(_ scrollView: UIScrollView) {
        let pageWidth: CGFloat = scrollView.frame.width
        
        let current = Int(floor((scrollView.contentOffset.x - pageWidth / 2) / pageWidth) + 1)
        if current != self.pageControl.currentPage {
            self.pageControl.currentPage = current
            
            UIView.animate(withDuration: 0.3, animations: {
                self.titleLabel.alpha = 0
            }) { (_) in
                self.titleLabel.text = self.titles[self.pageControl.currentPage]
                UIView.animate(withDuration: 0.2, animations: {
                    self.titleLabel.alpha = 1
                })
            }
        }
    }
}

extension String {
    var htmlDecoded: String {
        let decoded = try? NSAttributedString(data: Data(utf8), options: [
            .documentType: NSAttributedString.DocumentType.html,
            .characterEncoding: String.Encoding.utf8.rawValue
            ], documentAttributes: nil).string
        
        return decoded ?? self
    }
}
