//
//  PBAnimatedViewController.swift
//  TAW
//
//  Created by Andrew Steven on 15/01/2019.
//  Copyright © 2019 PixelBeard. All rights reserved.
//

import UIKit
import Spruce

class PBAnimatedViewController: UIViewController, UIGestureRecognizerDelegate {
    
    // MARK: - Variables -
    
    var animations: [StockAnimation]
    var sortFunction: SortFunction?
    var timer: Timer?
        
    let tableViewAnimations: [StockAnimation]
    var tableViewSortFunction: SortFunction?
    
    // MARK: - Initializers -
    
    init(animations: [StockAnimation], nibName: String?) {
        self.animations = animations
        self.tableViewAnimations = animations
        super.init(nibName: nibName, bundle: nil)
    }
    
    required init?(coder aDecoder: NSCoder) {
        self.animations = [.slide(.up, .slightly), .fadeIn]
        self.sortFunction = LinearSortFunction(direction: .topToBottom, interObjectDelay: 0.1)
        
        self.tableViewAnimations = [.fadeIn, .slide(.up, .slightly), .expand(.slightly)]
        self.tableViewSortFunction = LinearSortFunction(direction: .topToBottom, interObjectDelay: 0.1)
        super.init(coder: aDecoder)
    }
    
    // MARK: - Life cycle -

    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        prepareAnimation()
    }
    
    // MARK: - Animation functions -
    
    func prepareAnimation() {
        
        self.view?.spruce.prepare(with: animations)
        
        timer?.invalidate()
        timer = Timer.scheduledTimer(timeInterval: 0.5,
                                     target: self,
                                     selector: #selector(callAnimation),
                                     userInfo: nil,
                                     repeats: false)
    }
    
    @objc func callAnimation() {
        
        guard let sortFunction = sortFunction else {
            return
        }
        var animation = SpringAnimation(duration: 0.7)
        animation.animationOptions = [UIView.AnimationOptions.allowUserInteraction]
        DispatchQueue.main.async {
            self.view?.spruce.animate(self.animations,
                                      animationType: animation,
                                      sortFunction: sortFunction)
        }
    }
    
    func animateTableView(_ tableView: UITableView) {
        
        var animation = SpringAnimation(duration: 0.7)
        animation.animationOptions = [UIView.AnimationOptions.allowUserInteraction]
        
        DispatchQueue.main.async {
            tableView.spruce.animate(self.tableViewAnimations,
                                     animationType: animation,
                                     sortFunction: self.tableViewSortFunction!)
        }
    }
}
