//
//  TAWHowToSubscribeViewController.swift
//  TAW
//
//  Created by Andrew Steven on 14/01/2019.
//  Copyright © 2019 PixelBeard. All rights reserved.
//

import UIKit

class TAWHowToSubscribeViewController: UIViewController {
    
    // MARK: - Interface outlets -

    @IBOutlet weak var backButton: UIButton!
    @IBOutlet weak var headerView: PBView!
    @IBOutlet weak var headerViewHeight: NSLayoutConstraint!
    @IBOutlet weak var dexcriptionLabel: UILabel!
    @IBOutlet weak var titleLabel: UILabel!
    @IBOutlet weak var collapsedView: UIView!
    @IBOutlet weak var offsetBottom: NSLayoutConstraint!
    
    var maxHeaderHeight: CGFloat = 250
    var minHeaderHeight: CGFloat = 70
    
    // MARK: - Life cycle -
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        minHeaderHeight = 70 + self.collapsedView.frame.origin.y
        headerView.fillColor = UIColor(red: 27/255,
                                       green: 27/255,
                                       blue: 27/255,
                                       alpha: 1.0)

        let image = UIImage(named: "back_arrow_icon")?.withRenderingMode(.alwaysTemplate)
        backButton.setImage(image, for: .normal)
        backButton.tintColor = .white
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        
        self.offsetBottom.constant = UIScreen.main.bounds.height - self.dexcriptionLabel.frame.height
    }
    
    // MARK: - Button actions -
    
    @IBAction func goBack() {
        self.navigationController?.popViewController(animated: true)
    }
}

extension TAWHowToSubscribeViewController: UIScrollViewDelegate {
    
    func scrollViewDidScroll(_ scrollView: UIScrollView) {
        let offset = scrollView.contentOffset.y + scrollView.contentInset.top
        
        if offset > 0 && offset < minHeaderHeight {
            
            if offset <= 10 {
                let alpha: CGFloat = 1 - (offset / 10)
                for subview in headerView.subviews {
                    if subview.tag != 999 {
                        subview.alpha = alpha
                    }
                    
                    titleLabel.alpha = 0
                }
            }
            else {
                let alpha: CGFloat = 1 - (offset / minHeaderHeight)
                for subview in headerView.subviews {
                    if subview.tag != 999 {
                        subview.alpha = 0
                    }
                    
                    titleLabel.alpha = 1 - alpha
                }
            }
            
            let percentage: CGFloat = 1 - (offset/minHeaderHeight)
            headerViewHeight.constant = ((maxHeaderHeight - minHeaderHeight) * percentage) + minHeaderHeight
        }
        else if offset <= 0 {
            headerViewHeight.constant = maxHeaderHeight
            
            for subview in headerView.subviews {
                if subview.tag != 999 {
                    subview.alpha = 1
                }
                titleLabel.alpha = 0
            }
        }
        else if offset >= maxHeaderHeight {
            headerViewHeight.constant = minHeaderHeight
            
            for subview in headerView.subviews {
                if subview.tag != 999 {
                    subview.alpha = 0
                }
                titleLabel.alpha = 1
            }
        }
    }
}
