//
//  SubscriptionViewController.swift
//  TAW
//
//  Created by Apple on 27/10/21.
//  Copyright © 2021 PixelBeard. All rights reserved.
//

import UIKit
import StoreKit

enum SubscriptionsType{
    case premium,audio,video
}

struct SubscriptionDetails {
    var id:String
    var imgType:UIImage
    var subscriptionName:String
    var subscriptionType:SubscriptionType
    var planPrice:String
    var freeTrial:String
    var detail1:String
    var detail2:String
    var detail3:String
    var detail4:String
    var freeTime:String
    var subscriptionAuthLevel:String
    var product:SKProduct
}

var isSubscriptionPopupClose = false
class SubscriptionViewController: UIViewController {
    
    
    var flowLayout:ZoomAndSnapFlowLayout?
    
    
    @IBOutlet weak var collectionView: UICollectionView!
    @IBOutlet weak var lblTitle: UILabel!
    @IBOutlet weak var pageControl: UIPageControl!
    @IBOutlet weak var btnClose: UIButton!
    var arrDetails = [SubscriptionDetails]()
    var arrSubsList = [SubscriptionList]()
    var isFreeSubExpired = false
    var notificationCenter = NotificationCenter.default
    var selectedProduct:SubscriptionDetails?
    override func viewDidLoad() {
        super.viewDidLoad()
        setupUI()
        configureNotifications()
        getFreeSubscription()
       
        // Do any additional setup after loading the view.
    }
    
    func configureNotifications() {
        self.notificationCenter.addObserver(self, selector: #selector(purchasedCompleted), name: NSNotification.Name(rawValue: PBIAPClientPurchasedTokens), object: nil)
    }
    
    deinit {
        self.notificationCenter.removeObserver(self)
    }
    
    override func viewWillAppear(_ animated: Bool) {
    }
    
    func setupUI()
    {
        
        flowLayout = ZoomAndSnapFlowLayout(size:  CGSize(width: collectionView.frame.width/2 , height: collectionView.frame.height/1.7))
        collectionView.delegate = self
        collectionView.dataSource = self
        // flowLayout.itemSize = CGSize(width: collectionView.frame.width - 100, height: collectionView.frame.height)
        collectionView.collectionViewLayout = flowLayout!
        collectionView.contentInsetAdjustmentBehavior = .always
        pageControl.numberOfPages = arrDetails.count
        
    }
    
    @IBAction func btnCloseTap(_ sender: Any) {
        isSubscriptionPopupClose = true
        self.navigationController?.popViewController(animated: true)
    }
    
    func scrollViewDidScroll(_ scrollView: UIScrollView) {
        let visibleRect = CGRect(origin: self.collectionView.contentOffset, size: self.collectionView.bounds.size)
        let visiblePoint = CGPoint(x: visibleRect.midX, y: visibleRect.midY)
        if let visibleIndexPath = self.collectionView.indexPathForItem(at: visiblePoint) {
            self.pageControl.currentPage = visibleIndexPath.row
        }
    }
    
    @objc func purchasedCompleted()
    {
        if let product = selectedProduct
        {
            let productId = product.product.productIdentifier
            self.receiptValidation(productId: productId, authLevel: product.subscriptionAuthLevel)
        }
        // PBLoadingOverlay.shared.hideOverlay {
        // self.navigationController?.popViewController(animated: true)
        //  }
    }
    
    func activateFreeSubs(authLevel:String)
    {
        if Connectivity.isConnectedToInternet {
            let param = ["subscription_plan":authLevel]
            PBLoadingOverlay.shared.showOverlay(view: (self.view),
                                                withTitle: "")
            APIClient.activateFreeSubscription(parameters: param) { (jsonResponse, error) in
                DispatchQueue.main.async {
                    PBLoadingOverlay.shared.hideOverlay()
                }
                if jsonResponse["success"] as? Bool == true {
                    if let userJson = jsonResponse["user"] as? [String: Any] {
                        if let user = User(JSON: userJson) {
                            let needsUpdate = user.subscriptionLevel != LocalStorage.shared.user?.subscriptionLevel
                            user.authToken = LocalStorage.shared.user?.authToken
                            LocalStorage.shared.user = user
                            
                            if needsUpdate {
                                NotificationCenter.default.post(name: NSNotification.Name(rawValue: UserSubscriptionLevelHasChanged), object: self)
                                //                                self.forceRefresh()
                            }
                            self.navigationController?.popViewController(animated: true)
                        }
                    }
                }
                else {
                    let user = LocalStorage.shared.user
                    let needsUpdate = user?.subscriptionLevel != SubscriptionType.none
                    user?.subscriptions = []
                    LocalStorage.shared.user = user
                    // self.showSubscriptionView()
                    if needsUpdate {
                        NotificationCenter.default.post(name: NSNotification.Name(rawValue: UserSubscriptionLevelHasChanged), object: self)
                        //  self.forceRefresh()
                    }
                    
                    let message = jsonResponse["message"] as! String
                    if message == "Invalid Token" {
                        self.invalidateSession()
                    }
                    else
                    {
                        self.showAlertForAPIError(message)
                    }
                }
            }
            
        }
    }
    
    private func getFreeSubscription() {
        
        if Connectivity.isConnectedToInternet {
            PBLoadingOverlay.shared.showOverlay(view: (self.view),
                                                withTitle: "")
            APIClient.getFreeSubscription { (jsonResponse, error) in
                DispatchQueue.main.async {
                    PBLoadingOverlay.shared.hideOverlay()
                }
                
                if jsonResponse["success"] as? Bool == true {
                    if let subscriptions = jsonResponse["free_susbscriptions"] as? [[String: Any]] {
                        print(subscriptions)
                        self.arrSubsList.removeAll()
                        self.arrDetails.removeAll()
                        subscriptions.forEach { subs in
                            if let sub = SubscriptionList(JSON: subs){
                                print(sub)
                                
                                let planName = sub.plan_name ?? ""
                                print(planName)
                                if planName == "audio"
                                {
                                    self.appendAudioPlan(subs: sub)
                                }
                                else if planName == "video"
                                {
                                    self.appendVideoPlan(subs: sub)
                                }
                                else if planName == "premium"
                                {
                                    self.appendPremiumPlan(subs: sub)
                                }
                                self.arrSubsList.append(sub)
                                print(self.arrSubsList)
                            }
                            
                        }
                        self.collectionView.reloadData()
                    }
                }
                else {
                    let message = jsonResponse["message"] as! String
                    if message == "Invalid Token" {
                        self.invalidateSession()
                    }
                    else
                    {
                        self.showAlertForAPIError(message)
                    }
                }
            }
            
        }
    }
    
    func unitName(unit:Int,unitRawValue:UInt) -> String {
        switch unitRawValue {
        case 0: return (unit == 0 || unit == 1) ? "day" : "days"
        case 1: return (unit == 0 || unit == 1) ? "week" : "weeks"
        case 2: return (unit == 0 || unit == 1) ? "month" : "months"
        case 3: return (unit == 0 || unit == 1) ? "year" : "years"
        default: return ""
        }
    }
    
    func getEndDate(unit:Int,unitRawValue:UInt) -> Int
    {
        if unitRawValue == 0
        {
            return unit
        }
        else  if unitRawValue == 1
        {
            
        }
        return 0
    }
    
    
    
    func appendAudioPlan(subs:SubscriptionList)
    {
        //subs.plan_type == "free"
        
        
        if let product = IAPClient.shared.products.first(where: {$0.productIdentifier == RegisteredPurchase.audioOnly})
        {
            var freeTrialText = !isFreeSubExpired  ? "\(subs.plan_duration ?? "1") months free trial" : ""
            var btnTitle = !isFreeSubExpired ? "TRY \(subs.plan_duration ?? "1") MONTHS FOR FREE" : "BUY"
            let name = product.localizedTitle.replacingOccurrences(of: " ", with: "\n")
            print("name \(name )")
            let price = Utilities().localizedPrice(item: product)!
            print("price \(price)")
            if let period = product.introductoryPrice?.subscriptionPeriod {
                print("Start your \(period.numberOfUnits) \(unitName(unit: period.numberOfUnits, unitRawValue: period.unit.rawValue)) free trial")
                if period.numberOfUnits > 0
                {
                    freeTrialText = !isFreeSubExpired  ? "\(period.numberOfUnits) \(unitName(unit: period.numberOfUnits, unitRawValue: period.unit.rawValue)) free trial" : ""
                    btnTitle = !isFreeSubExpired ? "TRY \(period.numberOfUnits) \(unitName(unit: period.numberOfUnits, unitRawValue: period.unit.rawValue).uppercased()) FOR FREE" : "BUY"
                }
                else
                {
                    freeTrialText =  ""
                    btnTitle = "BUY"
                }
            }
            else
            {
                freeTrialText =  ""
                btnTitle = "BUY"
            }
            
            //        let duration = product?.subscriptionPeriod?.unit
            //        print("duration \(duration)")
            
            arrDetails.append( SubscriptionDetails(id: subs.id ?? "", imgType: UIImage(named: "subscriptionPlay")!, subscriptionName: name , subscriptionType: .audio, planPrice: price, freeTrial: freeTrialText, detail1: "Access to every podcast we produce…", detail2: "Previews and reviews of every Liverpool game…", detail3: "Immediate reaction to the news that matters to you…", detail4: "Interviews with specials guests, players and managers, past and present…", freeTime: btnTitle, subscriptionAuthLevel:  subs.subscription_auth_level ?? "", product: product))
        }
    }
    
    func appendVideoPlan(subs:SubscriptionList)
    {
        
        if let product = IAPClient.shared.products.first(where: {$0.productIdentifier == RegisteredPurchase.videoOnly})
        {
            var freeTrialText = !isFreeSubExpired ? "\(subs.plan_duration ?? "1") months free trial" : ""
            var btnTitle = !isFreeSubExpired ? "TRY \(subs.plan_duration ?? "1") MONTHS FOR FREE" : "BUY"
            let name = product.localizedTitle.replacingOccurrences(of: " ", with: "\n")
            print("name \(name )")
            let price = Utilities().localizedPrice(item: product)!
            print("price \(price)")
            if let period = product.introductoryPrice?.subscriptionPeriod {
                print("Start your \(period.numberOfUnits) \(unitName(unit: period.numberOfUnits, unitRawValue: period.unit.rawValue)) free trial")
                if period.numberOfUnits > 0
                {
                    freeTrialText = !isFreeSubExpired  ? "\(period.numberOfUnits) \(unitName(unit: period.numberOfUnits, unitRawValue: period.unit.rawValue)) free trial" : ""
                    btnTitle = !isFreeSubExpired ? "TRY \(period.numberOfUnits) \(unitName(unit: period.numberOfUnits, unitRawValue: period.unit.rawValue).uppercased()) FOR FREE" : "BUY"
                }
                else
                {
                    freeTrialText =  ""
                    btnTitle = "BUY"
                }
            }
            else
            {
                freeTrialText =  ""
                btnTitle = "BUY"
            }
            arrDetails.append( SubscriptionDetails(id: subs.id ?? "", imgType: UIImage(named: "subscriptionvideo")!, subscriptionName: name , subscriptionType: .video, planPrice: price, freeTrial: freeTrialText, detail1: "Access to every podcast and video show we produce…", detail2: "Previews and reviews of every Liverpool game…", detail3: "Immediate reaction to the news that matters to you…", detail4: "Interviews with specials guests, players and managers, past and present…", freeTime: btnTitle, subscriptionAuthLevel:  subs.subscription_auth_level ?? "", product: product))
        }
    }
    
    func appendPremiumPlan(subs:SubscriptionList)
    {
        if let product = IAPClient.shared.products.first(where: {$0.productIdentifier == RegisteredPurchase.premiumPackage})
        {
            var freeTrialText = !isFreeSubExpired ? "\(subs.plan_duration ?? "1") months free trial" : ""
            var btnTitle = !isFreeSubExpired ? "TRY \(subs.plan_duration ?? "1") MONTHS FOR FREE" : "BUY"
            let name = product.localizedTitle.replacingOccurrences(of: " ", with: "\n")
            print("name \(name )")
            let price = Utilities().localizedPrice(item: product)!
            print("price \(price)")
            let duration = product.introductoryPrice?.numberOfPeriods
            print("duration \(duration)")
            
            if let period = product.introductoryPrice?.subscriptionPeriod {
                print("Start your \(period.numberOfUnits) \(unitName(unit: period.numberOfUnits, unitRawValue: period.unit.rawValue)) free trial")
                if period.numberOfUnits > 0
                {
                    freeTrialText = !isFreeSubExpired  ? "\(period.numberOfUnits) \(unitName(unit: period.numberOfUnits, unitRawValue: period.unit.rawValue)) free trial" : ""
                    btnTitle = !isFreeSubExpired ? "TRY \(period.numberOfUnits) \(unitName(unit: period.numberOfUnits, unitRawValue: period.unit.rawValue).uppercased()) FOR FREE" : "BUY"
                }
                else
                {
                    freeTrialText =  ""
                    btnTitle = "BUY"
                }
            }
            else
            {
                freeTrialText =  ""
                btnTitle = "BUY"
            }
            arrDetails.append(SubscriptionDetails(id: subs.id ?? "", imgType: UIImage(named: "subscriptionPremium")!, subscriptionName: name , subscriptionType: .premium, planPrice: price, freeTrial:freeTrialText, detail1: "Access to every podcast and video show we produce…", detail2: "Previews and reviews of every Liverpool game…", detail3: "Immediate reaction to the news that matters to you…", detail4: "Interviews with specials guests, players and managers, past and present…", freeTime: btnTitle, subscriptionAuthLevel:  subs.subscription_auth_level ?? "", product: product))
        }
    }
    
    func addBoldText(fullString: NSString, boldPartOfString: NSString, font: UIFont!, boldFont: UIFont!) -> NSAttributedString {
        let nonBoldFontAttribute = [NSAttributedString.Key.font:font!]
        let boldFontAttribute = [NSAttributedString.Key.font:boldFont!]
        let boldString = NSMutableAttributedString(string: fullString as String, attributes:nonBoldFontAttribute)
        boldString.addAttributes(boldFontAttribute, range: fullString.range(of: boldPartOfString as String))
        return boldString
    }
    
    
}
extension SubscriptionViewController: UICollectionViewDataSource, UICollectionViewDelegate, UICollectionViewDelegateFlowLayout
{
    func numberOfSections(in collectionView: UICollectionView) -> Int {
        return 1
    }
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        return arrDetails.count
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "TAWSubscriptionCollectionViewCell", for: indexPath) as! TAWSubscriptionCollectionViewCell
        let data = arrDetails[indexPath.row]
        cell.configureData(details: data)
        cell.tapOnBtn = { [weak self] in
            //            if (self?.isFreeSubExpired ?? false)
            //            {
            self?.buyProduct(index: indexPath.row)
            //            }else
            //            {
            //            self?.activateFreeSubs(authLevel: data.subscriptionAuthLevel)
            //            }
            //self?.dismiss(animated: true)
        }
        return cell
    }
    
    func buyProduct(index:Int)  {
        print("purchase product \(self.arrDetails[index].product.productIdentifier)")
        
       
        
        // PBLoadingOverlay.shared.showOverlay(view: (self.navigationController?.view)!, withTitle: "Making purchase")
        selectedProduct = self.arrDetails[index]
        IAPClient.shared.subsPlanId = self.arrDetails[index].subscriptionAuthLevel
        IAPClient.shared.purchaseProduct(self.arrDetails[index].product)
    }
    
    func receiptValidation(productId:String,authLevel:String)
    {
        PBLoadingOverlay.shared.showOverlay(view: (self.view),
                                            withTitle: "")
        IAPClient.shared.receiptValidation(productId: productId) { (expDate, items) in
            //SVProgressHUD.dismiss()
            PBLoadingOverlay.shared.hideOverlay()
            guard items?.isEmpty == false else{
                print("not purchased")
                //  self.openSubscriptionView()
                //  self.checkFreeSubs(alertDelegate: alertDelegate)
                return
            }
            let  cancelDate = items?.last?.cancellationDate
            print("last item:\(items?.last)")
            print("cancelDate:\(cancelDate)")
            guard let expiry = expDate else {return}
            guard cancelDate == nil else{
                //  self.cancelPlanApi(cancelDate: "\(JSON(cancelDate?.timeIntervalSince1970 ?? 0).intValue)")
                return
            }
            let dateFormatter = DateFormatter()
//                    dateFormatter.dateFormat = "yyyy-MM-dd HH:mm:ss z"
//                    let date = dateFormatter.date(from: expiry)
                    dateFormatter.dateFormat = "yyyy-MM-dd"
                    let expiryDate =  dateFormatter.string(from: expiry)
            print("expiry:\(expiry)")
            print("expiryDate:\(expiryDate)")
            print("current :\(Date())")
            // let endDate =
            //  self.planName.text = "1 Month MeoSumbership at $4.99"
                                    if expiry > Date(){
                                        print("purchased and valid")
                                        self.activateSubscribtion(plan: authLevel, expiry: expiryDate)
                                    }
            //                        } else{
            //                            print("purchased and expired")
            //                            self.checkFreeSubs(alertDelegate: alertDelegate)
            //                        }
        }
    }
    
    func activateSubscribtion(plan:String,expiry:String)
    {
        let planType = self.selectedProduct?.freeTrial == "" ? "paid" : "free"// !isFreeSubExpired ? "free" : "paid"
        let param = [
            "subscription_plan" : plan,"subscription_type":planType,"subscription_expiry":expiry
        ] as [String : Any]
        APIClient.activateSubscription(parameters: param) { (jsonResponse, _) in
            if jsonResponse["success"] as? Bool == true {
                self.navigationController?.popViewController(animated: true)
                //                self.selectedProduct = nil
                //                self.transactionInProgress = false
                //                self.notifyOnPurchaseCompleted()
                
            } else {
                let message = jsonResponse["message"] as? String ?? ""
                print("Failed to credit account: \(message)")
            }
        }
    }
    
    
}
