//
//  TAWAlertViewController.swift
//  TAW
//
//  Created by Andrew Steven on 01/04/2019.
//  Copyright © 2019 PixelBeard. All rights reserved.
//

import UIKit

enum TAWAlertViewType {
    case purchase
    case balance
}

enum TAWAlertViewOption {
    case accept
    case decline
}

protocol TAWAlertViewControllerDelegate: class {
    func didSelectOption(_ option: TAWAlertViewOption, type: TAWAlertViewType)
}

class TAWAlertViewController: UIViewController {
    
    @IBOutlet weak var titleLabel: UILabel!
    @IBOutlet weak var descriptionLabel: UILabel!
    @IBOutlet weak var declineButton: PBButton!
    @IBOutlet weak var acceptButton: PBButton!
    
    weak var delegate: TAWAlertViewControllerDelegate?
    var type: TAWAlertViewType?
    var alertTitle: String?
    var alertDescription: String?
    
    override func viewDidLoad() {
        super.viewDidLoad()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        
        self.titleLabel.text = self.alertTitle
        self.descriptionLabel.text = self.alertDescription
    }
    
    public func set(title: String, description: String, type: TAWAlertViewType) {
        self.alertTitle = title
        self.alertDescription = description
        self.type = type
    }
    
    @IBAction func didTapAccept() {
        if let type = self.type {
            self.delegate?.didSelectOption(.accept, type: type)
        }
        self.dismiss(animated: false, completion: nil)
    }
    
    @IBAction func didTapDecline() {
        if let type = self.type {
            self.delegate?.didSelectOption(.decline, type: type)
        }
        self.dismiss(animated: false, completion: nil)
    }
}
