//
//  TAWNavigationController.swift
//  TAW
//
//  Created by Andrew Steven on 01/08/2019.
//  Copyright © 2019 PixelBeard. All rights reserved.
//

import UIKit

class TAWNavigationController: UINavigationController {

    override func viewDidLoad() {
        super.viewDidLoad()

        self.interactivePopGestureRecognizer?.delegate = self
        self.delegate = self
    }

    deinit {
        self.interactivePopGestureRecognizer?.delegate = nil
    }
}

extension TAWNavigationController: UINavigationControllerDelegate {
    func navigationController(_ navigationController: UINavigationController, didShow viewController: UIViewController, animated: Bool) {
        self.interactivePopGestureRecognizer?.isEnabled = self.viewControllers.count > 1
    }
}

extension TAWNavigationController: UIGestureRecognizerDelegate {
    func gestureRecognizer(_ gestureRecognizer: UIGestureRecognizer, shouldBeRequiredToFailBy otherGestureRecognizer: UIGestureRecognizer) -> Bool {
        return true
    }
}
