//
//  UIViewController+Extensions.swift
//  TAW
//
//  Created by Andrew Steven on 02/04/2019.
//  Copyright © 2019 PixelBeard. All rights reserved.
//

import UIKit
import RealmSwift

extension UIViewController {
    
    func instantiateVC(identifier: String) -> UIViewController {
        let storyboard = UIStoryboard(name: "Main", bundle: nil)
        let tawVC = storyboard.instantiateViewController(withIdentifier: identifier)
        return tawVC
    }
    
    public func showPurchaseTokens() {
        if let tawVC = instantiateVC(identifier: "buyTokensVC") as? TAWTokensViewController {
            self.navigationController?.pushViewController(tawVC, animated: true)
        }
    }
    
     func showHowToSubscribe(alertDelegate:TAWAlertViewDelegate) {
//        if let tawVC = instantiateVC(identifier: "howToSubscribeVC") as? TAWHowToSubscribeViewController {
//            self.navigationController?.pushViewController(tawVC, animated: true)
//        }
        self.checkFreeSubs(alertDelegate: alertDelegate)
    }
    
    public func showCreateAccount() {
        if let nav = instantiateVC(identifier: "signUpNav") as? TAWNavigationController {
            if let tawVC = nav.viewControllers.first as? TAWSignUpViewController {
                tawVC.convertingGuest = true
                self.navigationController?.present(nav, animated: true, completion: nil)
            }
        }
    }
    
    public func showUserWallet() {
        if let tawVC = instantiateVC(identifier: "purchasesVC") as? TAWPurchasesViewController {
            self.navigationController?.pushViewController(tawVC, animated: true)
        }
    }
    
    public func showPodcastPlayer() {
        if let tawVC = instantiateVC(identifier: "podcastPlayerVC") as? TAWPodcastPlayerViewController {
            self.navigationController?.present(tawVC, animated: true, completion: nil)
        }
    }
    
    public func showUserDownloads() {
        if let tawVC = instantiateVC(identifier: "downloadsVC") as? TAWDownloadsViewController {
            self.navigationController?.pushViewController(tawVC, animated: true)
        }
    }
    
    // This function will be called when an API call returns an invalid token response.
    // The user will session will be removed and the user will be logged out of the App.
    public func invalidateSession() {
        
        if let tabBarVC = self.parent?.parent as? TAWTabBarController {
            
            let params = [
                "device_token": LocalStorage.shared.oneSignalId ?? ""
            ]
            
            APIClient.logoutUser(parameters: params, completion: { (jsonResponse, _) in
                
                if PBAudioPlayer.shared.podcast != nil {
                    PBAudioPlayer.shared.removePodcast()
                }
                
                // Post notification to other views
                let notificationCenter = NotificationCenter.default
                notificationCenter.post(name: Notification.Name(rawValue: TAWUserHasLoggedOutNotification),
                                        object: self)
                
                // Remove the user details
                LocalStorage.shared.user = nil
                LocalStorage.shared.loggedIn = false

                // Display the Login
                tabBarVC.showLogin()
            })
        }
    }
    
   func checkFreeSubs(alertDelegate:TAWAlertViewDelegate)
    {
        if let user = LocalStorage.shared.user
        {
        if !isSubscriptionPopupClose
        {
            if user.showFreeSubscriptions ?? false//user.lastSubPlan == "" && user.isSubStatus == ""
            {
                self.showSubscriptionView(isFreeSubExpired: false)
            }
//            else if user.planType == "free" && user.isSubStatus != "active"
//            {
//                self.showFreeSubsExpiredAlert(alertDelegate: alertDelegate)
//            }
//            else if user.isSubStatus != "active" && user.planType == "paid"
//            {
            else{
                if user.lastSubPlan != ""
                {
                let productId = user.lastSubPlan == "audio" ? RegisteredPurchase.audioOnly :  user.lastSubPlan == "video" ? RegisteredPurchase.videoOnly : RegisteredPurchase.premiumPackage
                self.receiptValidation(productId: productId, authLevel: user.lastSubAuthLevel ?? "", alertDelegate: alertDelegate)
                }
            }
//        if let firstSubs = user.subscriptions?.first, firstSubs.subscriptionType == "free", firstSubs.subscriptionStatus != "active"
//        {
//           // self.showSubscriptionView()
//            self.showFreeSubsExpiredAlert()
//        }else  if (user.showFreeSubscriptions ?? false)
//        {
//            self.showSubscriptionView(isFreeSubExpired: false)
//        }
        }
        }
    }
    
    @objc func showSubscriptionView(isFreeSubExpired:Bool)
    {
     //   let user = LocalStorage.shared.user
       
                    DispatchQueue.main.asyncAfter(deadline: .now() + 1) {
                        let vc = self.storyboard?.instantiateViewController(withIdentifier: "SubscriptionViewController") as! SubscriptionViewController
                        vc.modalPresentationStyle = .fullScreen
                        vc.isFreeSubExpired = isFreeSubExpired
                        self.navigationController?.pushViewController(vc, animated: true)

                    }
        //}
    }
    
    func receiptValidation(productId:String,authLevel:String,alertDelegate:TAWAlertViewDelegate)
        {
            PBLoadingOverlay.shared.showOverlay(view: (self.view),
                                                withTitle: "")
            IAPClient.shared.receiptValidation(productId: productId) { (expDate, items) in
                        //SVProgressHUD.dismiss()
                        PBLoadingOverlay.shared.hideOverlay()
                        guard items?.isEmpty == false else{
                            print("not purchased")
                          //  self.openSubscriptionView()
                           // self.checkFreeSubs(alertDelegate: alertDelegate)
                            return
                        }
                        let  cancelDate = items?.last?.cancellationDate
                        print("last item:\(items?.last)")
                        print("cancelDate:\(cancelDate)")
                        guard let expiry = expDate else {return}
                        guard cancelDate == nil else{
                          //  self.cancelPlanApi(cancelDate: "\(JSON(cancelDate?.timeIntervalSince1970 ?? 0).intValue)")
                            return
                        }
                        print("expiry:\(expiry)")
                        let dateFormatter = DateFormatter()
    //                    dateFormatter.dateFormat = "yyyy-MM-dd HH:mm:ss z"
    //                    let date = dateFormatter.date(from: expiry)
                        dateFormatter.dateFormat = "yyyy-MM-dd"
                        let expiryDate =  dateFormatter.string(from: expiry)
                      //  self.planName.text = "1 Month MeoSumbership at $4.99"
                        if expiry > Date(){
                            let formatter = DateFormatter()
                            formatter.dateFormat = ""
                            print("purchased and valid")
                            self.activateSubs(plan:authLevel,planType: "paid",expiry: expiryDate )
                        } else{
                            print("purchased and expired")
                          //  self.checkFreeSubs(alertDelegate: alertDelegate)
                        }
                    }
        }
    
    func showFreeSubsExpiredAlert(alertDelegate:TAWAlertViewDelegate)  {
        let alertview = TAWAlertView.shared
        alertview.delegate = alertDelegate
        
        alertview.showAlertView(inView: self.navigationController!.view, alertStyle: .freeSubsExpired)
    }
    
    
    func activateSubs(plan:String,planType:String,expiry:String)
    {
        let param = [
            "subscription_plan" : plan
        ] as [String : Any]
        APIClient.activateSubscription(parameters: param) { (jsonResponse, _) in
            if jsonResponse["success"] as? Bool == true {
                
//                self.selectedProduct = nil
//                self.transactionInProgress = false
//                self.notifyOnPurchaseCompleted()
                
            } else {
                let message = jsonResponse["message"] as? String ?? ""
                print("Failed to credit account: \(message)")
            }
        }
    }
}
