//
//  LocalStorage.swift
//  TAW
//
//  Created by Andrew Steven on 07/01/2019.
//  Copyright © 2019 PixelBeard. All rights reserved.
//

import Foundation

enum UserDefaultsKeys: String {
    case loggedIn
    case user
    case firstLaunch
    case oneSignalId
    case uuid
    case previousUserId
}

class LocalStorage {
    
    // MARK: - Properties -
    static let shared = LocalStorage()
    var podcastsLastFetched: Date?
    var videosLastFetched: Date?
    var writingsLastFetched: Date?
    
    var firstLaunch: Bool {
        get {
            return UserDefaults.standard.isFirstLaunch()
        }
        set {
            UserDefaults.standard.setFirstLaunch(value: newValue)
        }
    }
    
    var loggedIn: Bool {
        get {
            return UserDefaults.standard.isLoggedIn()
        }
        set {
            UserDefaults.standard.setLoggedIn(value: newValue)
        }
    }
    
    var user: User? {
        get {
            return UserDefaults.standard.getUser()
        }
        set {
            UserDefaults.standard.setUser(value: newValue)
        }
    }
    
    var oneSignalId: String? {
        get {
            return UserDefaults.standard.getOneSignalId()
        }
        set {
            UserDefaults.standard.setOneSignalId(value: newValue)
        }
    }
    
    var uuid: String? {
        get {
            return UserDefaults.standard.getUUID()
        }
        set {
            UserDefaults.standard.setUUID(value: newValue)
        }
    }

    var previousUserId: String? {
        get {
            return UserDefaults.standard.getPreviousUserId()
        }
        set {
            UserDefaults.standard.setPreviousUserId(value: newValue)
        }
    }
    
    // Initialization
    private init() {
        
    }
}

extension UserDefaults {
    
    // MARK: First Launch
    func setFirstLaunch(value: Bool) {
        set(value, forKey: UserDefaultsKeys.firstLaunch.rawValue)
    }
    
    func isFirstLaunch() -> Bool {
        if value(forKey: UserDefaultsKeys.firstLaunch.rawValue) == nil {
            return true
        }
        return bool(forKey: UserDefaultsKeys.firstLaunch.rawValue)
    }
    
    // MARK: Logged In
    func setLoggedIn(value: Bool) {
        set(value, forKey: UserDefaultsKeys.loggedIn.rawValue)
    }
    
    func isLoggedIn() -> Bool {
        return bool(forKey: UserDefaultsKeys.loggedIn.rawValue)
    }
    
    // MARK: User
    func setUser(value: User?) {
        if value != nil {
            do {
                set(try PropertyListEncoder().encode(value), forKey: UserDefaultsKeys.user.rawValue)
            }
            catch {
                set(nil, forKey: UserDefaultsKeys.user.rawValue)
            }
        } else {
            removeObject(forKey: UserDefaultsKeys.user.rawValue)
        }
    }
    
    func getUser() -> User? {
        let storedObject: Data? = object(forKey: UserDefaultsKeys.user.rawValue) as? Data
        if storedObject != nil {
            do {
                let storedUser: User = try PropertyListDecoder().decode(User.self, from: (storedObject)!)
                return storedUser
            }
            catch {
                return nil
            }
        }
        return nil
    }
    
    // MARK: One Signal Id
    func setOneSignalId(value: String?) {
        set(value, forKey: UserDefaultsKeys.oneSignalId.rawValue)
    }
    
    func getOneSignalId() -> String? {
        if string(forKey: UserDefaultsKeys.oneSignalId.rawValue) != nil {
            return string(forKey: UserDefaultsKeys.oneSignalId.rawValue)
        }
        return nil
    }
    
    // MARK: UUID
    func setUUID(value: String?) {
        set(value, forKey: UserDefaultsKeys.uuid.rawValue)
    }
    
    func getUUID() -> String? {
        if string(forKey: UserDefaultsKeys.uuid.rawValue) != nil {
            return string(forKey: UserDefaultsKeys.uuid.rawValue)
        }
        return nil
    }

    // MARK: Previous User Id
    func setPreviousUserId(value: String?) {
        set(value, forKey: UserDefaultsKeys.previousUserId.rawValue)
    }

    func getPreviousUserId() -> String? {
        if string(forKey: UserDefaultsKeys.previousUserId.rawValue) != nil {
            return string(forKey: UserDefaultsKeys.previousUserId.rawValue)
        }
        return nil
    }
}
