//
//  Device.swift
//  TAW
//
//  Created by Andrew Steven on 25/02/2019.
//  Copyright © 2019 PixelBeard. All rights reserved.
//

import Foundation
import ObjectMapper
import RealmSwift

class Device: Object, Mappable {
    
    @objc dynamic var id = ""
    @objc dynamic var userId = ""
    @objc dynamic var partnerId = ""
    @objc dynamic var userAuthToken = ""
    @objc dynamic var active = ""
    @objc dynamic var userAgent = ""
    @objc dynamic var host = ""
    @objc dynamic var deviceIdentifier = ""
    @objc dynamic var deviceName = ""
    @objc dynamic var lastLoggedIn: String? = ""
    
    required convenience init?(map: Map) {
        self.init()
    }
    
    func mapping(map: Map) {
        id <- map["id"]
        userId <- map["user_id"]
        partnerId <- map["partner_id"]
        userAuthToken <- map["user_auth_token"]
        active <- map["active"]
        userAgent <- map["user_agent"]
        host <- map["host"]
        deviceIdentifier <- map["unique_device_identifier"]
        deviceName <- map["unique_device_name"]
        lastLoggedIn <- map["last_logged_in"]
    }
    
    var formattedDate: String {
        if lastLoggedIn == nil {
            lastLoggedIn = "2001-01-01 00:00:00"
        }
        
        let dateFormatter = DateFormatter()
        dateFormatter.dateFormat = "yyyy-MM-dd HH:mm:ss"
        dateFormatter.locale = Locale(identifier: NSLocale.current.identifier)
        dateFormatter.timeZone = TimeZone(abbreviation: "UTC")
        let date = dateFormatter.date(from: self.lastLoggedIn!)
        
        dateFormatter.locale = Locale(identifier: NSLocale.current.identifier)
        dateFormatter.timeZone = TimeZone.current
        dateFormatter.dateFormat = "dd MMM yyyy"
        return dateFormatter.string(from: date!)
    }
}
