//
//  Subscription.swift
//  TAW
//
//  Created by Andrew Steven on 16/01/2019.
//  Copyright © 2019 PixelBeard. All rights reserved.
//

import Foundation
import ObjectMapper

enum SubscriptionType {
    case none
    case premium
    case skeleton
    case audio
    case video
    
    var text: String {
        switch self {
        case .none:
            return "SUBSCRIPTION: NONE"
        case .premium:
            return "SUBSCRIPTION: FULL"
        case .audio:
            return "SUBSCRIPTION: AUDIO"
        case .skeleton:
            return "SUBSCRIPTION: TAW BASIC"
        case .video:
            return "SUBSCRIPTION: VIDEO"
        }
    }
}

class Subscription: Mappable, Codable {
    
    var authLevel: String?
    var expiryDate: String?
    var subscriptionStatus: String?
    var subscriptionType: String?
    
    required init?(map: Map) {
        
    }
    
    func mapping(map: Map) {
        authLevel <- map["subscription_auth_level"]
        expiryDate <- map["subscription_expiry"]
        subscriptionStatus <- map["subscription_status"]
        subscriptionType <- map["subscription_type"]
    }
}
