//
//  User.swift
//  TAW
//
//  Created by Andrew Steven on 07/01/2019.
//  Copyright © 2019 PixelBeard. All rights reserved.
//

import Foundation
import ObjectMapper

class User: Mappable, Codable {
    
    var authToken: String?
    var email: String?
    var firstName: String?
    var lastName: String?
    var username: String?
    var authLevel: String? // 3 - authorised, 2 - unauthorised
    var userId: String?
    var banned: String?
    var avatar: String?
    var guest: Bool
    var amemberUserId: String?
    var amemberEmail: String?
 
    var subscriptions: [Subscription]?
    var showFreeSubscriptions: Bool?
    var lastSubPlan:String?
    var isSubStatus:String?
    var planType:String?
    var lastSubAuthLevel:String?
    
    required init?(map: Map) {
        self.guest = false
    }
    
    func mapping(map: Map) {
        authToken <- map["auth_token"]
        userId <- map["user_id"]
        firstName <- map["firstname"]
        lastName <- map["lastname"]
        username <- map["username"]
        email <- map["email"]
        authLevel <- map["auth_level"]
        banned <- map["banned"]
        avatar <- map["avatar"]
        guest = false 
        amemberUserId <- map["amember_user_id"]
        amemberEmail <- map["amember_email"]
        subscriptions <- map["subscriptions"]
        showFreeSubscriptions <- map["show_free_subscription"]
        lastSubPlan <- map["last_sub_plan"]
        isSubStatus <- map["is_sub_status"]
        planType <- map["last_sub_type"]
        lastSubAuthLevel <- map["last_sub_auth"]
    }
    
    init(authToken: String) {
        self.authToken = authToken
        self.guest = true
    }
    
    var fullName: String {
        if self.guest {
            return "Guest User"
        }
        else if firstName?.count ?? 0 > 0 && lastName?.count ?? 0 > 0 {
            return "\(firstName!) \(lastName!)"
        }
        else if firstName?.count ?? 0 > 0 {
            return firstName!
        }
        else {
            return "No name on file"
        }
    }
    
    var subscriptionLevel: SubscriptionType {
        if let subs = self.subscriptions {
            if subs.contains(where: {$0.authLevel == "9"}) {
                return SubscriptionType.premium
            } else if subs.contains(where: {$0.authLevel == "8"}) && subs.contains(where: {$0.authLevel == "7"}) {
                return SubscriptionType.premium
            } else if subs.contains(where: {$0.authLevel == "8"}) {
                return SubscriptionType.audio
            } else if subs.contains(where: {$0.authLevel == "7"}) {
                return SubscriptionType.video
            } else if subs.contains(where: {$0.authLevel == "1"}) {
                return SubscriptionType.skeleton
            } else {
                return SubscriptionType.none
            }
        } else {
            return SubscriptionType.none
        }
    }
    
    var isSubscribedToAudio: Bool {
        if self.subscriptionLevel == .premium || self.subscriptionLevel == .audio || self.subscriptionLevel == .skeleton {
            return true
        }
        return false
    }
    
    var isSubscribedToVideo: Bool {
        if self.subscriptionLevel == .premium || self.subscriptionLevel == .video {
            return true
        }
        return false
    }
}
