//
//  Video.swift
//  TAW
//
//  Created by Andrew Steven on 13/03/2019.
//  Copyright © 2019 PixelBeard. All rights reserved.
//

import Foundation
import ObjectMapper
import RealmSwift

enum VideoType: String {
    case hosted = "hosted"
    case youtube = "youtube"
}

class Video: Object, Mappable {
    
    @objc dynamic var purchased: Bool = false
    @objc dynamic var postId: String = ""
    @objc dynamic var title: String = ""
    @objc dynamic var content: String = ""
    @objc dynamic var createdDate: String = ""
    @objc dynamic var cost: Int = 0
    @objc dynamic var videoUrl: String = ""
    @objc dynamic var thumbnailImage: String = ""
    @objc dynamic var mediumImage: String = ""
    @objc dynamic var largeImage: String = ""
    @objc dynamic var videoType: String = ""
    @objc dynamic var premium: Bool = false
    
    required convenience init?(map: Map) {
        self.init()
    }
    
    func mapping(map: Map) {
        postId <- map["post_id"]
        title <- map["title"]
        content <- map["content"]
        createdDate <- map["created_date"]
        purchased <- map["purchased"]
        videoUrl <- map["video_url"]
        thumbnailImage <- map["thumbnail_image"]
        mediumImage <- map["medium_image"]
        largeImage <- map["large_image"]
        videoType <- map["type"]
        if thumbnailImage.count == 0 {
            thumbnailImage = largeImage
        }
        if mediumImage.count == 0 {
            mediumImage = largeImage
        }
        cost <- map["cost"]
        if cost > 0 {
            premium = true
        }
    }
    
    var formattedCost: String {
        
        if cost > 1 {
            return "\(self.cost) Tokens"
        }
        return "\(self.cost) Token"
    }
    
    var formattedDate: String {
        
        let dateFormatter = DateFormatter()
        dateFormatter.dateFormat = "yyyy-MM-dd HH:mm:ss"
        dateFormatter.locale = Locale(identifier: NSLocale.current.identifier)
        dateFormatter.timeZone = TimeZone(abbreviation: "UTC")
        let date = dateFormatter.date(from: self.createdDate)
        
        dateFormatter.locale = Locale(identifier: NSLocale.current.identifier)
        dateFormatter.timeZone = TimeZone.current
        dateFormatter.dateFormat = "dd MMM yyyy"
        return dateFormatter.string(from: date!)
    }
    
    var safeURL: URL {
        let trimmed = self.videoUrl.trimmingCharacters(in: .whitespacesAndNewlines)
        return URL(string: trimmed)!
    }
    
    var isLocked: Bool {
        
        if self.premium {
            if self.purchased || (LocalStorage.shared.user?.isSubscribedToVideo)! {
                return false
            }
            return true
        }
        else {
            return false
        }
    }
    
    var type: VideoType {
        return VideoType(rawValue: self.videoType)!
    }
}
