//
//  IAPClient.swift
//  TAW
//
//  Created by Andrew Steven on 14/05/2019.
//  Copyright © 2019 PixelBeard. All rights reserved.
//

import Foundation
import StoreKit
import ObjectMapper
import SwiftyStoreKit

let PBIAPClientPurchasedTokens = "PBIAPClientPurchasedTokens"
let PBIAPTiersFetched = "PBIAPTiersFetched"

enum RegisteredPurchase {
    static let premiumPackage = "taw_premium_package_10"
    static let audioOnly = "taw_audio_package_7"
    static let videoOnly = "taw_video_package_7"
}


class IAPClient: NSObject {
    
    var sharedSecret = "38918c60c0b0463d991e8bd527d32641"
    let productIds: [String] = ["taw_iap_250_tokens", "taw_iap_500_tokens",RegisteredPurchase.premiumPackage,RegisteredPurchase.audioOnly,RegisteredPurchase.videoOnly]
    var products: [SKProduct] = []
    var subsProducts: [SKProduct] = []
    
    
    var subsPlanId:String?
    var hideLoader:(()->())?
    var selectedProduct: SKProduct?
    var transactionInProgress: Bool = false
    
    // MARK: - Properties -
    static let shared = IAPClient()
    
    // Initialization
    private override init() {
        super.init()
        SKPaymentQueue.default().add(self)
    }
    
    // MARK: - Data fetching -
    
    public func getInAppPurchaseTiers() {
        if Connectivity.isConnectedToInternet {
            if SKPaymentQueue.canMakePayments() {
                let productIdentifiers = NSSet(array: productIds)
                if let set = productIdentifiers as? Set<String> {
                    let productRequest = SKProductsRequest(productIdentifiers: set)
                    productRequest.delegate = self
                    productRequest.start()
                }
            } else {
                print("Cannot perform in-app purchases")
            }
        }
    }
    
    public func purchaseProduct(_ product: SKProduct) {
        
        if !self.transactionInProgress {
            self.selectedProduct = product
            self.transactionInProgress = true
            
            let payment = SKPayment(product: product)
            SKPaymentQueue.default().add(payment)
        } else {
            print("A transaction is already in progress")
        }
    }
    
    private func didPurchaseProduct(_ transaction: SKPaymentTransaction) {
        
        let productId = transaction.payment.productIdentifier
        print("Product Identifier: \(productId)")
      
        if productId == RegisteredPurchase.premiumPackage || productId == RegisteredPurchase.videoOnly || productId == RegisteredPurchase.audioOnly
        {
            activateSubs(plan: self.subsPlanId ?? "", transaction: transaction)
        }
//        else if productId == RegisteredPurchase.videoOnly
//        {
//            activateSubs(plan: self.subsPlanId ?? "", transaction: transaction)
//        }
//        else if productId == RegisteredPurchase.audioOnly
//        {
//            activateSubs(plan: self.subsPlanId ?? "", transaction: transaction)
//        }
        else
        {
            if self.selectedProduct == nil {
                if productId.contains("250") {
                    
                    let params: [String: Any] = [
                        "value": 250,
                        "title": "IAP \(250) Tokens",
                        "entry_variable": transaction.transactionIdentifier!
                    ]
                    
                    self.creditAccount(params, transaction: transaction)
                } else if productId.contains("500") {
                    
                    let params: [String: Any] = [
                        "value": 500,
                        "title": "IAP \(500) Tokens",
                        "entry_variable": transaction.transactionIdentifier!
                    ]
                    
                    self.creditAccount(params, transaction: transaction)
                }
                
                return
            } else {
                let tokenValue = Utilities().tokenValueForProduct(item: self.selectedProduct!)
                
                let params: [String: Any] = [
                    "value": Int(tokenValue)!,
                    "title": "IAP \(tokenValue) Tokens",
                    "entry_variable": transaction.transactionIdentifier!
                ]
                
                self.creditAccount(params, transaction: transaction)
            }
        }
    }
    
    func activateSubs(plan:String, transaction: SKPaymentTransaction)
    {
        SKPaymentQueue.default().finishTransaction(transaction)
        self.selectedProduct = nil
        self.transactionInProgress = false
        self.notifyOnPurchaseCompleted()
//        if LocalStorage.shared.loggedIn && plan != ""
//        {
//        let param = [
//            "subscription_plan" : plan
//        ] as [String : Any]
//        APIClient.activateSubscription(parameters: param) { (jsonResponse, _) in
//            if jsonResponse["success"] as? Bool == true {
//
//                SKPaymentQueue.default().finishTransaction(transaction)
//                self.selectedProduct = nil
//                self.transactionInProgress = false
//                self.notifyOnPurchaseCompleted()
//            } else {
//                let message = jsonResponse["message"] as? String ?? ""
//                print("Failed to credit account: \(message)")
//                SKPaymentQueue.default().finishTransaction(transaction)
//                self.selectedProduct = nil
//                self.transactionInProgress = false
//                self.notifyOnPurchaseCompleted()
//            }
//        }
//        }
//        else
//        {
//            self.selectedProduct = nil
//            self.transactionInProgress = false
//            self.notifyOnPurchaseCompleted()
//            SKPaymentQueue.default().finishTransaction(transaction)
//        }
    }
    
    private func creditAccount(_ params: [String: Any], transaction: SKPaymentTransaction) {
        
        APIClient.creditAccount(parameters: params) { (jsonResponse, _) in
            if jsonResponse["success"] as? Bool == true {
                
                SKPaymentQueue.default().finishTransaction(transaction)
                self.selectedProduct = nil
                self.transactionInProgress = false
                self.notifyOnPurchaseCompleted()
                
            } else {
                let message = jsonResponse["message"] as? String ?? ""
                print("Failed to credit account: \(message)")
            }
        }
    }
    
    private func notifyOnPurchaseCompleted() {
        NotificationCenter.default.post(name: Notification.Name(rawValue: PBIAPClientPurchasedTokens),
                                        object: self)
    }
    
    private func failedToPurchaseProduct(_ transaction: SKPaymentTransaction) {
        
                if var topController = UIApplication.shared.keyWindow?.rootViewController {
                    while let presentedViewController = topController.presentedViewController {
                        topController = presentedViewController
                    }
        
        //            // topController should now be your topmost view controller
                    PBBannerView.shared.showBanner(inView: topController.view, withTitle: "Failed to make purchase", style: .noInternet)
                }
        
        SKPaymentQueue.default().finishTransaction(transaction)
        self.selectedProduct = nil
        self.transactionInProgress = false
        
    }
    
    private func notifyOnIAPTiersFetched() {
        NotificationCenter.default.post(name: Notification.Name(rawValue: PBIAPTiersFetched),
                                        object: self)
    }
    
 
    func receiptValidation(productId:String,completion: @escaping(Date?,[ReceiptItem]?)->Void) {
        let appleValidator = AppleReceiptValidator(service: .sandbox, sharedSecret: self.sharedSecret)
        SwiftyStoreKit.verifyReceipt(using: appleValidator) { (result) in
            switch result {
            case .success(let receipt):
                let purchaseResult = SwiftyStoreKit.verifySubscription(ofType: .autoRenewable, productId: productId, inReceipt: receipt)
                
                switch purchaseResult {
                case .purchased(let expiryDate, let items):
                    completion(expiryDate , items)
                case .expired(let expiryDate, let items):
                    completion(expiryDate , items)
                case .notPurchased:
                    completion(nil , nil)
                }
                //                self.alertForVerifySubscriptions(purchaseResult, productIds: [RegisteredPurchase.inAppId])
                
            case .error:
                print("error")
                completion(nil , nil)
            }
        }
    }
    
}

// MARK: - SKProductsRequestDelegate -

extension IAPClient: SKProductsRequestDelegate {
    
    func productsRequest(_ request: SKProductsRequest, didReceive response: SKProductsResponse) {
        
        self.products = []
        if response.products.count > 0 {
            for product in response.products {
                
                self.products.append(product)
            }
            self.notifyOnIAPTiersFetched()
            print("Retrieved in-app purchases from the App Store")
        } else {
            print("There are no in-app purchases on the App Store")
        }
    }
}

// MARK: - SKPaymentTransactionObserver -

extension IAPClient: SKPaymentTransactionObserver {
    
    func paymentQueue(_ queue: SKPaymentQueue, updatedTransactions transactions: [SKPaymentTransaction]) {
        
        for transaction in transactions {
            
            switch transaction.transactionState {
                
            case .purchased:
                self.didPurchaseProduct(transaction)
                
            case .failed:
                self.failedToPurchaseProduct(transaction)
                
            default:
                print(transaction.transactionState.rawValue)
            }
        }
    }
}
