//
//  Utilities.swift
//  TAW
//
//  Created by Andrew Steven on 08/03/2019.
//  Copyright © 2019 PixelBeard. All rights reserved.
//

import Foundation
import UIKit
import StoreKit
import RealmSwift

class Utilities {
    
    public func deleteOtherUsersPodcastPositions() {
        let userId = LocalStorage.shared.user?.userId ?? ""
        do {
            let realm = try Realm()
            let podcastPositions = realm.objects(PodcastPosition.self).filter("userId != %@", userId)
            
            // Delete any podcast position data that is not the current users
            try realm.write {
                realm.delete(podcastPositions)
            }
        } catch let error {
            print("Error fetching podcast positions data: \(error.localizedDescription)")
        }
    }

    public func deletePreviousUsersDownloads() {
        do {
            // Fetch downloaded podcasts
            let realm = try Realm()
            let currentDownloads = realm.objects(Podcast.self).sorted(byKeyPath: "createdDate")
            let temp = Array(currentDownloads)
            let downloads = temp.filter {$0.isDownloaded == true}

            // Remove stored files from local directory
            for download in downloads {

                let fileUrl: URL? = download.getSaveFileUrl()
                if fileUrl != nil {
                    if FileManager.default.fileExists(atPath: fileUrl!.path) {
                        try FileManager.default.removeItem(atPath: fileUrl!.path)
                    }
                }
            }

            // Delete any downloaded podcasts
            try realm.write {
                realm.delete(currentDownloads)
            }
        }
        catch {
            print("Failed to delete downloaded podcasts")
        }
    }
    
    public func tokenValueForProduct(item: SKProduct) -> String {
        
        var title = item.localizedTitle
        title = title.replacingOccurrences(of: " Tokens", with: "")
        return title
    }
    
    public func priceStringForProduct(item: SKProduct) -> String? {
        
        let price = item.price
        
        if price == NSDecimalNumber(decimal: 0.00) {
            return "FREE"
        }
        else {
            let numberFormatter = NumberFormatter()
            let locale = item.priceLocale
            numberFormatter.numberStyle = .currency
            numberFormatter.locale = locale
            return numberFormatter.string(from: price)
        }
    }
    
    public func localizedPrice(item: SKProduct) -> String? {
        let formatter = NumberFormatter()
        formatter.formatterBehavior = .behavior10_4
        formatter.numberStyle = .currency
        formatter.locale = item.priceLocale
        
        let price = formatter.string(from: item.price)
        return price
    }
    
    public func currentAppVersion() -> String {
        if let version = Bundle.main.infoDictionary?["CFBundleShortVersionString"] as? String {
            return "VERSION \(version)"
        }
        return ""
    }
    
    public func parseArticle(_ content: String) -> [String] {
        
        let description = content.replacingOccurrences(of: "\n", with: "<br>")
        let decodedDescription = description.htmlDecoded
        
        if decodedDescription.contains("[img]") {
            
            var fixedString = decodedDescription.replacingOccurrences(of: "[/img]", with: "~-~-~")
            fixedString = fixedString.replacingOccurrences(of: "[img]", with: "~-~-~")
            let array = fixedString.components(separatedBy: "~-~-~")
            return array
        } else {
            return [decodedDescription]
        }
    }
    
    public func parseContent(_ content: String) -> [[String: Any]] {
        
        let description = content.replacingOccurrences(of: "\n", with: "<br>")
        let decodedDescription = description.htmlDecoded
        
        var contents: [[String: Any]] = []
        if decodedDescription.contains("[img]") {
            
            var fixedString = decodedDescription.replacingOccurrences(of: "[/img]", with: "~-~-~")
            fixedString = fixedString.replacingOccurrences(of: "[img]", with: "~-~-~")
            let array = fixedString.components(separatedBy: "~-~-~")
            
            for component in array {
                
                if let url = URL(string: component) {
                    contents.append(
                        [
                            "type": "image",
                            "value": url
                        ]
                    )
                }
                else {
                    contents.append(
                        [
                            "type": "string",
                            "value": component
                        ]
                    )
                }
            }
        } else {
            contents.append(
                [
                    "type": "string",
                    "value": decodedDescription
                ]
            )
        }
        
        return contents
    }
    
    public func resizeImage (sourceImage:UIImage, scaledToWidth: CGFloat) -> UIImage {
        let oldWidth = sourceImage.size.width
        let scaleFactor = scaledToWidth / oldWidth
        
        let newHeight = sourceImage.size.height * scaleFactor
        let newWidth = oldWidth * scaleFactor
        
        UIGraphicsBeginImageContext(CGSize(width:newWidth, height:newHeight))
        sourceImage.draw(in: CGRect(x:0, y:0, width:newWidth, height:newHeight))
        let newImage = UIGraphicsGetImageFromCurrentImageContext()
        UIGraphicsEndImageContext()
        return newImage!
    }
    
    func calculateHeightBasedOn(width: CGFloat, height: CGFloat) -> CGFloat {
        let scaleFactor = UIScreen.main.bounds.width / width
        let newHeight = height * scaleFactor
        return newHeight
    }
}

extension UILabel {
    
    
    // This function adds a background colour to the labels text
    func addBackgroundWrapper(color: UIColor) {
        
        let mutable = NSMutableAttributedString(string: self.text!)
        let startIndex = self.text!.startIndex
        mutable.addAttribute(.backgroundColor, value: color, range: NSRange(startIndex ..< self.text!.endIndex, in: self.text!))
        
        self.attributedText = mutable
    }
}

extension Double {
    
    public func isValid() -> Bool {
        if self.isNaN || self.isInfinite {
            return false
        }
        return true
    }
}
extension UIView {
func addBottomShadow() {
    layer.masksToBounds = false
    layer.shadowRadius = 4
    layer.shadowOpacity = 1
    layer.shadowColor = UIColor.gray.cgColor
    layer.shadowOffset = CGSize(width: 0 , height: 2)
//    layer.shadowPath = UIBezierPath(rect: CGRect(x: 0,
//                                                 y: bounds.maxY - layer.shadowRadius,
//                                                 width: bounds.width,
//                                                 height: layer.shadowRadius)).cgPath
}
}
