//
//  TAWFeedTableViewCell.swift
//  TAW
//
//  Created by Andrew Steven on 19/12/2018.
//  Copyright © 2018 PixelBeard. All rights reserved.
//

import UIKit

class TAWFeedTableViewCell: UITableViewCell {
    
    @IBOutlet weak var feedImageView: UIImageView!
    @IBOutlet weak var premiumImageView: UIImageView?
    @IBOutlet weak var dateLabel: UILabel!
    @IBOutlet weak var durationLabel: UILabel?
    @IBOutlet weak var titleLabel: UILabel?
    @IBOutlet weak var titleTextView: PBPaddedTextView?
    
    var writing: Writing?

    override func awakeFromNib() {
        super.awakeFromNib()
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)
    }
    
    override func prepareForReuse() {
        self.writing = nil
        self.feedImageView.image = UIImage(named: "placeholder_writing")
        self.dateLabel.text = ""
        self.durationLabel?.text = ""
        self.titleLabel?.text = ""
        self.titleTextView?.text = ""
    }

    func setWriting(_ writing: Writing, imageQuality: PodcastImageQuality) {
        
        self.writing = writing
        
        var image = ""
        switch imageQuality {
        case .thumbnail:
            image = self.writing?.thumbnailImage ?? ""
        case .medium:
            image = self.writing?.mediumImage ?? ""
        case .large:
            image = self.writing?.largeImage ?? ""
        }
        
        self.feedImageView.kf.setImage(with: URL(string: image),
                                       placeholder: UIImage(named: "placeholder_writing"),
                                       options: [.transition(.fade(0.2))])
        
        self.dateLabel.text = self.writing?.formattedDate
        
        self.titleTextView?.font = TAW.Fonts.dinPro24
        self.titleTextView?.textColor = UIColor.white
        self.titleTextView?.backgroundColor = UIColor.clear

        self.titleLabel?.text = writing.title
        self.titleTextView?.text = writing.title
        self.titleTextView?.setNeedsDisplay()

        if imageQuality == .large {
            self.setupDateBackground()
            self.titleLabel?.isHidden = true
            self.titleTextView?.isHidden = false
        } else {
            self.titleLabel?.isHidden = false
            self.titleTextView?.isHidden = true
        }
    }
    
    private func setupDateBackground() {
        let mutable = NSMutableAttributedString(string: dateLabel.text!)
        let startIndex = dateLabel.text!.startIndex
        mutable.addAttribute(.backgroundColor,
                             value: UIColor.black,
                             range: NSRange(startIndex..<dateLabel.text!.endIndex,
                                            in: dateLabel.text!))
        
        dateLabel.attributedText = mutable
    }
}
