//
//  TAWSubscriptionCollectionViewCell.swift
//  TAW
//
//  Created by Apple on 27/10/21.
//  Copyright © 2021 PixelBeard. All rights reserved.
//

import UIKit

class TAWSubscriptionCollectionViewCell: UICollectionViewCell {
    
    
    @IBOutlet weak var viewDot4: UIView!
    @IBOutlet weak var viewDot3: UIView!
    @IBOutlet weak var viewDot2: UIView!
    @IBOutlet weak var viewDot1: UIView!
    @IBOutlet weak var lblDetail4: UILabel!
    @IBOutlet weak var lblDetail3: UILabel!
    @IBOutlet weak var lblDetail2: UILabel!
    @IBOutlet weak var lblDetail1: UILabel!
    @IBOutlet weak var lblExtraPrice: UILabel!
    @IBOutlet weak var lblPriceMonth: UILabel!
    @IBOutlet weak var lblPlanPrice: UILabel!
    @IBOutlet weak var btnGetSubs: UIButton!
    @IBOutlet weak var viewVideoSubs: UIView!
    @IBOutlet weak var viewAudioSubs: UIView!
    @IBOutlet weak var viewPenSubs: UIView!
    @IBOutlet weak var lblType: UILabel!
    @IBOutlet weak var imgType: UIImageView!
    var tapOnBtn:(()->())?
    
    override func awakeFromNib() {
        viewDot1.backgroundColor = TAW.Colors.redButtonColor
        viewDot2.backgroundColor = TAW.Colors.redButtonColor
        viewDot3.backgroundColor = TAW.Colors.redButtonColor
        viewDot4.backgroundColor = TAW.Colors.redButtonColor
        btnGetSubs.backgroundColor = TAW.Colors.redButtonColor
        viewPenSubs.addBottomShadow()
        viewVideoSubs.addBottomShadow()
        viewAudioSubs.addBottomShadow()
    }

    
    @IBAction func btnGetSubsTap(_ sender: Any) {
        tapOnBtn?()
    }
    
    
    func configureData(details:SubscriptionDetails)
    {
        imgType.image = details.imgType
        lblType.text = details.subscriptionName
       viewPenSubs.backgroundColor = TAW.Colors.redButtonColor
        viewAudioSubs.backgroundColor = details.subscriptionType == .video ? TAW.Colors.greyButtonColor : TAW.Colors.redButtonColor
       viewVideoSubs.backgroundColor = details.subscriptionType == .audio ? TAW.Colors.greyButtonColor : TAW.Colors.redButtonColor
        lblPlanPrice.text = details.planPrice
        lblExtraPrice.text = details.freeTrial
        lblDetail1.text = details.detail1
        lblDetail2.text = details.detail2
        lblDetail3.text = details.detail3
        lblDetail4.text = details.detail4
        btnGetSubs.setTitle(details.freeTime, for: .normal)
    }
    
}
