//
//  TAWTokensCollectionViewCell.swift
//  TAW
//
//  Created by Andrew Steven on 25/02/2019.
//  Copyright © 2019 PixelBeard. All rights reserved.
//

import UIKit
import StoreKit

protocol TokensCellDelegate: class {
    func buy(product: SKProduct)
}

class TAWTokensCollectionViewCell: UICollectionViewCell {
    
    @IBOutlet var containerView: UIView!
    @IBOutlet weak var valueLabel: UILabel!
    @IBOutlet weak var titleLabel: UILabel!
    @IBOutlet weak var descriptionLabel: UILabel!
    @IBOutlet weak var buyButton: UIButton!
    
    var product: SKProduct?
    weak var delegate: TokensCellDelegate?
    
    override func awakeFromNib() {
        super.awakeFromNib()
        
        self.layer.shadowColor = UIColor.black.withAlphaComponent(0.1).cgColor
        self.layer.shadowRadius = 8
        self.layer.shadowOffset = CGSize(width: 0, height: 3)
        self.layer.shadowOpacity = 1
        self.layer.cornerRadius = 0
        
        self.titleLabel.font = UIDevice.isSmallDevice ? TAW.Fonts.dinPro22 : TAW.Fonts.dinPro29
        self.descriptionLabel.font = UIDevice.isSmallDevice ? TAW.Fonts.arialRegular14 : TAW.Fonts.arialRegular16
        self.buyButton.titleLabel?.font = (UIDevice.isSmallDevice ? TAW.Fonts.dinAlternate14 : TAW.Fonts.dinAlternate16)!
    }
    
    override func prepareForReuse() {
        self.product = nil
        self.valueLabel.text = ""
        self.titleLabel.text = ""
        self.descriptionLabel.text = ""
        self.buyButton.setTitle("", for: .normal)
    }
    
    func setProduct(_ product: SKProduct) {
        
        self.product = product
        
        self.titleLabel.text = self.product?.localizedTitle.uppercased()
        self.valueLabel.text = Utilities().tokenValueForProduct(item: self.product!)
        self.descriptionLabel.text = "\(self.product?.localizedTitle.lowercased() ?? "") to spend on The Anfield Wrap audio and video content."
        
        let price = Utilities().localizedPrice(item: product)!
        self.buyButton.setTitle("BUY FOR \(price)", for: .normal)
        
        self.descriptionLabel.setLineSpacing(lineSpacing: 1.0, lineHeightMultiple: 1.2)
        self.descriptionLabel.textAlignment = .center
    }
    
    @IBAction func buy() {
        if let product = self.product {
            self.delegate?.buy(product: product)
        }
    }
}
