<?php

class PBReusableModel_Analytics extends CI_Model {

	const ANALYTICS = 'taw_log';
	const PARTNERS = 'auth_partners';
	const LEDGER = 'pb_wallet_ledger';
	const USERS = 'users';
	const TOP_PODCASTS = 'vw_top_podcasts';
	const TOP_ARTICLES = 'vw_top_articles';
	const TOP_VIDEOS = 'temp_videos';

    function __construct() {
        parent::__construct();
		$this->load->helper('date');
		// $this->load->model('PBReusableModel_Partners', 'partners');
    }

	/* Homepage Stats Start */

	function getTopPodcastsByViews() {
		$params_array = $this->input->post();
		$this->load->database();
        $this->db->select('*');
        $this->db->from(self::TOP_PODCASTS);
        $query = $this->db->get();
		return $query->result();
	}

	function getTopArticlesByViews() {
		$params_array = $this->input->post();
		$this->load->database();
        $this->db->select('*');
        $this->db->from(self::TOP_ARTICLES);
        $query = $this->db->get();
		return $query->result();
	}

	function getTopVideosByViews() {
		$params_array = $this->input->post();
		$this->load->database();
        $this->db->select('*');
        $this->db->from(self::TOP_VIDEOS);
        $query = $this->db->get();
		return $query->result();
	}

	function countGuests() {
		$params_array = $this->input->post();
		$this->load->database();
        $this->db->select('count(*) as total');
        $this->db->from(self::USERS);
        $this->db->where('auth_level',1);
		if (isset($params_array['from_date'])) {
			$this->db->where('created_at >=', $params_array['from_date']);
		}
        if (isset($params_array['to_date'])) {
			$this->db->where('created_at <=', $params_array['to_date']);
		}
        $query = $this->db->get();
		return $query->row_array('total');
	}

	function countFullUsers() {
		$params_array = $this->input->post();
		$this->load->database();
		$this->db->select('count(*) as total');
        $this->db->from(self::USERS);
		$this->db->where('auth_level',3);
		$this->db->or_where('auth_level',9);
		if (isset($params_array['from_date'])) {
			$this->db->where('created_at >=', $params_array['from_date']);
		}
        if (isset($params_array['to_date'])) {
			$this->db->where('created_at <=', $params_array['to_date']);
		}
        $query = $this->db->get();
		return $query->row_array('total');
	}
	
	function countGiftedCredits() {
		$params_array = $this->input->post();
		$this->load->database();
		$this->db->select('sum(value) as total');
		$this->db->from(self::LEDGER);
		$this->db->where('type=','credit');
		$this->db->where('entry_variable=',0);
		if (isset($params_array['from_date'])) {
			$this->db->where('entry_date >=', $params_array['from_date']);
		}
        if (isset($params_array['to_date'])) {
			$this->db->where('entry_date <=', $params_array['to_date']);
		}
		$query = $this->db->get();
		return $query->row_array('total');
	}
	
	function countPurchasedCredits() {
		$params_array = $this->input->post();
		$this->load->database();
		$this->db->select('sum(value) as total');
		$this->db->from(self::LEDGER);
		$this->db->where('type=','credit');
		$this->db->where('length(entry_variable) >',1);
		if (isset($params_array['from_date'])) {
			$this->db->where('entry_date >=', $params_array['from_date']);
		}
        if (isset($params_array['to_date'])) {
			$this->db->where('entry_date <=', $params_array['to_date']);
		}
		$query = $this->db->get();
		return $query->row_array('total');
	}

	function countSpentCredits() {
		$params_array = $this->input->post();
		$this->load->database();
		$this->db->select('sum(value) as total');
		$this->db->from(self::LEDGER);
		$this->db->where('type=','purchase');
		if (isset($params_array['from_date'])) {
			$this->db->where('entry_date >=', $params_array['from_date']);
		}
        if (isset($params_array['to_date'])) {
			$this->db->where('entry_date <=', $params_array['to_date']);
		}
		$query = $this->db->get();
		return $query->row_array('total');
	}

	function countForAnalyticsType() {
		$params_array = $this->input->post();
		$this->load->database();
        $this->db->select('*');
        $this->db->from(self::ANALYTICS);
        $this->db->where('type',$params_array['type']);
		if (isset($params_array['from_date'])) {
			$this->db->where('date >=', $params_array['from_date']);
		}
        if (isset($params_array['to_date'])) {
			$this->db->where('date <=', $params_array['to_date']);
		}
        $query = $this->db->get();
        return $query->num_rows();
    }
	/* Homepage Stats End */

	// Datatable
	function analytics_count() {
		$this->load->database();
        $this->db->select('id');
        $this->db->from(self::ANALYTICS);
        $this->db->order_by('date','desc');
        $this->db->limit(1);
        $query = $this->db->get();
        return $query->row_array('id');
//        return $this->db->count_all('taw_log');
    }

    function analytics_count_for_type($type) {
		$this->load->database();
        $this->db->select('*');
        $this->db->from(self::ANALYTICS);
        $this->db->where('type',$type);
        $query = $this->db->get();
        return $query->num_rows();
    }

    function analytics_count_for_user($user) {
		$this->load->database();
        $this->db->select('*');
        $this->db->from(self::ANALYTICS);
        $this->db->where('user_id',$user);
        $query = $this->db->get();
        return $query->num_rows();
    }

	function datatables_allanalytics($limit,$start,$col,$dir) {
		$this->load->database();
        $this->db->select('*');
        $this->db->from(self::ANALYTICS);
		$this->db->limit($limit,$start);
		$this->db->order_by($col,$dir);
        $query = $this->db->get();
        if($query->num_rows()>0) {
            return $query->result();
        } else {
            return null;
        }
    }

	function datatables_analytics_search($limit,$start,$search,$col,$dir) {
		$this->load->database();
		$this->db->select('*');
		$this->db->from(self::ANALYTICS);
		$this->db->like('id',$search);
		$this->db->or_like('type',$search);
		$this->db->or_like('partner_id',$search);
		$this->db->limit($limit,$start);
		$this->db->order_by($col,$dir);
		$query = $this->db->get();
        if($query->num_rows()>0) {
            return $query->result();
        } else {
            return null;
        }
    }

	function datatables_analytics_search_count($search) {
		$this->load->database();
		$this->db->select('*');
		$this->db->from(self::ANALYTICS);
		$this->db->like('id',$search);
		$this->db->or_like('type',$search);
		$this->db->or_like('partner_id',$search);
		$query = $this->db->get();
        return $query->num_rows();
    }
	// Datatable

	public function recordAction($data){
        $this->load->database();
		$this->db->insert(self::ANALYTICS, $data);
		return true;
	}

	public function getActions() {
        $this->load->database();
        $this->db->select('*');
        $this->db->from(self::ANALYTICS);
        $query = $this->db->get();
        return $query->result();
	}

    public function getActionsPaginated($page,$limit) {
        // $limit = 50;
        $page = $page -1;
        $page = @($limit / $page);
        $this->load->database();
        $this->db->select('*');
        $this->db->from(self::ANALYTICS);
        $this->db->order_by('date','DESC');
        $this->db->limit($limit,$page);
        $query = $this->db->get();
        return $query->result();
	}

    public function getActionsByTypePaginated($page,$limit,$type) {
        $page = $page -1;
        $page = @($limit / $page);
        $this->load->database();
        $this->db->select('*');
        $this->db->from(self::ANALYTICS);
        $this->db->where('type',$type);
        $this->db->order_by('date','DESC');
        $this->db->limit($limit,$page);
        $query = $this->db->get();
        return $query->result();
	}

    public function getAnalyticsTypes() {
        $this->load->database();
        $this->db->select('distinct(type)');
        $this->db->from(self::ANALYTICS);
        $query = $this->db->get();
        return $query->result();
	}

    public function getAnalyticsForUser($page,$limit,$user_id) {
        $page = $page -1;
        $page = @($limit / $page);
        $this->load->database();
        $this->db->select('*');
        $this->db->from(self::ANALYTICS);
        $this->db->where('user_id',$user_id);
        $this->db->order_by('date','DESC');
        $this->db->limit($limit,$page);
        $query = $this->db->get();
        return $query->result();
	}
}
