<?php

class PBReusableModel_Global extends CI_Model {

    const RETAILERS = 'sq_retailers';
    const PRODUCTS = 'sq_products';
    const CODE_REDEEMS = 'sq_retailer_code_redeems';

    function __construct() {
        parent::__construct();
		$this->load->helper('date');
        // $this->load->model('PBReusableModel_Security','appsecurity');
        // $this->load->model('PBReusableModel_Analytics','analytics');
        // $this->load->model('PBReusableModel_Partner','partners');
        // $this->load->model('PBReusableModel_Global','globals');
    }

    public function sortArrayByKey($array,$key,$slope) {
        $sortArray = array();
        foreach($array as $plan){
            foreach($plan as $key=>$value){
                if(!isset($sortArray[$key])){
                    $sortArray[$key] = array();
                }
                $sortArray[$key][] = $value;
            }
        }
        $orderby = $key;
        array_multisort($sortArray[$orderby],$slope,$array);
        return $array;
    }

    public function recordAction($headers,$type,$user_id,$variable,$secondary_variable) {
        $partner_id = $this->partners->isTokenValid($headers["Api-Token"]);
		$this->analytics->recordAction(array(
			'date' => date('Y-m-d H:i:s'),
			'partner_id' => $partner_id[0]->id,
            'user_id' => $user_id,
			'type' => $type,
            'variable' => $variable,
            'secondary_variable' => $secondary_variable
		));
	}

    public function recordSystemAction($type,$variable,$secondary_variable) {
		$this->analytics->recordAction(array(
			'date' => date('Y-m-d H:i:s'),
			'partner_id' => 0,
            'user_id' => "ROOT",
			'type' => $type,
            'variable' => $variable,
            'secondary_variable' => $secondary_variable
		));
	}

    public function checkHeaders($user_id) {
        $headers = $this->input->request_headers();
        if (isset($headers['User-Api-Token']) && isset($headers['Api-Token'])) {
            $user_token = $headers['User-Api-Token'];
            $app_token = $headers['Api-Token'];
            if ($this->appsecurity->checkAuthenticationTokens($user_id,$app_token,$user_token)) {
                return true;
            } else {
                echo json_encode(array('success' => false, 'message' => 'Auth tokens were invalid'));
                exit(0);
            }
        } else {
            echo json_encode(array('success' => false, 'message' => 'No auth tokens were included within the request'));
            exit(0);
        }
    }

    public function checkUserToken($headers) {
		if (isset($headers['User-Api-Token'])) {
			$api_token = $headers['User-Api-Token'];
			$valid = $this->users->isTokenValid($api_token);
			if ($valid) {
				return $valid;
			} else {
				echo json_encode(array(
                    'success' => false,
                    'message' => '{ERROR: 0002} There was a problem. Please try again.',
                    'context' => 'The user auth token was invalid for the user.'
                ));
                exit(0);
			}
		} else {
			echo json_encode(array(
                'success' => false,
                'message' => '{ERROR: 0001} There was a problem. Please try again.',
                'context' => 'No user auth token was present in the request.'
            ));
            exit(0);
		}
	}

    public function getUserByHeaders() {
		$headers = $this->input->request_headers();
		if ($this->checkUserToken($headers)) {
			$user = $this->users->getFullUserByTokenFrontend($headers['User-Api-Token']);
			if ($user) {
                return $user;
			} else {
                return false;
            }
		} else {
            return false;
        }
	}
}
