<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class PBReusableModel_Mail extends CI_Model {

	function __construct() {
		parent::__construct();
		$this->load->helper('form');
		$this->load->helper('url');
		$this->load->library('email');
	}

	function sendMail() {

		$subject = $this->input->post('subject');
		$message = $this->input->post('message');

// Get full html:
		$body = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=' . strtolower(config_item('charset')) . '" />
    <title>' . html_escape($subject) . '</title>
    <style type="text/css">
        body {
            font-family: Arial, Verdana, Helvetica, sans-serif;
            font-size: 16px;
        }
    </style>
</head>
<body>
' . $message . '
</body>
</html>';
// Also, for getting full html you may use the following internal method:
//$body = $this->email->full_html($subject, $message);

		$result = $this->email
			->from('help@theanfieldwrap.com', 'The Anfield Wrap')
			->reply_to('helloworld@pixelbeard.co', 'The Anfield Wrap')    // Optional, an account where a human being reads.
			->to($this->input->post('to'))
			->subject($subject)
			->message($body)
			->send();

//		var_dump($result);
////		echo '<br />';
//		echo $this->email->print_debugger();
		return true;
		exit;
	}

	// function sendActivationCodeEmail($mail) {
	// 	$to = $mail['email'];
	// 	$subject = "Your activation code for The Anfield Wrap";
	// 	$message = '<p>Hello '.$to.',</p><p>Thank you for registering to The Anfield Wrap.</p><p>Your activation code is <strong>'.$mail['activation_code'].'</strong>.</p><p>Please return to the official The Anfield Wrap app and confirm your account.</p>';
	//
	// 	$body = $this->email->full_html($subject, $message);
	//
	// 	$result = $this->email
    //         ->from('will@pixelbeard.co', 'The Anfield Wrap')
    //         ->reply_to('will@pixelbeard.co', 'The Anfield Wrap')    // Optional, an account where a human being reads.
	// 		->to($to)
	// 		->subject($subject)
	// 		->message($body)
	// 		->send();
	//
	// 	return $result;
	// 	exit;
	// }

	function sendActivationCodeEmail($mail) {
		$to = $mail['email'];
		$subject = "Your activation code for The Anfield Wrap";
		$message = '<p>Hello '.$to.',</p><p>Thank you for registering to The Anfield Wrap.</p><p>Your activation code is <strong>'.$mail['activation_code'].'</strong>.</p><p>Please return to the official The Anfield Wrap app and confirm your account.</p>';

		$body = $this->email->full_html($subject, $message);

		$result = $this->email
            ->from('help@theanfieldwrap.com', 'The Anfield Wrap')
            ->reply_to('helloworld@pixelbeard.co', 'The Anfield Wrap')    // Optional, an account where a human being reads.
			->to($to)
			->subject($subject)
			->message($body)
			->send();

		return $result;
		exit;
	}

    function sendForgottenDetailsEmail($mail) {
		$to = $mail['email'];
		$subject = "Your recovery code for The Anfield Wrap";
		$message = '<p>Hello '.$to.',</p><p>Thank you for requesting a password reset for your The Anfield Wrap account.</p><p>Your recovery code is <strong>'.$mail['recovery_code'].'</strong>.</p><p>Please return to the official The Anfield Wrap app and confirm this recovery code.</p>';

		$body = $this->email->full_html($subject, $message);

		$result = $this->email
            ->from('help@theanfieldwrap.com', 'The Anfield Wrap')
            ->reply_to('helloworld@pixelbeard.co', 'The Anfield Wrap')    // Optional, an account where a human being reads.
			->to($to)
			->subject($subject)
			->message($body)
			->send();

		return $result;
		exit;
	}

    function sendResetPasswordEmail($email) {
		$to = $email;
		$subject = "Your The Anfield Wrap account password has now been reset";
		$message = '<p>Hello '.$to.',</p><p>Thank you for resetting your password for your The Anfield Wrap account.</p><p>Please return to the official The Anfield Wrap app and login using your new details.</p>';

		$body = $this->email->full_html($subject, $message);

		$result = $this->email
            ->from('help@theanfieldwrap.com', 'The Anfield Wrap')
            ->reply_to('helloworld@pixelbeard.co', 'The Anfield Wrap')    // Optional, an account where a human being reads.
			->to($to)
			->subject($subject)
			->message($body)
			->send();

		return $result;
		exit;
	}

    function sendChangeEmailEmail($mail) {
        $to = $mail['email'];
		$subject = "Your The Anfield Wrap account email needs verification";
		$message = '<p>Hello '.$to.',</p><p>Thank you for changing your email for your The Anfield Wrap account.</p><p>As we use your email address to keep you up-to-date on your account activities, we need to verify that it is active.</p><p>Your verification code is <strong>'.$mail['activation_code'].'</strong>.</p><p>Please return to the official The Anfield Wrap app and confirm your account.</p>';

		$body = $this->email->full_html($subject, $message);

		$result = $this->email
            ->from('help@theanfieldwrap.com', 'The Anfield Wrap')
            ->reply_to('helloworld@pixelbeard.co', 'The Anfield Wrap')    // Optional, an account where a human being reads.
			->to($to)
			->subject($subject)
			->message($body)
			->send();

		return $result;
		exit;
    }

}
