package co.pixelbeard.theanfieldwrap.data;

import com.google.gson.annotations.SerializedName;

import org.parceler.Parcel;

@Parcel(Parcel.Serialization.BEAN)
public class Article {

    @SerializedName("post_id")
    Long postId;
    @SerializedName("title")
    String title;
    @SerializedName("content")
    String content;
    @SerializedName("created_date")
    String createdDate;
    @SerializedName("featured")
    boolean featured;
    @SerializedName("author")
    String author;
    @SerializedName("thumbnail_image")
    String thumbnail;
    @SerializedName("medium_image")
    String mediumImage;
    @SerializedName("large_image")
    String largeImage;

    public Article() {
    }

    public Article(Long postId, String title, String content, String createdDate,
                   boolean featured, String author, String thumbnail, String mediumImage, String largeImage) {

        this.postId = postId;
        this.title = title;
        this.content = content;
        this.createdDate = createdDate;
        this.featured = featured;
        this.author = author;
        this.thumbnail = thumbnail;
        this.mediumImage = mediumImage;
        this.largeImage = largeImage;
    }


    public Long getPostId() {
        return postId;
    }

    public void setPostId(Long postId) {
        this.postId = postId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getCreatedDate() {
        return createdDate;
    }

    public void setCreatedDate(String createdDate) {
        this.createdDate = createdDate;
    }

    public String getAuthor() {
        return author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getThumbnail() {
        return thumbnail;
    }

    public void setThumbnail(String thumbnail) {
        this.thumbnail = thumbnail;
    }

    public String getMediumImage() {
        return mediumImage;
    }

    public void setMediumImage(String mediumImage) {
        this.mediumImage = mediumImage;
    }

    public String getLargeImage() {
        return largeImage;
    }

    public void setLargeImage(String largeImage) {
        this.largeImage = largeImage;
    }

    public boolean isFeatured() {
        return featured;
    }

    public void setFeatured(boolean featured) {
        this.featured = featured;
    }
}
