package co.pixelbeard.theanfieldwrap.data;

import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;

public class Transaction {


    //            "value": "1",
//                "entry_date": "2019-03-07 16:42:35",
//                "transaction_type": "purchase",
//                "type": "podcast",
//                "object": {
//                      "post_id": "57379",
//                    "title": "Manchester United 0 Liverpool 0: The Review",
//                    "content": "Liverpool climbed back to the top of the Premier League table with a goalless draw away to Manchester United.\r\n\r\nIn a game that can hardly be described as a spectacle both team kept each other at arms length for the most part with only a small amount of chances in the game for both sides.\r\n\r\nJoining Neil Atkinson for an in-depth look back at the fixture are Sean Rogers and Neil Jones.",
//                    "created_date": "2019-02-25 15:55:42",
//                    "modified_date": "2019-02-27 11:18:37",
//                    "premium": "1",
//                    "enclosure": "http://d1qmc81z5r9o20.cloudfront.net/REVIEW250219.m4a",
//                    "podcast_full_url": "http://d1qmc81z5r9o20.cloudfront.net/REVIEW250219.m4a",
//                    "thumbnail_image": "https://www.theanfieldwrap.com/uploads/2019/02/P190224-037-Man_Utd_Liverpool-200x144.jpg",
//                    "medium_image": "https://www.theanfieldwrap.com/uploads/2019/02/P190224-037-Man_Utd_Liverpool-400x289.jpg",
//                    "large_image": "https://www.theanfieldwrap.com/uploads/2019/02/P190224-037-Man_Utd_Liverpool-1024x739.jpg",
//                    "podcast_length": "51",
//                    "purchased": true


    @SerializedName("value")
    int value;
    @SerializedName("entry_date")
    String entryDate;
    @SerializedName("transaction_type")
    String transactionType;
    @SerializedName("type")
    String contentType;
    @SerializedName("title")
    String iapTitle;
    @SerializedName("object")
    JsonObject contentObject;

    public Transaction() {
    }

    public Transaction(int value, String entryDate, String transactionType, String contentType, String iapTitle, JsonObject contentObject) {
        this.value = value;
        this.entryDate = entryDate;
        this.transactionType = transactionType;
        this.contentType = contentType;
        this.iapTitle = iapTitle;
        this.contentObject = contentObject;
    }

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getEntryDate() {
        return entryDate;
    }

    public void setEntryDate(String entryDate) {
        this.entryDate = entryDate;
    }

    public String getTransactionType() {
        return transactionType;
    }

    public void setTransactionType(String transactionType) {
        this.transactionType = transactionType;
    }

    public String getContentType() {
        return contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getIapTitle() {
        return iapTitle;
    }

    public void setIapTitle(String iapTitle) {
        this.iapTitle = iapTitle;
    }

    public JsonObject getContentObject() {
        return contentObject;
    }

    public void setContentObject(JsonObject contentObject) {
        this.contentObject = contentObject;
    }
}
