package co.pixelbeard.theanfieldwrap.data;

import com.google.gson.annotations.SerializedName;

import org.parceler.Parcel;

import java.util.List;

@Parcel(Parcel.Serialization.BEAN)
public class User {

    @SerializedName("firstname")
    String firstName;
    @SerializedName("lastname")
    String lastName;
    @SerializedName("email")
    String email;
    @SerializedName("avatar")
    String avatar;
    @SerializedName("username")
    String username;
    @SerializedName("auth_level")
    int authLevel;
    @SerializedName("user_id")
    long userId;
    @SerializedName("banned")
    int banned;
    @SerializedName("amember_user_id")
    String aMemberUserId;
    @SerializedName("amember_email")
    String aMemberEmail;
    @SerializedName("subscriptions")
    List<Subscription> subscriptions;
    @SerializedName("show_free_subscription")
    Boolean showFreeSubscription;
    @SerializedName("is_sub_status")
    String isSubscriptionStatus;
    @SerializedName("last_sub_plan")
    String lastSubscriptionPlan;
    @SerializedName("last_sub_type")
    String getLastSubscriptionType;

    @SerializedName("last_sub_auth")
    String lastSubscriptionAuth;

    public User() {
    }

    public User(String firstName, String lastName, String email, String avatar, String username, int authLevel, long userId, int banned,
                String aMemberUserId, String aMemberEmail, List<Subscription> subscriptions) {
        this.firstName = firstName;
        this.lastName = lastName;
        this.email = email;
        this.avatar = avatar;
        this.username = username;
        this.authLevel = authLevel;
        this.userId = userId;
        this.banned = banned;
        this.aMemberUserId = aMemberUserId;
        this.aMemberEmail = aMemberEmail;
        this.subscriptions = subscriptions;
    }

    public String getFirstName() {
        return firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getAvatar() {
        return avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public int getAuthLevel() {
        return authLevel;
    }

    public void setAuthLevel(int authLevel) {
        this.authLevel = authLevel;
    }

    public long getUserId() {
        return userId;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    public int getBanned() {
        return banned;
    }

    public void setBanned(int banned) {
        this.banned = banned;
    }

    public String getaMemberUserId() {
        return aMemberUserId;
    }

    public void setaMemberUserId(String aMemberUserId) {
        this.aMemberUserId = aMemberUserId;
    }

    public String getaMemberEmail() {
        return aMemberEmail;
    }

    public void setaMemberEmail(String aMemberEmail) {
        this.aMemberEmail = aMemberEmail;
    }

    public List<Subscription> getSubscriptions() {
        return subscriptions;
    }

    public void setSubscriptions(List<Subscription> subscriptions) {
        this.subscriptions = subscriptions;
    }

    public Boolean getShowFreeSubscription() {
        return showFreeSubscription;
    }

    public void setShowFreeSubscription(Boolean showFreeSubscription) {
        this.showFreeSubscription = showFreeSubscription;
    }


    public String getIsSubscriptionStatus() {
        return isSubscriptionStatus;
    }

    public void setIsSubscriptionStatus(String isSubscriptionStatus) {
        this.isSubscriptionStatus = isSubscriptionStatus;
    }

    public String getLastSubscriptionPlan() {
        return lastSubscriptionPlan;
    }

    public void setLastSubscriptionPlan(String lastSubscriptionPlan) {
        this.lastSubscriptionPlan = lastSubscriptionPlan;
    }

    public String getGetLastSubscriptionType() {
        return getLastSubscriptionType;
    }

    public void setGetLastSubscriptionType(String getLastSubscriptionType) {
        this.getLastSubscriptionType = getLastSubscriptionType;
    }

    public String getLastSubscriptionAuth() {
        return lastSubscriptionAuth;
    }

    public void setLastSubscriptionAuth(String lastSubscriptionAuth) {
        this.lastSubscriptionAuth = lastSubscriptionAuth;
    }

}
