package co.pixelbeard.theanfieldwrap.editPassword;

import co.pixelbeard.theanfieldwrap.utils.BasePresenter;
import co.pixelbeard.theanfieldwrap.utils.BaseView;

public interface EditPasswordContract {

    interface View extends BaseView<Presenter> {

        void enableButton();

        void disableButton();

        void showInvalidPasswordError();

        void showPasswordsDontMatchError();

        void showIncorrectPasswordError();


        void showCurrentPasswordError();

        void showSingleButtonDialog(String error, String message);

    }

    interface Presenter extends BasePresenter {

        boolean validateFields(String currentPassword, String newPassword, String confirmPassword, boolean shouldShowError);

        void changePassword(String oldPassword, String newPassword);

        void backClicked();

        void saveClicked(String currentPassword, String newPassword, String confirmPassword);

    }
}