package co.pixelbeard.theanfieldwrap.forgotPassword;

import android.content.DialogInterface;

import androidx.fragment.app.FragmentManager;

import co.pixelbeard.theanfieldwrap.utils.BasePresenter;
import co.pixelbeard.theanfieldwrap.utils.BaseView;

public interface ForgotPasswordContract {

    interface View extends BaseView<Presenter> {

        void setForgotPasswordEmailFrag();

        void setForgotPasswordAuthFrag();

        void setForgotPasswordNewPasswordFrag();

        void finishForgotPasswordActivity();

        void showSingleButtonDialog(String title, String body, DialogInterface.OnDismissListener listener);

        void showResentToast();

    }

    interface Presenter extends BasePresenter {

        void nextClicked(FragmentManager fragMan);

        void requestPasswordReset(String email, boolean isResend);

        void resetPassword(String email, String recoveryCode, String password);

    }
}