package co.pixelbeard.theanfieldwrap.forgotPassword.fpEmail;


import android.content.Context;
import android.os.Bundle;
import android.text.Editable;
import android.text.InputType;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.rw.keyboardlistener.KeyboardUtils;

import butterknife.BindView;
import butterknife.ButterKnife;
import co.pixelbeard.theanfieldwrap.R;
import co.pixelbeard.theanfieldwrap.customView.PBInputField;
import co.pixelbeard.theanfieldwrap.forgotPassword.ForgotPasswordFragmentListener;
import co.pixelbeard.theanfieldwrap.utils.BaseFragment;
import co.pixelbeard.theanfieldwrap.utils.ConnectionUtils;
import co.pixelbeard.theanfieldwrap.utils.FontUtils;
import co.pixelbeard.theanfieldwrap.utils.TawController;

public class ForgotPasswordEmailFragment extends BaseFragment implements ForgotPasswordEmailContract.View {

    private static final String TAG = ForgotPasswordEmailFragment.class.getSimpleName();

    @BindView(R.id.pb_email)
    PBInputField pbEmail;

    private ForgotPasswordFragmentListener mListener;
    private Context mContext;
    private ForgotPasswordEmailContract.Presenter mPresenter;

    public ForgotPasswordEmailFragment() {
        // Required empty public constructor
    }

    public static ForgotPasswordEmailFragment newInstance() {
        ForgotPasswordEmailFragment fragment = new ForgotPasswordEmailFragment();
        Bundle args = new Bundle();

        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);

        mListener = (ForgotPasswordFragmentListener) context;
        mContext = context;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (getArguments() != null) {

        }

        new ForgotPasswordEmailPresenter(this);
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_forgot_password_email, container, false);
        ButterKnife.bind(this, view);
        return view;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);


        setInputFieldFont();
        setInputFieldImeListener();
        setInputFieldTextWatcher();

        mPresenter.validateFields(pbEmail.getText(), false);
    }

    @Override
    public void onResume() {
        super.onResume();
        TawController.setCurrentPage(TAG);
    }

    private void setInputFieldFont() {
        pbEmail.setInputType(InputType.TYPE_TEXT_VARIATION_EMAIL_ADDRESS);
        pbEmail.setTooltipTypeface(FontUtils.getInstance().getDinAlternateBold());
        pbEmail.setEditTextTypeface(FontUtils.getInstance().getDinAlternateBold());
        pbEmail.setTextInputTypeface(FontUtils.getInstance().getDinAlternateBold());
    }

    private void setInputFieldImeListener() {
        pbEmail.setImeActionListener((v, actionId, event) -> {
            KeyboardUtils.forceCloseKeyboard(pbEmail);
            return true;
        });
    }

    private void setInputFieldTextWatcher() {
        pbEmail.setTextWatcher(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                pbEmail.resetError();
                mPresenter.validateFields(pbEmail.getText(), false);
            }

            @Override
            public void afterTextChanged(Editable s) {

            }
        });
    }

    @Override
    public void isValidated() {
        boolean validated = true;

        if (!mPresenter.validateFields(pbEmail.getText(), true)) {
            validated = false;
        }


        if (validated) {
            mListener.setEmail(pbEmail.getText());
            mListener.requestPasswordReset();
        }
    }

    @Override
    public void showInvalidEmailError() {
        if (pbEmail != null && isAdded()) {
            pbEmail.showError(getString(R.string.invalid_email));
        }
    }

    @Override
    public void enableButton() {
        if (mListener != null && isAdded()) {
            mListener.enableButton();
        }
    }

    @Override
    public void disableButton() {
        if (mListener != null && isAdded()) {
            mListener.disableButton();
        }
    }

    @Override
    public void setPresenter(ForgotPasswordEmailContract.Presenter presenter) {
        if (presenter != null) {
            this.mPresenter = presenter;
        } else {
            throw new RuntimeException("Presenter is null");
        }
    }

    @Override
    public void goBack() {
        //Not needed
    }

    @Override
    public void showLoader(String text) {
        //Not needed
    }

    @Override
    public void hideLoader() {
        //Not needed
    }

    @Override
    public void onUnknownError(String error) {
        //Not needed
    }

    @Override
    public void onTimeout() {
        //Not needed
    }

    @Override
    public void onNetworkError() {
        //Not needed
    }

    @Override
    public void onConnectionError() {
        //Not needed
    }

    @Override
    public void logoutUser() {
        //Not needed
    }

    @Override
    public boolean checkConnection() {
        return ConnectionUtils.userHasConnection(mContext);
    }
}
