package co.pixelbeard.theanfieldwrap.forgotPassword.fpEmail;

import android.content.Context;

import co.pixelbeard.theanfieldwrap.utils.ValidationUtils;

public class ForgotPasswordEmailPresenter implements ForgotPasswordEmailContract.Presenter {


    private ForgotPasswordEmailContract.View mView;

    public ForgotPasswordEmailPresenter(ForgotPasswordEmailContract.View view) {
        if (view != null) {
            this.mView = view;

            mView.setPresenter(this);
        }
    }


    @Override
    public void subscribe() {

    }

    @Override
    public void unsubscribe() {

    }

    @Override
    public void clearUserData(Context context) {
        //Not needed
    }

    @Override
    public boolean validateFields(String email, boolean shouldShowError) {
        boolean valid = true;

        if (!ValidationUtils.isValidEmail(email)) {
            valid = false;
            if (shouldShowError) {
                mView.showInvalidEmailError();
            }
        }

        if (valid) {
            mView.enableButton();
        } else {
            mView.disableButton();
        }

        return valid;
    }
}
