package co.pixelbeard.theanfieldwrap.forgotPassword.fpNewPassword;


import android.content.Context;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.rw.keyboardlistener.KeyboardUtils;

import butterknife.BindView;
import butterknife.ButterKnife;
import co.pixelbeard.theanfieldwrap.R;
import co.pixelbeard.theanfieldwrap.customView.PBInputField;
import co.pixelbeard.theanfieldwrap.forgotPassword.ForgotPasswordFragmentListener;
import co.pixelbeard.theanfieldwrap.utils.BaseFragment;
import co.pixelbeard.theanfieldwrap.utils.ConnectionUtils;
import co.pixelbeard.theanfieldwrap.utils.FontUtils;
import co.pixelbeard.theanfieldwrap.utils.TawController;

public class ForgotPasswordNewPasswordFragment extends BaseFragment implements ForgotPasswordNewPasswordContract.View {

    private static final String TAG = ForgotPasswordNewPasswordFragment.class.getSimpleName();

    @BindView(R.id.pb_new_password)
    PBInputField pbNewPassword;
    @BindView(R.id.pb_confirm_password)
    PBInputField pbConfirmPassword;


    private ForgotPasswordFragmentListener mListener;
    private Context mContext;
    private ForgotPasswordNewPasswordContract.Presenter mPresenter;


    public ForgotPasswordNewPasswordFragment() {
        // Required empty public constructor
    }

    public static ForgotPasswordNewPasswordFragment newInstance() {
        ForgotPasswordNewPasswordFragment fragment = new ForgotPasswordNewPasswordFragment();
        Bundle args = new Bundle();
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);

        mListener = (ForgotPasswordFragmentListener) context;
        mContext = context;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (getArguments() != null) {
        }

        new ForgotPasswordNewPasswordPresenter(this);
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_forgot_passord_new_password, container, false);
        ButterKnife.bind(this, view);
        return view;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);


        setInputFieldFont();
        setInputFieldImeListener();
        setInputFieldTextWatcher();

        mPresenter.validateFields(pbNewPassword.getText(), pbConfirmPassword.getText(), false);
    }

    @Override
    public void onResume() {
        super.onResume();
        TawController.setCurrentPage(TAG);
    }

    private void setInputFieldFont() {
        pbNewPassword.setTooltipTypeface(FontUtils.getInstance().getDinAlternateBold());
        pbNewPassword.setEditTextTypeface(FontUtils.getInstance().getDinAlternateBold());
        pbNewPassword.setTextInputTypeface(FontUtils.getInstance().getDinAlternateBold());

        pbConfirmPassword.setTooltipTypeface(FontUtils.getInstance().getDinAlternateBold());
        pbConfirmPassword.setEditTextTypeface(FontUtils.getInstance().getDinAlternateBold());
        pbConfirmPassword.setTextInputTypeface(FontUtils.getInstance().getDinAlternateBold());
    }

    private void setInputFieldImeListener() {
        pbNewPassword.setImeActionListener((v, actionId, event) -> {
            pbConfirmPassword.requestTheFocus();
            return true;
        });

        pbConfirmPassword.setImeActionListener((v, actionId, event) -> {
            KeyboardUtils.forceCloseKeyboard(pbConfirmPassword);
            return true;
        });
    }

    private void setInputFieldTextWatcher() {
        pbNewPassword.setTextWatcher(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                pbNewPassword.resetError();
                mPresenter.validateFields(pbNewPassword.getText(), pbConfirmPassword.getText(), false);
            }

            @Override
            public void afterTextChanged(Editable s) {

            }
        });

        pbConfirmPassword.setTextWatcher(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                pbConfirmPassword.resetError();
                mPresenter.validateFields(pbNewPassword.getText(), pbConfirmPassword.getText(), false);
            }

            @Override
            public void afterTextChanged(Editable s) {

            }
        });

    }


    @Override
    public void isValidated() {
        boolean validated = true;

        if (!mPresenter.validateFields(pbNewPassword.getText(), pbConfirmPassword.getText(), true)) {
            validated = false;
        }


        if (validated && isAdded()) {
            mListener.setNewPassword(pbConfirmPassword.getText());
            mListener.resetPassword();
        }
    }

    @Override
    public void enableButton() {
        if (mListener != null && isAdded()) {
            mListener.enableButton();
        }
    }

    @Override
    public void disableButton() {
        if (mListener != null && isAdded()) {
            mListener.disableButton();
        }
    }

    @Override
    public void showInvalidPasswordError() {
        if (pbNewPassword != null && isAdded()) {
            pbNewPassword.showError(getString(R.string.invalid_password));
        }
    }

    @Override
    public void showPasswordsDontMatchError() {
        if (pbConfirmPassword != null && isAdded()) {
            pbConfirmPassword.showError(getString(R.string.password_no_match));
        }
    }


    @Override
    public void setPresenter(ForgotPasswordNewPasswordContract.Presenter presenter) {
        if (presenter != null) {
            this.mPresenter = presenter;
        } else {
            throw new RuntimeException("Presenter is null");
        }
    }

    @Override
    public void goBack() {
        //Not needed
    }

    @Override
    public void showLoader(String text) {
        //Not needed
    }

    @Override
    public void hideLoader() {
        //Not needed
    }

    @Override
    public void onUnknownError(String error) {
        //Not needed
    }

    @Override
    public void onTimeout() {
        //Not needed
    }

    @Override
    public void onNetworkError() {
        //Not needed
    }

    @Override
    public void onConnectionError() {
        //Not needed
    }

    @Override
    public void logoutUser() {
        //Not needed
    }

    @Override
    public boolean checkConnection() {
        return ConnectionUtils.userHasConnection(mContext);
    }
}
