package co.pixelbeard.theanfieldwrap.freeSubscription;

import android.os.Parcel;
import android.os.Parcelable;

public class SubscriptionModel implements Parcelable {

    private String title;
    private String description;
    private String subscriptionType;
    private String planType;
    private int userSubscriptionType;
    private String duration;
    private String planAmount;

    public String getPlanName() {
        return planName;
    }

    public void setPlanName(String planName) {
        this.planName = planName;
    }

    private String planName;

    public SubscriptionModel(String title, String planName, String description, String subscriptionType, int userSubscriptionType,
                             String duration, String planType, String planAmount) {
        this.title = title;
        this.description = description;
        this.subscriptionType = subscriptionType;
        this.userSubscriptionType = userSubscriptionType;
        this.duration = duration;
        this.planType = planType;
        this.planAmount = planAmount;
        this.planName = planName;
    }

    protected SubscriptionModel(Parcel in) {
        title = in.readString();
        description = in.readString();
        subscriptionType = in.readString();
        userSubscriptionType = in.readInt();
        duration = in.readString();
        planType = in.readString();
        planAmount = in.readString();
        planName = in.readString();
    }

    public static final Creator<SubscriptionModel> CREATOR = new Creator<SubscriptionModel>() {
        @Override
        public SubscriptionModel createFromParcel(Parcel in) {
            return new SubscriptionModel(in);
        }

        @Override
        public SubscriptionModel[] newArray(int size) {
            return new SubscriptionModel[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    public String  getDuration() {
        return duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(title);
        parcel.writeString(description);
        parcel.writeString(subscriptionType);
        parcel.writeInt(userSubscriptionType);
        parcel.writeString(duration);
        parcel.writeString(planType);
        parcel.writeString(planAmount);
        parcel.writeString(planName);
    }

    public String getTitle() {
        return title;
    }

    public String getDescription() {
        return description;
    }

    public String getSubscriptionType() {
        return subscriptionType;
    }

    public String getPlanType() {
        return planType;
    }

    public void setPlanType(String planType) {
        this.planType = planType;
    }

    public String getPlanAmount() {
        return planAmount;
    }

    public void setPlanAmount(String planAmount) {
        this.planAmount = planAmount;
    }
}
