package co.pixelbeard.theanfieldwrap.freeSubscription;

import co.pixelbeard.theanfieldwrap.data.source.DataRepository;
import co.pixelbeard.theanfieldwrap.networking.CallbackWrapper;

public class SubscriptionPresenter implements SubscriptionContract.Presenter {

    private SubscriptionContract.View mView;
    private DataRepository mRepo;

    public SubscriptionPresenter(SubscriptionContract.View view, DataRepository repo) {
        if (view != null) {
            this.mView = view;
            this.mRepo = repo;
            mView.setPresenter(this);
        }
    }

    @Override
    public void activatePaidSubscription(String subscription_plan, String planType, int duration, String purchaseToken) {
        mView.showLoader("");
        mRepo.activePaidSubscription(subscription_plan, planType, duration, purchaseToken).subscribe(new CallbackWrapper<ActiveSubscriptionResponse>(mView) {
            @Override
            protected void onSuccess(ActiveSubscriptionResponse guestUserResponse) {
                if (mView != null) {
                    mView.onActivePaidSubscription(guestUserResponse);
                    mView.hideLoader();
                }
            }

            @Override
            protected void onSuccessFalse(ActiveSubscriptionResponse guestUserResponse) {
                if (mView != null) {
                    mView.showActivateError(guestUserResponse.getMessage());
                    mView.hideLoader();
                }
            }
        });
    }
}
