package co.pixelbeard.theanfieldwrap.home;

import android.content.DialogInterface;

import co.pixelbeard.theanfieldwrap.data.Article;
import co.pixelbeard.theanfieldwrap.data.Podcast;
import co.pixelbeard.theanfieldwrap.data.Video;
import co.pixelbeard.theanfieldwrap.data.responses.SubscriptionItemResponse;

/**
 * Created by Michael Stoddart
 * 29/12/2018.
 */
public interface HomeFragmentListener {

    void setPodcastDetailsFrag(Podcast podcast);

    void setPodcastDetailsFrag(Long podcastId);

    void setWritingDetailsFrag(Article article);

    void setWritingDetailsFrag(Long articleId);

    void setVideoDetailsFrag(Video video);

    void setVideoDetailsFrag(String videoId);

    void setDownloadsFrag();

    void setAccountDetailsFrag();

    void setEditEmailFrag();

    void setEditPasswordFrag();

    void setSettingsFrag();

    void setHowToSubscribeFrag(boolean hasClicked);

    void setWalletFrag();

    void setBuyTokensFragment();

    void startTermsActivity();

    void startPrivacyPolicyActivity();

    void startDevicesActivity();

    void showAudioPlayerOverlay(Podcast podcast, boolean shouldQueue);

    void goBack();

    void startWalkThroughActivity();

    void startSignUpActivityAsGuest();

    void startLoginActivityAsGuest();

    void showNoInternetHeader();

    void hideNoInternetHeader();

    void showMiniPlayer();

    void hideMiniPlayer();

    void showLoader(String text);

    void hideLoader();

    void showSingleButtonDialog(String title, String body, DialogInterface.OnDismissListener listener);

    void startPaidSubscriptionActivity(SubscriptionItemResponse itemResponse);

}
