package co.pixelbeard.theanfieldwrap.settings;

import android.content.Context;
import android.util.Log;

import co.pixelbeard.theanfieldwrap.data.responses.GenericResponse;
import co.pixelbeard.theanfieldwrap.data.responses.NotificationSettingsResponse;
import co.pixelbeard.theanfieldwrap.data.source.DataRepository;
import co.pixelbeard.theanfieldwrap.networking.CallbackWrapper;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;

public class SettingsPresenter implements SettingsContract.Presenter {

    private SettingsContract.View mView;
    private DataRepository mRepo;

    public SettingsPresenter(SettingsContract.View view, DataRepository repo) {
        if (view != null && repo != null) {
            this.mView = view;
            this.mRepo = repo;

            mView.setPresenter(this);
        }
    }


    @Override
    public void getUserSettings() {
        try {
            mView.setNotificationSettingsAdapter(mRepo.getUserSettingsLocal(), true);
            mView.disableSettings();
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (mView != null && mView.checkConnection()) {
            mView.showLoader("");

            mRepo.getUserSettings().subscribe(new CallbackWrapper<NotificationSettingsResponse>(mView) {
                @Override
                protected void onSuccess(NotificationSettingsResponse notificationSettingsResponse) {
                    mRepo.saveUserSettings(notificationSettingsResponse.getSettings());
                    mView.setNotificationSettingsAdapter(notificationSettingsResponse.getSettings(), false);
                    mView.enableSettings();
                }

                @Override
                protected void onSuccessFalse(NotificationSettingsResponse notificationSettingsResponse) {
                    mView.showSingleButtonDialog("Error", notificationSettingsResponse.getMessage());
                }
            });

        } else {
            if (mView != null) {
                mView.onConnectionError();
            }
        }
    }

    @Override
    public void updateUserSetting(String type, int value) {
        mRepo.updateUserSetting(type, value).subscribe(new Observer<GenericResponse>() {
            @Override
            public void onSubscribe(Disposable d) {

            }

            @Override
            public void onNext(GenericResponse genericResponse) {
                //Dont really need to do anything except listen for no signal
            }

            @Override
            public void onError(Throwable e) {
                e.printStackTrace();
            }

            @Override
            public void onComplete() {

            }
        });
    }

    @Override
    public void clearUserData(Context context) {

//        mRepo.clearAllData(context);
        mRepo.logout().subscribe(new Observer<GenericResponse>() {
            @Override
            public void onSubscribe(Disposable d) {

            }

            @Override
            public void onNext(GenericResponse genericResponse) {
                Log.d("LOGOUT", genericResponse.getMessage());
            }

            @Override
            public void onError(Throwable e) {

            }

            @Override
            public void onComplete() {

            }
        });
    }


    @Override
    public void subscribe() {
        getUserSettings();
    }

    @Override
    public void unsubscribe() {
        this.mView = null;
        this.mRepo = null;
    }
}
