package co.pixelbeard.theanfieldwrap.signUp.emailPassword;

import android.content.DialogInterface;

import co.pixelbeard.theanfieldwrap.utils.BasePresenter;
import co.pixelbeard.theanfieldwrap.utils.BaseView;

public interface SignUpEmailPasswordContract {

    interface View extends BaseView<Presenter> {
        void showInvalidEmailError();

        void showEmailNotAvailableError();

        void showPasswordError();

        void enableButton();

        void disableButton();

        void setEmailAvailable(boolean isAvailable);

        void showNoConnectionHeader();

        void showCountryError();

        void showSingleButtonDialog(String title, String body, DialogInterface.OnDismissListener listener);
    }

    interface Presenter extends BasePresenter {
        boolean validateFields(String email, String password, String country, boolean shouldShowError);

        void checkEmailAvailable(String email);
    }
}