package co.pixelbeard.theanfieldwrap.utils;

/**
 * @author Michael Stoddart
 * Created on 04/01/2018.
 */

public interface BaseView<T> {

    void setPresenter(T presenter);

    void goBack();

    void showLoader(String text);

    void hideLoader();

    void onUnknownError(String error);

    void onTimeout();

    void onNetworkError();

    void onConnectionError();

    void logoutUser();

    boolean checkConnection();

}