package co.pixelbeard.theanfieldwrap.wallet;

import co.pixelbeard.theanfieldwrap.data.Wallet;
import co.pixelbeard.theanfieldwrap.utils.BasePresenter;
import co.pixelbeard.theanfieldwrap.utils.BaseView;

public interface WalletContract {

    interface View extends BaseView<Presenter> {
        void setWalletAdapter(Wallet wallet);

        void showUi();

        void setSwipeRefreshRefreshing(boolean refreshing);

        void showSingleButtonDialog(String error, String message);

    }

    interface Presenter extends BasePresenter {
        void getWallet(int pageNum);

        void refreshWallet();
    }
}