package co.pixelbeard.theanfieldwrap.writingDetails;

import android.view.LayoutInflater;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import co.pixelbeard.theanfieldwrap.R;
import co.pixelbeard.theanfieldwrap.writingDetails.viewholders.BaseContentViewHolder;
import co.pixelbeard.theanfieldwrap.writingDetails.viewholders.ContentImageViewHolder;
import co.pixelbeard.theanfieldwrap.writingDetails.viewholders.ContentTextViewHolder;

public class WritingContentAdapter extends RecyclerView.Adapter<BaseContentViewHolder> {

    private static final int IMAGE_CONTENT = 1;
    private static final int TEXT_CONTENT = 2;
    private String[] mContentArray;


    public WritingContentAdapter(String[] contentArray) {
        this.mContentArray = contentArray;
    }


    @NonNull
    @Override
    public BaseContentViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        LayoutInflater inflater = LayoutInflater.from(parent.getContext());

        switch (viewType) {
            case IMAGE_CONTENT:
                return new ContentImageViewHolder(inflater.inflate(R.layout.viewholder_image_content, parent, false));
            default:
                return new ContentTextViewHolder(inflater.inflate(R.layout.viewholder_text_content, parent, false));
        }
    }

    @Override
    public void onBindViewHolder(@NonNull BaseContentViewHolder holder, int position) {

        String content = mContentArray[holder.getAdapterPosition()];
        holder.bindView(content);
    }

    @Override
    public int getItemCount() {
        return mContentArray.length;
    }

    @Override
    public int getItemViewType(int position) {

        String content = mContentArray[position];

        if (content.contains("http")) {
            return IMAGE_CONTENT;
        } else {
            return TEXT_CONTENT;
        }
    }

    @Override
    public long getItemId(int position) {
        return position;
    }
}
