<?php

class AbsignupCampaign extends Am_Record
{
    const T_SIGNUP = 'signup';
    const T_MEMBER = 'member';
    const T_BOTH = 'both';

    function getRoster()
    {
        return $this->roster ? explode(',', $this->roster) : [];
    }
}

class AbsignupCampaignTable extends Am_Table
{
    protected $_key = 'campaign_id';
    protected $_table = '?_absignup_campaign';

    public function setActive(AbsignupCampaign $campaign)
    {
        switch ($campaign->campaign_type) {
            case Bootstrap_AbSignup::CAMPAIGN_THEME:
                $this->getAdapter()->query('UPDATE ?_absignup_campaign SET is_active=0');
                $campaign->updateQuick('is_active', 1);
                break;
            case Bootstrap_AbSignup::CAMPAIGN_SAVEDFORM:
                $this->getAdapter()->query('UPDATE ?_absignup_campaign SET is_active=0 WHERE campaign_type IN (?a)',
                    [Bootstrap_AbSignup::CAMPAIGN_SAVEDFORM, Bootstrap_AbSignup::CAMPAIGN_THEME]);
                $campaign->updateQuick('is_active', 1);
                break;
            case Bootstrap_AbSignup::CAMPAIGN_SAVEDFORM_CUSTOM:
                $this->getAdapter()->query('UPDATE ?_absignup_campaign SET is_active=0 WHERE campaign_type IN (?a)',
                    [Bootstrap_AbSignup::CAMPAIGN_THEME]);
                $campaign->updateQuick('is_active', 1);
                break;
        }
    }

    function getOptions($campaignType)
    {
        return $this->_db->selectCol("SELECT campaign_id as ARRAY_KEY, title
            FROM ?_absignup_campaign WHERE campaign_type IN (?a) ORDER BY title", (array)$campaignType);
    }
}