<?php

class Am_Newsletter_Plugin_Sendy extends Am_Newsletter_Plugin
{
    public function _initSetupForm(Am_Form_Setup $form)
    {
        $form->addText('url', array('class' => 'am-el-wide'))
            ->setLabel("Sendy URL\n" .
                'url of your setup of Sendy')
            ->addRule('required');
        $form->addSecretText('api_key')->setlabel(___('Sendy API key
        Your API key can be obtained from your main settings'));
        $form->addAdvcheckbox('debug')->setLabel('Debug Mode');
    }
    
    
    public function changeEmail(User $user, $oldEmail, $newEmail)
    {
        $ef = 'email';
        $list_ids = $this->getDi()->newsletterUserSubscriptionTable->getSubscribedIds($user->pk());
        $lists = array();
        foreach ($this->getDi()->newsletterListTable->loadIds($list_ids) as $list)
        {
            if ($list->plugin_id != $this->getId()) continue;
            $lists[] = $list->plugin_list_id;
        }
        $user->set($ef, $oldEmail)->toggleFrozen(true);
        $this->changeSubscription($user, array(), $lists);
        // subscribe again
        $user->set($ef, $newEmail)->toggleFrozen(false);
        $this->changeSubscription($user, $lists, array());
    }
    
    function isConfigured()
    {
        return (bool) $this->getConfig('url');
    }
    
    public function changeSubscription(User $user, array $addLists, array $deleteLists)
    {
        if (!$email = $user->get($this->getConfig('email_field', 'email'))) return true;
        
        foreach ($addLists as $listId) {
            $ret = $this->doRequest('/subscribe', array(
                'name' => $user->getName(),
                'email' => $email,
                'list' => $listId,
                'boolean' => 'true'
            ));
            if (!in_array($ret, ['1', 'Already subscribed.'])) return false;
            
        }
        foreach ($deleteLists as $listId) {
            $ret = $this->doRequest('/api/subscribers/delete.php', array(
                'email' => $email,
                'list_id' => $listId
            ));
            if (!in_array($ret, ['1', 'Subscriber does not exist.'])) return false;
        }
        return true;
    }

    function doRequest($path, array $vars)
    {
        $req = new Am_HttpRequest($this->getConfig('url') . $path, Am_HttpRequest::METHOD_POST);
        if($key = $this->getConfig('api_key')){
            $vars['api_key'] = $key;
        }
        $req->addPostParameter($vars);
        
        $res = $req->send();
        if($this->getConfig('debug'))
            $this->logDebug('request - '. json_encode($vars). ', response - '. $res->getBody());
        return $res->getBody();
    }
}