<?php
/**
 * @author Alexey Presnyakov <alex@cgi-central.net
 * @license Commercial
 */


class AdminUpgradeV6Controller extends Am_Mvc_Controller_Upgrade_Base
{
    use Am_Mvc_Controller_Upgrade_FileConnectorTrait;


    function getRelFileList($dirPath, $regex = '#.+#')
    {
        $it = new RecursiveDirectoryIterator($dirPath);
        $ret = [];
        foreach (new RecursiveIteratorIterator($it, RecursiveIteratorIterator::CATCH_GET_CHILD) as $file)
        {
            $fn = $file->getFilename();
            if ($file->isDir() && $fn[0] == '.') continue;
            if (!preg_match($regex, $file->getPathname())) continue;
            $ret[] = str_replace($dirPath, '', $file->getPathname());
        }
        return $ret;
    }

    function _pluginGetIdByPath($path)
    {
        $path = str_replace([
            'application/default/plugins/protect/',
            'application/default/plugins/payment/',
            'application/default/plugins/misc/',
            'application/default/plugins/storage/',
            'application/newsletter/plugins/',
            'application/cc/plugins/',
        ], '', $path);
        return preg_match('#^(.+?)\/#', $path, $regs) ? $regs[1] : basename($path, '.php');
    }

    function getFilelist()
    {
        // + move out all files that are known have been moved!
        // + move out all not enabled plugins that are known and not overwritten by upgrade
        // move out library files too!
        // change move procedure !

        $enabledPlugins = ['free'];
        foreach ($this->getDi()->config->get('plugins') as $_)
            $enabledPlugins = array_merge($enabledPlugins, (array)$_);
        $enabledPlugins = array_filter($enabledPlugins);

        $movePluginFiles = $this->getKnownPluginFileList();
        foreach ($movePluginFiles as $k => $v)
        {
            if (file_exists($v) &&
                preg_match('#(@am_payment_api|@am_protect_api|@am_plugin_api)#', file_get_contents($v)))
                    $enabledPlugins[] = $this->_pluginGetIdByPath($v); // filter out plugins that have @am_api_version
        }
        foreach ($movePluginFiles as $k => $v)
        {
            if (in_array($this->_pluginGetIdByPath($v), $enabledPlugins))
                unset($movePluginFiles[$k]); // filter out all enabled plugins - must be included into upgrade
        }

        $_  = $this->getDi()->store->getBlob('upgrade_files');
        if ($_ && $_ = json_decode($_, true))
        {
            $movePluginFiles = array_diff($movePluginFiles, array_keys($_)); // filter out files that were in upgrade!
        }
        $moveFiles = $this->getV5V6DiffFileList();

        foreach ($it = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($this->getDi()->root_dir, FilesystemIterator::KEY_AS_PATHNAME | FilesystemIterator::CURRENT_AS_FILEINFO | FilesystemIterator::SKIP_DOTS | RecursiveIteratorIterator::CATCH_GET_CHILD)) as $info)
        {
            if ($info->isFile())
                $existingFiles[] = $it->getSubPathname();
            if (preg_match('#^amember-.+\.phar$#', $info->getFilename()))
                $moveFiles[] = $it->getSubPathname();
        }

        $diff = array_intersect($existingFiles, array_merge($moveFiles, $movePluginFiles));

        sort($diff);
        return array_unique($diff);
    }

    function getMoveFilelist()
    {
        $ret = [];
        $from = 'application/default/plugins/protect/wordpress';
        $to = 'application/default/views/wp-themes';
        foreach ($it = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($this->getDi()->root_dir . '/' . $from,
                FilesystemIterator::KEY_AS_PATHNAME | FilesystemIterator::CURRENT_AS_FILEINFO |
                 RecursiveIteratorIterator::CATCH_GET_CHILD )) as $info)
        {
            if ($info->isFile() && empty($it->getSubPath()))
                continue;
            if ($info->getFilename() == '..' ) continue;
            if ($info->getFilename() == '.' && $it->getSubPath())
            {
                $p = $it->getSubPath();
                $ret[$from.'/'.$p] = $to . '/' . $p;
            } else {
                $p = $it->getSubPathname();
                if (!file_exists($this->getDi()->root_dir . '/' . $to . '/' . $p)) // do not overwrite existing files
                {
                    $ret[$from.'/'.$p] = $to.'/'.$p;
                }
            }
        }
        $ret = array_filter($ret, function($_) {return strpos($_, 'upload_to_wordpress') === false;}); //remove upload_to_wordpress
        arsort($ret); // files first, then folders
        return $ret;
    }

    function stepConfirmMoveFolders()
    {
        if (!empty($_POST['agree_to_move']))
        {
            $this->getSession()->addCopyFileList = $this->getFilelist();
            $this->getSession()->addCopyFileListCount = count($this->getSession()->addCopyFileList);
            $this->getSession()->moveFileList = $this->getMoveFilelist();
            $this->getSession()->moveFileListCount = count($this->getSession()->moveFileList);
            return true;
        }
        $prefix = $this->getSession()->renamePrefix;
        if (!$prefix) // check why changing !
        {
            $prefix = '-v6backup-'.$this->getDi()->security->randomString(6);
            $this->getSession()->renamePrefix = $prefix;
        }

        $filelist = array_filter($this->getFilelist(), function ($_){
            return !preg_match('#\/views\/public\/#', $_)
                && !preg_match('#application\/configs\/#', $_)
                && !preg_match('#default\/views\/.htaccess#', $_)
                && !preg_match('#default\/(themes|themes-admin)\/(readme.txt|bootstrap|solid-color|sample)#', $_);
        });
        $filelist = implode("\n", $filelist);

        $formAction = $this->getDi()->url('admin-upgrade-v6');

        $ahref = 'https://www.amember.com/docs/ReleaseNotes_6.0.0';

        $this->view->content = <<<CUT
    <div style="max-width: 800px; font-size: 130%; line-height: 120%;">
    <p>A lot of files have been renamed and moved in <a href="$ahref" target="_blank">aMember Pro version 6</a>.
    We have changed files structure for reliability and easier maintenance. We also reworked plugins subsystem
    to implement one-touch plugin download from our website.</p>
    
    <p>To prevent confusion and keep aMember directory clean, we have developed this
    script. All unused and outdated files will be moved to a new folder 
    <em>amember/upgrade-moved$prefix/</em> (you can remove this folder manually later, 
    after keeping full backup)</p> 
    </div>
    
    <form method="post" action="$formAction">
        <input type="submit" name="agree_to_move" value="Continue">
    </form>
CUT;

        $this->view->title   = ___('Move Folders');
        $this->view->display('admin/layout.phtml');
        $this->noDisplay = true;
        return false;
    }

    function stepV6MoveFolders()
    {
        $conn = $this->getFileConnector();
        if (!$conn)
            $this->_redirect('admin-upgrade-v6?reset=1');
        //$conn->setLogger($GLOBALS['cLogger']);

        $remoteRoot = $conn->getRoot();
        $prefix = $this->getSession()->renamePrefix;
        $remoteAppNew = "{$remoteRoot}/upgrade-moved{$prefix}";
        $localAppNew = $this->getDi()->root_dir . "/upgrade-moved{$prefix}";
        $remoteApp = "{$remoteRoot}";
        $localApp = $this->getDi()->root_dir;

        if (!$conn->connect())
            throw new Am_Exception_InputError("Could not connect to host");

        if (!$conn->mkdir("$remoteAppNew"))
        {
            if (!($ls = $conn->ls("$remoteAppNew"))) {
                throw new Am_Exception_InputError("Could not create remote dir [$remoteAppNew]");
            }
        }
        $fileListCount = $this->getSession()->addCopyFileListCount;
        $fileList = $this->getSession()->addCopyFileList;
        $copied = [];
        foreach ($fileList as $file)
        {
            // create folder at first
            $toCopy = [$file];
            $d = $file;
            while (($d = dirname($d)) && ($d != '.'))
                array_unshift($toCopy, $d);
            foreach ($toCopy as $pathAdd)
            {
                $l = "$localApp/$pathAdd";
                $r0 = "$remoteApp/$pathAdd";
                $r = "$remoteAppNew/$pathAdd";
                if (in_array($pathAdd, $copied)) continue; // already created this dir
                if (is_dir($l)) {
                    if (!file_exists("$localAppNew/$pathAdd") && !$conn->mkdir($r)) {
                        throw new Am_Exception_InputError("Could not create remote dir $r");
                    }
                } else {
                    //$GLOBALS['cLogger']->debug('put {l} {r}', ['l'=>$l,'r'=>$r]);
                    if (!$conn->rename($r0, $r)) {
                        if (filesize($l)) // ftp returns 0 when copying empty file
                            throw new Am_Exception_InputError("Could not copy $r0 => $r");
                    }
                }
                $copied[] = $pathAdd;
            }
        }
        //  now move custom files to new locations
        // multi-level dir creation not supported!!!!!!
        $fileList = $this->getSession()->moveFileList;
        $copied = [];
        foreach ($fileList as $fromFile => $pathAdd)
        {
            $l = "$localApp/$pathAdd";
            $l0 = "$localApp/$fromFile";
            $r = "$remoteApp/$pathAdd";
            $r0 = "$remoteApp/$fromFile";

            $l_dir = $localApp . '/' . dirname($pathAdd);
            $r_dir = $remoteApp . '/' . dirname($pathAdd);
            if (!file_exists($l_dir) && !$conn->mkdir($r_dir)) {
                throw new Am_Exception_InputError("Could not create remote dir $r_dir");
            }
            //$GLOBALS['cLogger']->debug('put {l} {r}', ['l'=>$l,'r'=>$r]);
            if (is_file($l0))
            {
                if (!$conn->rename($r0, $r))
                {
                    if (!file_exists($l))
                    {
                        ;
                    } // ftp returns 0 when copying empty file
                    //throw new Am_Exception_InputError("Could not copy $r0 => $r");
                }
            } else
            {
                if (!glob("$l0/*"))
                {
                    $conn->rmdir($r0);
                }
            }
            $copied[] = $pathAdd;
        }

        $this->getSession()->addCopyFileList = [];
        $this->getSession()->moveFileList = [];
        $this->getSession()->addCopyFileListCopied = $this->getSession()->addCopyFileListCount;
        $this->getSession()->addCopyFileListCount = 0;
        return true;
    }

    function _countFiles($dir)
    {
        $ret = 0;
        foreach (new RecursiveIteratorIterator(new RecursiveDirectoryIterator($dir), RecursiveIteratorIterator::CATCH_GET_CHILD) as $info)
            if ($info->isFile()) $ret++;
        return $ret;
    }

    protected function getSteps()
    {
        return [
            0 => ['stepSetCookie', ___('Create Session Key')],
            1 => ['stepConfirmMoveFolders', ___('Confirmation')],
            2 => ['stepGetRemoteAccess', ___('Retreive Access Parameters if necessary')],
            3 => ['stepV6MoveFolders', ___('Move Folders')],
            4 => ['stepUnsetVariable', 'Finish']
        ];
    }

    public function stepUnsetVariable()
    {
        $strings = $this->getStrings();

        $count = $this->getSession()->addCopyFileListCopied;
        $renamed = 'application' . $this->getSession()->renamePrefix;
        $url = $this->getDi()->url('admin');

        $this->getDi()->store->set('AM_UPGRADE_REQUIRES_RENAME_V6', 4); /// mark as finished

        $this->getSession()->unsetAll();

        $this->view->content = <<<CUT
    <div style="max-width: 800px; font-size: 130%; line-height: 120%;">
    <p><em>{$count}</em> unused files were sucessfully moved to folder <em>{$renamed}</em>.</p>
    <p>Wordpress custom theme files for aMember moved from <em>application/default/plugins/protect/wordpress/</em> to <em>application/default/views/wp-themes/</em>.</p>
    
    <a href="{$url}">Continue to Admin Dashboard</a> 
CUT;

        $this->view->title   = $strings['finished_title'];
        $this->view->display('admin/layout.phtml');
        $this->noDisplay = true;

    }

    protected function getSessionNamespace()
    {
        return 'amember-upgrade-v6';
    }

    protected function getStrings()
    {
        return [
            'finished_title' => ('Folders Move Finished'),
            'finished_text' => ('Folders Moved'),
            'title' => ('Move Folders'),
        ];
    }

    function getV5V6DiffFileList()
    {
        return [
            'library/composer/composer.json',
            'library/composer/vendor/league/oauth2-server/composer.json',
            'library/composer/vendor/league/oauth2-server/LICENSE',
            'library/composer/vendor/league/oauth2-server/src/Exception/UniqueTokenIdentifierConstraintViolationException.php',
            'library/composer/vendor/league/oauth2-server/src/Exception/OAuthServerException.php',
            'library/composer/vendor/league/oauth2-server/src/CryptKey.php',
            'library/composer/vendor/league/oauth2-server/src/ResourceServer.php',
            'library/composer/vendor/league/oauth2-server/src/AuthorizationValidators/AuthorizationValidatorInterface.php',
            'library/composer/vendor/league/oauth2-server/src/AuthorizationValidators/BearerTokenValidator.php',
            'library/composer/vendor/league/oauth2-server/src/Middleware/AuthorizationServerMiddleware.php',
            'library/composer/vendor/league/oauth2-server/src/Middleware/ResourceServerMiddleware.php',
            'library/composer/vendor/league/oauth2-server/src/ResponseTypes/AbstractResponseType.php',
            'library/composer/vendor/league/oauth2-server/src/ResponseTypes/ResponseTypeInterface.php',
            'library/composer/vendor/league/oauth2-server/src/ResponseTypes/RedirectResponse.php',
            'library/composer/vendor/league/oauth2-server/src/ResponseTypes/BearerTokenResponse.php',
            'library/composer/vendor/league/oauth2-server/src/AuthorizationServer.php',
            'library/composer/vendor/league/oauth2-server/src/Entities/TokenInterface.php',
            'library/composer/vendor/league/oauth2-server/src/Entities/ScopeEntityInterface.php',
            'library/composer/vendor/league/oauth2-server/src/Entities/RefreshTokenEntityInterface.php',
            'library/composer/vendor/league/oauth2-server/src/Entities/ClientEntityInterface.php',
            'library/composer/vendor/league/oauth2-server/src/Entities/AuthCodeEntityInterface.php',
            'library/composer/vendor/league/oauth2-server/src/Entities/AccessTokenEntityInterface.php',
            'library/composer/vendor/league/oauth2-server/src/Entities/UserEntityInterface.php',
            'library/composer/vendor/league/oauth2-server/src/Entities/Traits/ClientTrait.php',
            'library/composer/vendor/league/oauth2-server/src/Entities/Traits/TokenEntityTrait.php',
            'library/composer/vendor/league/oauth2-server/src/Entities/Traits/EntityTrait.php',
            'library/composer/vendor/league/oauth2-server/src/Entities/Traits/RefreshTokenTrait.php',
            'library/composer/vendor/league/oauth2-server/src/Entities/Traits/AuthCodeTrait.php',
            'library/composer/vendor/league/oauth2-server/src/Entities/Traits/AccessTokenTrait.php',
            'library/composer/vendor/league/oauth2-server/src/CryptTrait.php',
            'library/composer/vendor/league/oauth2-server/src/Repositories/RefreshTokenRepositoryInterface.php',
            'library/composer/vendor/league/oauth2-server/src/Repositories/ClientRepositoryInterface.php',
            'library/composer/vendor/league/oauth2-server/src/Repositories/AuthCodeRepositoryInterface.php',
            'library/composer/vendor/league/oauth2-server/src/Repositories/RepositoryInterface.php',
            'library/composer/vendor/league/oauth2-server/src/Repositories/UserRepositoryInterface.php',
            'library/composer/vendor/league/oauth2-server/src/Repositories/ScopeRepositoryInterface.php',
            'library/composer/vendor/league/oauth2-server/src/Repositories/AccessTokenRepositoryInterface.php',
            'library/composer/vendor/league/oauth2-server/src/RequestEvent.php',
            'library/composer/vendor/league/oauth2-server/src/RequestTypes/AuthorizationRequest.php',
            'library/composer/vendor/league/oauth2-server/src/Grant/PasswordGrant.php',
            'library/composer/vendor/league/oauth2-server/src/Grant/RefreshTokenGrant.php',
            'library/composer/vendor/league/oauth2-server/src/Grant/AbstractAuthorizeGrant.php',
            'library/composer/vendor/league/oauth2-server/src/Grant/ImplicitGrant.php',
            'library/composer/vendor/league/oauth2-server/src/Grant/ClientCredentialsGrant.php',
            'library/composer/vendor/league/oauth2-server/src/Grant/AuthCodeGrant.php',
            'library/composer/vendor/league/oauth2-server/src/Grant/AbstractGrant.php',
            'library/composer/vendor/league/oauth2-server/src/Grant/GrantTypeInterface.php',
            'library/composer/vendor/league/oauth2-server/phpstan.neon',
            'library/composer/vendor/league/event/composer.json',
            'library/composer/vendor/league/event/LICENCE',
            'library/composer/vendor/league/event/src/ListenerAcceptorInterface.php',
            'library/composer/vendor/league/event/src/ListenerInterface.php',
            'library/composer/vendor/league/event/src/EmitterInterface.php',
            'library/composer/vendor/league/event/src/Generator.php',
            'library/composer/vendor/league/event/src/EmitterAwareTrait.php',
            'library/composer/vendor/league/event/src/ListenerProviderInterface.php',
            'library/composer/vendor/league/event/src/Emitter.php',
            'library/composer/vendor/league/event/src/AbstractListener.php',
            'library/composer/vendor/league/event/src/EventInterface.php',
            'library/composer/vendor/league/event/src/ListenerAcceptor.php',
            'library/composer/vendor/league/event/src/EmitterTrait.php',
            'library/composer/vendor/league/event/src/EmitterAwareInterface.php',
            'library/composer/vendor/league/event/src/GeneratorTrait.php',
            'library/composer/vendor/league/event/src/Event.php',
            'library/composer/vendor/league/event/src/OneTimeListener.php',
            'library/composer/vendor/league/event/src/GeneratorInterface.php',
            'library/composer/vendor/league/event/src/AbstractEvent.php',
            'library/composer/vendor/league/event/src/CallbackListener.php',
            'library/composer/vendor/akrabat/ip-address-middleware/phpcs.xml',
            'library/composer/vendor/akrabat/ip-address-middleware/composer.json',
            'library/composer/vendor/akrabat/ip-address-middleware/LICENSE',
            'library/composer/vendor/akrabat/ip-address-middleware/src/IpAddress.php',
            'library/composer/vendor/pimple/pimple/composer.json',
            'library/composer/vendor/pimple/pimple/LICENSE',
            'library/composer/vendor/pimple/pimple/src/Pimple/Exception/UnknownIdentifierException.php',
            'library/composer/vendor/pimple/pimple/src/Pimple/Exception/FrozenServiceException.php',
            'library/composer/vendor/pimple/pimple/src/Pimple/Exception/InvalidServiceIdentifierException.php',
            'library/composer/vendor/pimple/pimple/src/Pimple/Exception/ExpectedInvokableException.php',
            'library/composer/vendor/pimple/pimple/src/Pimple/Container.php',
            'library/composer/vendor/pimple/pimple/src/Pimple/ServiceProviderInterface.php',
            'library/composer/vendor/pimple/pimple/src/Pimple/Psr11/ServiceLocator.php',
            'library/composer/vendor/pimple/pimple/src/Pimple/Psr11/Container.php',
            'library/composer/vendor/pimple/pimple/src/Pimple/Tests/ServiceIteratorTest.php',
            'library/composer/vendor/pimple/pimple/src/Pimple/Tests/PimpleTest.php',
            'library/composer/vendor/pimple/pimple/src/Pimple/Tests/Psr11/ServiceLocatorTest.php',
            'library/composer/vendor/pimple/pimple/src/Pimple/Tests/Psr11/ContainerTest.php',
            'library/composer/vendor/pimple/pimple/src/Pimple/Tests/PimpleServiceProviderInterfaceTest.php',
            'library/composer/vendor/pimple/pimple/src/Pimple/Tests/Fixtures/PimpleServiceProvider.php',
            'library/composer/vendor/pimple/pimple/src/Pimple/Tests/Fixtures/Invokable.php',
            'library/composer/vendor/pimple/pimple/src/Pimple/Tests/Fixtures/Service.php',
            'library/composer/vendor/pimple/pimple/src/Pimple/Tests/Fixtures/NonInvokable.php',
            'library/composer/vendor/pimple/pimple/src/Pimple/ServiceIterator.php',
            'library/composer/vendor/defuse/php-encryption/composer.json',
            'library/composer/vendor/defuse/php-encryption/LICENSE',
            'library/composer/vendor/defuse/php-encryption/psalm.xml',
            'library/composer/vendor/defuse/php-encryption/.php_cs',
            'library/composer/vendor/defuse/php-encryption/dist/Makefile',
            'library/composer/vendor/defuse/php-encryption/dist/box.json',
            'library/composer/vendor/defuse/php-encryption/dist/signingkey.asc',
            'library/composer/vendor/defuse/php-encryption/src/Exception/IOException.php',
            'library/composer/vendor/defuse/php-encryption/src/Exception/CryptoException.php',
            'library/composer/vendor/defuse/php-encryption/src/Exception/EnvironmentIsBrokenException.php',
            'library/composer/vendor/defuse/php-encryption/src/Exception/BadFormatException.php',
            'library/composer/vendor/defuse/php-encryption/src/Exception/WrongKeyOrModifiedCiphertextException.php',
            'library/composer/vendor/defuse/php-encryption/src/RuntimeTests.php',
            'library/composer/vendor/defuse/php-encryption/src/Key.php',
            'library/composer/vendor/defuse/php-encryption/src/Core.php',
            'library/composer/vendor/defuse/php-encryption/src/KeyOrPassword.php',
            'library/composer/vendor/defuse/php-encryption/src/Encoding.php',
            'library/composer/vendor/defuse/php-encryption/src/File.php',
            'library/composer/vendor/defuse/php-encryption/src/KeyProtectedByPassword.php',
            'library/composer/vendor/defuse/php-encryption/src/DerivedKeys.php',
            'library/composer/vendor/defuse/php-encryption/src/Crypto.php',
            'library/composer/vendor/egeloen/http-adapter/composer.json',
            'library/composer/vendor/egeloen/http-adapter/LICENSE',
            'library/composer/vendor/egeloen/http-adapter/.php_cs',
            'library/composer/vendor/egeloen/http-adapter/src/Guzzle6HttpAdapter.php',
            'library/composer/vendor/egeloen/http-adapter/src/SocketHttpAdapter.php',
            'library/composer/vendor/egeloen/http-adapter/src/BuzzHttpAdapter.php',
            'library/composer/vendor/egeloen/http-adapter/src/AbstractStreamHttpAdapter.php',
            'library/composer/vendor/egeloen/http-adapter/src/Guzzle3HttpAdapter.php',
            'library/composer/vendor/egeloen/http-adapter/src/Normalizer/BodyNormalizer.php',
            'library/composer/vendor/egeloen/http-adapter/src/Normalizer/HeadersNormalizer.php',
            'library/composer/vendor/egeloen/http-adapter/src/FopenHttpAdapter.php',
            'library/composer/vendor/egeloen/http-adapter/src/HttpAdapterTrait.php',
            'library/composer/vendor/egeloen/http-adapter/src/Parser/HeadersParser.php',
            'library/composer/vendor/egeloen/http-adapter/src/Parser/CookieParser.php',
            'library/composer/vendor/egeloen/http-adapter/src/Zend1HttpAdapter.php',
            'library/composer/vendor/egeloen/http-adapter/src/HttpAdapterException.php',
            'library/composer/vendor/egeloen/http-adapter/src/HttpAdapterFactory.php',
            'library/composer/vendor/egeloen/http-adapter/src/PsrHttpAdapterDecorator.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/Events.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/MultiRequestCreatedEvent.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/StatusCode/StatusCodeInterface.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/StatusCode/StatusCode.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/BasicAuth/BasicAuth.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/BasicAuth/BasicAuthInterface.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/Formatter/FormatterInterface.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/Formatter/Formatter.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/Cookie/CookieFactoryInterface.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/Cookie/CookieInterface.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/Cookie/CookieFactory.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/Cookie/Jar/CookieJar.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/Cookie/Jar/PersistentCookieJarInterface.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/Cookie/Jar/AbstractPersistentCookieJar.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/Cookie/Jar/SessionCookieJar.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/Cookie/Jar/FileCookieJar.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/Cookie/Jar/CookieJarInterface.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/Cookie/Cookie.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/RequestSentEvent.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/Subscriber/AbstractFormatterSubscriber.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/Subscriber/AbstractTimerSubscriber.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/Subscriber/CookieSubscriber.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/Subscriber/StopwatchSubscriber.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/Subscriber/RetrySubscriber.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/Subscriber/BasicAuthSubscriber.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/Subscriber/HistorySubscriber.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/Subscriber/LoggerSubscriber.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/Subscriber/StatusCodeSubscriber.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/Subscriber/RedirectSubscriber.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/MultiRequestErroredEvent.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/RequestErroredEvent.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/Timer/TimerInterface.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/Timer/Timer.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/Retry/Retry.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/Retry/Strategy/AbstractDelayedRetryStrategy.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/Retry/Strategy/AbstractRetryStrategyChain.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/Retry/Strategy/LinearDelayedRetryStrategy.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/Retry/Strategy/LimitedRetryStrategy.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/Retry/Strategy/RetryStrategyChainInterface.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/Retry/Strategy/CallbackRetryStrategy.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/Retry/Strategy/ConstantDelayedRetryStrategy.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/Retry/Strategy/ExponentialDelayedRetryStrategy.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/Retry/Strategy/RetryStrategyInterface.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/Retry/RetryInterface.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/Redirect/RedirectInterface.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/Redirect/Redirect.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/RequestCreatedEvent.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/History/Journal.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/History/JournalEntry.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/History/JournalInterface.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/History/JournalEntryInterface.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/History/JournalEntryFactoryInterface.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/History/JournalEntryFactory.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/AbstractEvent.php',
            'library/composer/vendor/egeloen/http-adapter/src/Event/MultiRequestSentEvent.php',
            'library/composer/vendor/egeloen/http-adapter/src/ConfigurationInterface.php',
            'library/composer/vendor/egeloen/http-adapter/src/HttpAdapterInterface.php',
            'library/composer/vendor/egeloen/http-adapter/src/MockHttpAdapter.php',
            'library/composer/vendor/egeloen/http-adapter/src/AbstractHttpAdapter.php',
            'library/composer/vendor/egeloen/http-adapter/src/ReactHttpAdapter.php',
            'library/composer/vendor/egeloen/http-adapter/src/Extractor/StatusLineExtractor.php',
            'library/composer/vendor/egeloen/http-adapter/src/Extractor/StatusCodeExtractor.php',
            'library/composer/vendor/egeloen/http-adapter/src/Extractor/ProtocolVersionExtractor.php',
            'library/composer/vendor/egeloen/http-adapter/src/PeclHttpAdapter.php',
            'library/composer/vendor/egeloen/http-adapter/src/StopwatchHttpAdapter.php',
            'library/composer/vendor/egeloen/http-adapter/src/Asset/AbstractUninstantiableAsset.php',
            'library/composer/vendor/egeloen/http-adapter/src/HttpfulHttpAdapter.php',
            'library/composer/vendor/egeloen/http-adapter/src/CurlHttpAdapter.php',
            'library/composer/vendor/egeloen/http-adapter/src/Configuration.php',
            'library/composer/vendor/egeloen/http-adapter/src/Zend2HttpAdapter.php',
            'library/composer/vendor/egeloen/http-adapter/src/Guzzle5HttpAdapter.php',
            'library/composer/vendor/egeloen/http-adapter/src/MultiHttpAdapterException.php',
            'library/composer/vendor/egeloen/http-adapter/src/Guzzle4HttpAdapter.php',
            'library/composer/vendor/egeloen/http-adapter/src/EventDispatcherHttpAdapter.php',
            'library/composer/vendor/egeloen/http-adapter/src/Message/InternalRequest.php',
            'library/composer/vendor/egeloen/http-adapter/src/Message/RequestInterface.php',
            'library/composer/vendor/egeloen/http-adapter/src/Message/Response.php',
            'library/composer/vendor/egeloen/http-adapter/src/Message/MessageFactory.php',
            'library/composer/vendor/egeloen/http-adapter/src/Message/ResponseInterface.php',
            'library/composer/vendor/egeloen/http-adapter/src/Message/MessageFactoryInterface.php',
            'library/composer/vendor/egeloen/http-adapter/src/Message/InternalRequestInterface.php',
            'library/composer/vendor/egeloen/http-adapter/src/Message/MessageInterface.php',
            'library/composer/vendor/egeloen/http-adapter/src/Message/MessageTrait.php',
            'library/composer/vendor/egeloen/http-adapter/src/Message/Request.php',
            'library/composer/vendor/egeloen/http-adapter/src/AbstractCurlHttpAdapter.php',
            'library/composer/vendor/egeloen/http-adapter/src/PsrHttpAdapterInterface.php',
            'library/composer/vendor/egeloen/http-adapter/src/CakeHttpAdapter.php',
            'library/composer/vendor/egeloen/http-adapter/src/FileGetContentsHttpAdapter.php',
            'library/composer/vendor/paragonie/random_compat/composer.json',
            'library/composer/vendor/paragonie/random_compat/psalm-autoload.php',
            'library/composer/vendor/paragonie/random_compat/LICENSE',
            'library/composer/vendor/paragonie/random_compat/psalm.xml',
            'library/composer/vendor/paragonie/random_compat/lib/random.php',
            'library/composer/vendor/paragonie/random_compat/dist/random_compat.phar.pubkey.asc',
            'library/composer/vendor/paragonie/random_compat/dist/random_compat.phar.pubkey',
            'library/composer/vendor/composer/installed.json',
            'library/composer/vendor/composer/LICENSE',
            'library/composer/vendor/composer/autoload_real.php',
            'library/composer/vendor/composer/ClassLoader.php',
            'library/composer/vendor/composer/autoload_classmap.php',
            'library/composer/vendor/composer/autoload_static.php',
            'library/composer/vendor/composer/autoload_files.php',
            'library/composer/vendor/composer/autoload_psr4.php',
            'library/composer/vendor/composer/autoload_namespaces.php',
            'library/composer/vendor/amazon/instantaccess-sdk-php/Makefile',
            'library/composer/vendor/amazon/instantaccess-sdk-php/composer.json',
            'library/composer/vendor/amazon/instantaccess-sdk-php/LICENSE',
            'library/composer/vendor/amazon/instantaccess-sdk-php/build.xml',
            'library/composer/vendor/amazon/instantaccess-sdk-php/NOTICE',
            'library/composer/vendor/amazon/instantaccess-sdk-php/phar-stub.php',
            'library/composer/vendor/amazon/instantaccess-sdk-php/src/Amazon/InstantAccess/Signature/CredentialStore.php',
            'library/composer/vendor/amazon/instantaccess-sdk-php/src/Amazon/InstantAccess/Signature/Signer.php',
            'library/composer/vendor/amazon/instantaccess-sdk-php/src/Amazon/InstantAccess/Signature/Credential.php',
            'library/composer/vendor/amazon/instantaccess-sdk-php/src/Amazon/InstantAccess/Signature/AuthorizationHeader.php',
            'library/composer/vendor/amazon/instantaccess-sdk-php/src/Amazon/InstantAccess/Signature/Request.php',
            'library/composer/vendor/amazon/instantaccess-sdk-php/src/Amazon/InstantAccess/Log/Logger.php',
            'library/composer/vendor/amazon/instantaccess-sdk-php/src/Amazon/InstantAccess/Utils/DateUtils.php',
            'library/composer/vendor/amazon/instantaccess-sdk-php/src/Amazon/InstantAccess/Utils/IOUtils.php',
            'library/composer/vendor/amazon/instantaccess-sdk-php/src/Amazon/InstantAccess/Utils/HttpUtils.php',
            'library/composer/vendor/amazon/instantaccess-sdk-php/src/Amazon/InstantAccess/Controllers/PurchaseController.php',
            'library/composer/vendor/amazon/instantaccess-sdk-php/src/Amazon/InstantAccess/Controllers/Controller.php',
            'library/composer/vendor/amazon/instantaccess-sdk-php/src/Amazon/InstantAccess/Controllers/AccountLinkingController.php',
            'library/composer/vendor/amazon/instantaccess-sdk-php/src/Amazon/InstantAccess/Serialization/RevokePurchaseResponse.php',
            'library/composer/vendor/amazon/instantaccess-sdk-php/src/Amazon/InstantAccess/Serialization/InstantAccessRequest.php',
            'library/composer/vendor/amazon/instantaccess-sdk-php/src/Amazon/InstantAccess/Serialization/SubscriptionDeactivateResponse.php',
            'library/composer/vendor/amazon/instantaccess-sdk-php/src/Amazon/InstantAccess/Serialization/InstantAccessResponse.php',
            'library/composer/vendor/amazon/instantaccess-sdk-php/src/Amazon/InstantAccess/Serialization/SubscriptionActivateResponse.php',
            'library/composer/vendor/amazon/instantaccess-sdk-php/src/Amazon/InstantAccess/Serialization/FulfillPurchaseResponse.php',
            'library/composer/vendor/amazon/instantaccess-sdk-php/src/Amazon/InstantAccess/Serialization/SubscriptionDeactivateRequest.php',
            'library/composer/vendor/amazon/instantaccess-sdk-php/src/Amazon/InstantAccess/Serialization/GetUserIdRequest.php',
            'library/composer/vendor/amazon/instantaccess-sdk-php/src/Amazon/InstantAccess/Serialization/GetUserIdResponse.php',
            'library/composer/vendor/amazon/instantaccess-sdk-php/src/Amazon/InstantAccess/Serialization/SubscriptionActivateRequest.php',
            'library/composer/vendor/amazon/instantaccess-sdk-php/src/Amazon/InstantAccess/Serialization/RevokePurchaseRequest.php',
            'library/composer/vendor/amazon/instantaccess-sdk-php/src/Amazon/InstantAccess/Serialization/Enums/Enum.php',
            'library/composer/vendor/amazon/instantaccess-sdk-php/src/Amazon/InstantAccess/Serialization/Enums/RevokePurchaseReasonValue.php',
            'library/composer/vendor/amazon/instantaccess-sdk-php/src/Amazon/InstantAccess/Serialization/Enums/SubscriptionActivateResponseValue.php',
            'library/composer/vendor/amazon/instantaccess-sdk-php/src/Amazon/InstantAccess/Serialization/Enums/InstantAccessOperationValue.php',
            'library/composer/vendor/amazon/instantaccess-sdk-php/src/Amazon/InstantAccess/Serialization/Enums/RevokePurchaseResponseValue.php',
            'library/composer/vendor/amazon/instantaccess-sdk-php/src/Amazon/InstantAccess/Serialization/Enums/GetUserIdResponseValue.php',
            'library/composer/vendor/amazon/instantaccess-sdk-php/src/Amazon/InstantAccess/Serialization/Enums/FulfillPurchaseReasonValue.php',
            'library/composer/vendor/amazon/instantaccess-sdk-php/src/Amazon/InstantAccess/Serialization/Enums/SubscriptionDeactivatePeriodValue.php',
            'library/composer/vendor/amazon/instantaccess-sdk-php/src/Amazon/InstantAccess/Serialization/Enums/FulfillPurchaseResponseValue.php',
            'library/composer/vendor/amazon/instantaccess-sdk-php/src/Amazon/InstantAccess/Serialization/Enums/SubscriptionDeactivateReasonValue.php',
            'library/composer/vendor/amazon/instantaccess-sdk-php/src/Amazon/InstantAccess/Serialization/Enums/SubscriptionDeactivateResponseValue.php',
            'library/composer/vendor/amazon/instantaccess-sdk-php/src/Amazon/InstantAccess/Serialization/FulfillPurchaseRequest.php',
            'library/composer/vendor/amazon/instantaccess-sdk-php/tools/RequestBuilder.php',
            'library/composer/vendor/infusionsoft/php-sdk/composer.json',
            'library/composer/vendor/infusionsoft/php-sdk/LICENSE',
            'library/composer/vendor/infusionsoft/php-sdk/composer.lock',
            'library/composer/vendor/infusionsoft/php-sdk/src/cacert.pem',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/Infusionsoft.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/TokenExpiredException.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/FrameworkSupport/Lumen/InfusionsoftServiceProvider.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/FrameworkSupport/Laravel/InfusionsoftFacade.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/FrameworkSupport/Laravel/InfusionsoftServiceProvider.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/FrameworkSupport/Laravel/config/config.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/InfusionsoftException.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/Api/FileService.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/Api/DiscountService.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/Api/AbstractApi.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/Api/ShippingService.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/Api/WebFormService.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/Api/ProductService.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/Api/Rest/FileService.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/Api/Rest/ProductService.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/Api/Rest/TransactionService.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/Api/Rest/ResthookService.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/Api/Rest/CampaignService.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/Api/Rest/CustomFieldService.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/Api/Rest/OrderService.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/Api/Rest/AppointmentService.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/Api/Rest/TaskService.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/Api/Rest/ContactService.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/Api/Rest/RestModel.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/Api/Rest/RestApi.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/Api/Rest/Traits/CannotCreate.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/Api/Rest/Traits/CannotSync.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/Api/Rest/Traits/CannotWhere.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/Api/Rest/Traits/CannotSave.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/Api/Rest/Traits/CannotFind.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/Api/Rest/Traits/CannotDelete.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/Api/Rest/TagService.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/Api/WebTrackingService.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/Api/SearchService.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/Api/AffiliateProgramService.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/Api/AffiliateService.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/Api/OrderService.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/Api/ContactService.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/Api/FunnelService.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/Api/InvoiceService.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/Api/CreditCardSubmissionService.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/Api/DataService.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/Api/APIEmailService.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/Token.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/InfusionsoftCollection.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/Http/SerializerInterface.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/Http/InfusionsoftSerializer.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/Http/HttpException.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/Http/ClientInterface.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/Http/ArrayLogger.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/Http/CurlClient.php',
            'library/composer/vendor/infusionsoft/php-sdk/src/Infusionsoft/Http/GuzzleHttpClient.php',
            'library/composer/vendor/facebook/php-sdk-v4/composer.json',
            'library/composer/vendor/facebook/php-sdk-v4/LICENSE',
            'library/composer/vendor/facebook/php-sdk-v4/src/Facebook/FacebookAuthorizationException.php',
            'library/composer/vendor/facebook/php-sdk-v4/src/Facebook/FacebookResponse.php',
            'library/composer/vendor/facebook/php-sdk-v4/src/Facebook/GraphSessionInfo.php',
            'library/composer/vendor/facebook/php-sdk-v4/src/Facebook/HttpClients/FacebookHttpable.php',
            'library/composer/vendor/facebook/php-sdk-v4/src/Facebook/HttpClients/FacebookStream.php',
            'library/composer/vendor/facebook/php-sdk-v4/src/Facebook/HttpClients/FacebookGuzzleHttpClient.php',
            'library/composer/vendor/facebook/php-sdk-v4/src/Facebook/HttpClients/FacebookCurlHttpClient.php',
            'library/composer/vendor/facebook/php-sdk-v4/src/Facebook/HttpClients/certs/DigiCertHighAssuranceEVRootCA.pem',
            'library/composer/vendor/facebook/php-sdk-v4/src/Facebook/HttpClients/FacebookStreamHttpClient.php',
            'library/composer/vendor/facebook/php-sdk-v4/src/Facebook/HttpClients/FacebookCurl.php',
            'library/composer/vendor/facebook/php-sdk-v4/src/Facebook/FacebookJavaScriptLoginHelper.php',
            'library/composer/vendor/facebook/php-sdk-v4/src/Facebook/GraphAlbum.php',
            'library/composer/vendor/facebook/php-sdk-v4/src/Facebook/FacebookOtherException.php',
            'library/composer/vendor/facebook/php-sdk-v4/src/Facebook/FacebookRequest.php',
            'library/composer/vendor/facebook/php-sdk-v4/src/Facebook/FacebookRequestException.php',
            'library/composer/vendor/facebook/php-sdk-v4/src/Facebook/FacebookClientException.php',
            'library/composer/vendor/facebook/php-sdk-v4/src/Facebook/FacebookSDKException.php',
            'library/composer/vendor/facebook/php-sdk-v4/src/Facebook/FacebookPermissionException.php',
            'library/composer/vendor/facebook/php-sdk-v4/src/Facebook/FacebookThrottleException.php',
            'library/composer/vendor/facebook/php-sdk-v4/src/Facebook/GraphLocation.php',
            'library/composer/vendor/facebook/php-sdk-v4/src/Facebook/Entities/AccessToken.php',
            'library/composer/vendor/facebook/php-sdk-v4/src/Facebook/Entities/SignedRequest.php',
            'library/composer/vendor/facebook/php-sdk-v4/src/Facebook/FacebookServerException.php',
            'library/composer/vendor/facebook/php-sdk-v4/src/Facebook/FacebookSession.php',
            'library/composer/vendor/facebook/php-sdk-v4/src/Facebook/FacebookPermissions.php',
            'library/composer/vendor/facebook/php-sdk-v4/src/Facebook/FacebookPageTabHelper.php',
            'library/composer/vendor/facebook/php-sdk-v4/src/Facebook/GraphUser.php',
            'library/composer/vendor/facebook/php-sdk-v4/src/Facebook/FacebookRedirectLoginHelper.php',
            'library/composer/vendor/facebook/php-sdk-v4/src/Facebook/FacebookCanvasLoginHelper.php',
            'library/composer/vendor/facebook/php-sdk-v4/src/Facebook/FacebookSignedRequestFromInputHelper.php',
            'library/composer/vendor/facebook/php-sdk-v4/src/Facebook/GraphUserPage.php',
            'library/composer/vendor/facebook/php-sdk-v4/src/Facebook/GraphPage.php',
            'library/composer/vendor/facebook/php-sdk-v4/src/Facebook/GraphObject.php',
            'library/composer/vendor/facebook/php-sdk-v4/autoload.php',
            'library/composer/vendor/nikic/fast-route/composer.json',
            'library/composer/vendor/nikic/fast-route/LICENSE',
            'library/composer/vendor/nikic/fast-route/.hhconfig',
            'library/composer/vendor/nikic/fast-route/psalm.xml',
            'library/composer/vendor/nikic/fast-route/FastRoute.hhi',
            'library/composer/vendor/nikic/fast-route/src/bootstrap.php',
            'library/composer/vendor/nikic/fast-route/src/RouteParser/Std.php',
            'library/composer/vendor/nikic/fast-route/src/Route.php',
            'library/composer/vendor/nikic/fast-route/src/Dispatcher/CharCountBased.php',
            'library/composer/vendor/nikic/fast-route/src/Dispatcher/GroupCountBased.php',
            'library/composer/vendor/nikic/fast-route/src/Dispatcher/RegexBasedAbstract.php',
            'library/composer/vendor/nikic/fast-route/src/Dispatcher/MarkBased.php',
            'library/composer/vendor/nikic/fast-route/src/Dispatcher/GroupPosBased.php',
            'library/composer/vendor/nikic/fast-route/src/BadRouteException.php',
            'library/composer/vendor/nikic/fast-route/src/DataGenerator/CharCountBased.php',
            'library/composer/vendor/nikic/fast-route/src/DataGenerator/GroupCountBased.php',
            'library/composer/vendor/nikic/fast-route/src/DataGenerator/RegexBasedAbstract.php',
            'library/composer/vendor/nikic/fast-route/src/DataGenerator/MarkBased.php',
            'library/composer/vendor/nikic/fast-route/src/DataGenerator/GroupPosBased.php',
            'library/composer/vendor/nikic/fast-route/src/Dispatcher.php',
            'library/composer/vendor/nikic/fast-route/src/RouteParser.php',
            'library/composer/vendor/nikic/fast-route/src/DataGenerator.php',
            'library/composer/vendor/nikic/fast-route/src/RouteCollector.php',
            'library/composer/vendor/nikic/fast-route/src/functions.php',
            'library/composer/vendor/white/white/composer.json',
            'library/composer/vendor/white/white/LICENSE',
            'library/composer/vendor/white/white/composer.lock',
            'library/composer/vendor/white/white/src/White.php',
            'library/composer/vendor/white/white/src/data/ca-certificates.crt',
            'library/composer/vendor/white/white/src/White/Customer.php',
            'library/composer/vendor/white/white/src/White/Charge.php',
            'library/composer/vendor/white/white/src/White/Error/Processing.php',
            'library/composer/vendor/white/white/src/White/Error/Banking.php',
            'library/composer/vendor/white/white/src/White/Error/Authentication.php',
            'library/composer/vendor/white/white/src/White/Error/Request.php',
            'library/composer/vendor/white/white/src/White/Error.php',
            'library/composer/vendor/white/white/White.php',
            'library/composer/vendor/lstrojny/fxmlrpc/.editorconfig',
            'library/composer/vendor/lstrojny/fxmlrpc/composer.json',
            'library/composer/vendor/lstrojny/fxmlrpc/build.xml',
            'library/composer/vendor/lstrojny/fxmlrpc/package.json',
            'library/composer/vendor/lstrojny/fxmlrpc/src/fXmlRpc/Exception/FaultException.php',
            'library/composer/vendor/lstrojny/fxmlrpc/src/fXmlRpc/Exception/RuntimeException.php',
            'library/composer/vendor/lstrojny/fxmlrpc/src/fXmlRpc/Exception/InvalidArgumentException.php',
            'library/composer/vendor/lstrojny/fxmlrpc/src/fXmlRpc/Exception/ParserException.php',
            'library/composer/vendor/lstrojny/fxmlrpc/src/fXmlRpc/Exception/HttpException.php',
            'library/composer/vendor/lstrojny/fxmlrpc/src/fXmlRpc/Exception/AbstractTransportException.php',
            'library/composer/vendor/lstrojny/fxmlrpc/src/fXmlRpc/Exception/SerializationException.php',
            'library/composer/vendor/lstrojny/fxmlrpc/src/fXmlRpc/Exception/TransportException.php',
            'library/composer/vendor/lstrojny/fxmlrpc/src/fXmlRpc/Exception/ExceptionInterface.php',
            'library/composer/vendor/lstrojny/fxmlrpc/src/fXmlRpc/Exception/MissingExtensionException.php',
            'library/composer/vendor/lstrojny/fxmlrpc/src/fXmlRpc/MulticallBuilderInterface.php',
            'library/composer/vendor/lstrojny/fxmlrpc/src/fXmlRpc/CallClientInterface.php',
            'library/composer/vendor/lstrojny/fxmlrpc/src/fXmlRpc/Client.php',
            'library/composer/vendor/lstrojny/fxmlrpc/src/fXmlRpc/MulticallBuilder.php',
            'library/composer/vendor/lstrojny/fxmlrpc/src/fXmlRpc/Transport/TransportInterface.php',
            'library/composer/vendor/lstrojny/fxmlrpc/src/fXmlRpc/Transport/Recorder.php',
            'library/composer/vendor/lstrojny/fxmlrpc/src/fXmlRpc/Transport/HttpAdapterTransport.php',
            'library/composer/vendor/lstrojny/fxmlrpc/src/fXmlRpc/Parser/NativeParser.php',
            'library/composer/vendor/lstrojny/fxmlrpc/src/fXmlRpc/Parser/ParserInterface.php',
            'library/composer/vendor/lstrojny/fxmlrpc/src/fXmlRpc/Parser/XmlChecker.php',
            'library/composer/vendor/lstrojny/fxmlrpc/src/fXmlRpc/Parser/XmlReaderParser.php',
            'library/composer/vendor/lstrojny/fxmlrpc/src/fXmlRpc/Value/Base64Interface.php',
            'library/composer/vendor/lstrojny/fxmlrpc/src/fXmlRpc/Value/Base64.php',
            'library/composer/vendor/lstrojny/fxmlrpc/src/fXmlRpc/AbstractDecorator.php',
            'library/composer/vendor/lstrojny/fxmlrpc/src/fXmlRpc/Proxy.php',
            'library/composer/vendor/lstrojny/fxmlrpc/src/fXmlRpc/Serializer/SerializerInterface.php',
            'library/composer/vendor/lstrojny/fxmlrpc/src/fXmlRpc/Serializer/NativeSerializer.php',
            'library/composer/vendor/lstrojny/fxmlrpc/src/fXmlRpc/Serializer/XmlWriterSerializer.php',
            'library/composer/vendor/lstrojny/fxmlrpc/src/fXmlRpc/ClientInterface.php',
            'library/composer/vendor/lstrojny/fxmlrpc/src/fXmlRpc/Timing/TimerInterface.php',
            'library/composer/vendor/lstrojny/fxmlrpc/src/fXmlRpc/Timing/Psr3TimerBridge.php',
            'library/composer/vendor/lstrojny/fxmlrpc/src/fXmlRpc/Timing/MonologTimerBridge.php',
            'library/composer/vendor/lstrojny/fxmlrpc/src/fXmlRpc/Timing/AbstractTimerBridge.php',
            'library/composer/vendor/lstrojny/fxmlrpc/src/fXmlRpc/Timing/TimingDecorator.php',
            'library/composer/vendor/lstrojny/fxmlrpc/src/fXmlRpc/Timing/ZendFrameworkOneTimerBridge.php',
            'library/composer/vendor/lstrojny/fxmlrpc/src/fXmlRpc/Timing/ZendFrameworkTwoTimerBridge.php',
            'library/composer/vendor/lstrojny/fxmlrpc/src/fXmlRpc/CodeGenerator/XmlReaderParserBitmaskGenerator.php',
            'library/composer/vendor/lstrojny/fxmlrpc/src/fXmlRpc/MulticallClientInterface.php',
            'library/composer/vendor/lstrojny/fxmlrpc/src/fXmlRpc/ExtensionSupportInterface.php',
            'library/composer/vendor/psr/http-server-handler/composer.json',
            'library/composer/vendor/psr/http-server-handler/LICENSE',
            'library/composer/vendor/psr/http-server-handler/src/RequestHandlerInterface.php',
            'library/composer/vendor/psr/container/composer.json',
            'library/composer/vendor/psr/container/LICENSE',
            'library/composer/vendor/psr/container/src/ContainerExceptionInterface.php',
            'library/composer/vendor/psr/container/src/ContainerInterface.php',
            'library/composer/vendor/psr/container/src/NotFoundExceptionInterface.php',
            'library/composer/vendor/psr/http-server-middleware/composer.json',
            'library/composer/vendor/psr/http-server-middleware/LICENSE',
            'library/composer/vendor/psr/http-server-middleware/src/MiddlewareInterface.php',
            'library/composer/vendor/psr/http-message/composer.json',
            'library/composer/vendor/psr/http-message/LICENSE',
            'library/composer/vendor/psr/http-message/src/StreamInterface.php',
            'library/composer/vendor/psr/http-message/src/RequestInterface.php',
            'library/composer/vendor/psr/http-message/src/UploadedFileInterface.php',
            'library/composer/vendor/psr/http-message/src/ResponseInterface.php',
            'library/composer/vendor/psr/http-message/src/UriInterface.php',
            'library/composer/vendor/psr/http-message/src/ServerRequestInterface.php',
            'library/composer/vendor/psr/http-message/src/MessageInterface.php',
            'library/composer/vendor/psr/log/composer.json',
            'library/composer/vendor/psr/log/LICENSE',
            'library/composer/vendor/psr/log/Psr/Log/AbstractLogger.php',
            'library/composer/vendor/psr/log/Psr/Log/NullLogger.php',
            'library/composer/vendor/psr/log/Psr/Log/LoggerAwareInterface.php',
            'library/composer/vendor/psr/log/Psr/Log/InvalidArgumentException.php',
            'library/composer/vendor/psr/log/Psr/Log/LoggerAwareTrait.php',
            'library/composer/vendor/psr/log/Psr/Log/LoggerTrait.php',
            'library/composer/vendor/psr/log/Psr/Log/LogLevel.php',
            'library/composer/vendor/psr/log/Psr/Log/Test/LoggerInterfaceTest.php',
            'library/composer/vendor/psr/log/Psr/Log/LoggerInterface.php',
            'library/composer/vendor/guzzlehttp/psr7/composer.json',
            'library/composer/vendor/guzzlehttp/psr7/LICENSE',
            'library/composer/vendor/guzzlehttp/psr7/src/AppendStream.php',
            'library/composer/vendor/guzzlehttp/psr7/src/CachingStream.php',
            'library/composer/vendor/guzzlehttp/psr7/src/functions_include.php',
            'library/composer/vendor/guzzlehttp/psr7/src/NoSeekStream.php',
            'library/composer/vendor/guzzlehttp/psr7/src/StreamDecoratorTrait.php',
            'library/composer/vendor/guzzlehttp/psr7/src/UploadedFile.php',
            'library/composer/vendor/guzzlehttp/psr7/src/FnStream.php',
            'library/composer/vendor/guzzlehttp/psr7/src/StreamWrapper.php',
            'library/composer/vendor/guzzlehttp/psr7/src/UriNormalizer.php',
            'library/composer/vendor/guzzlehttp/psr7/src/ServerRequest.php',
            'library/composer/vendor/guzzlehttp/psr7/src/PumpStream.php',
            'library/composer/vendor/guzzlehttp/psr7/src/InflateStream.php',
            'library/composer/vendor/guzzlehttp/psr7/src/Response.php',
            'library/composer/vendor/guzzlehttp/psr7/src/UriResolver.php',
            'library/composer/vendor/guzzlehttp/psr7/src/MultipartStream.php',
            'library/composer/vendor/guzzlehttp/psr7/src/Uri.php',
            'library/composer/vendor/guzzlehttp/psr7/src/LimitStream.php',
            'library/composer/vendor/guzzlehttp/psr7/src/LazyOpenStream.php',
            'library/composer/vendor/guzzlehttp/psr7/src/BufferStream.php',
            'library/composer/vendor/guzzlehttp/psr7/src/Stream.php',
            'library/composer/vendor/guzzlehttp/psr7/src/DroppingStream.php',
            'library/composer/vendor/guzzlehttp/psr7/src/MessageTrait.php',
            'library/composer/vendor/guzzlehttp/psr7/src/functions.php',
            'library/composer/vendor/guzzlehttp/psr7/src/Request.php',
            'library/composer/vendor/guzzlehttp/promises/Makefile',
            'library/composer/vendor/guzzlehttp/promises/composer.json',
            'library/composer/vendor/guzzlehttp/promises/LICENSE',
            'library/composer/vendor/guzzlehttp/promises/src/PromiseInterface.php',
            'library/composer/vendor/guzzlehttp/promises/src/functions_include.php',
            'library/composer/vendor/guzzlehttp/promises/src/TaskQueue.php',
            'library/composer/vendor/guzzlehttp/promises/src/Coroutine.php',
            'library/composer/vendor/guzzlehttp/promises/src/RejectionException.php',
            'library/composer/vendor/guzzlehttp/promises/src/EachPromise.php',
            'library/composer/vendor/guzzlehttp/promises/src/RejectedPromise.php',
            'library/composer/vendor/guzzlehttp/promises/src/PromisorInterface.php',
            'library/composer/vendor/guzzlehttp/promises/src/TaskQueueInterface.php',
            'library/composer/vendor/guzzlehttp/promises/src/AggregateException.php',
            'library/composer/vendor/guzzlehttp/promises/src/CancellationException.php',
            'library/composer/vendor/guzzlehttp/promises/src/Promise.php',
            'library/composer/vendor/guzzlehttp/promises/src/functions.php',
            'library/composer/vendor/guzzlehttp/promises/src/FulfilledPromise.php',
            'library/composer/vendor/guzzlehttp/guzzle/composer.json',
            'library/composer/vendor/guzzlehttp/guzzle/LICENSE',
            'library/composer/vendor/guzzlehttp/guzzle/src/Exception/GuzzleException.php',
            'library/composer/vendor/guzzlehttp/guzzle/src/Exception/ServerException.php',
            'library/composer/vendor/guzzlehttp/guzzle/src/Exception/ConnectException.php',
            'library/composer/vendor/guzzlehttp/guzzle/src/Exception/TooManyRedirectsException.php',
            'library/composer/vendor/guzzlehttp/guzzle/src/Exception/SeekException.php',
            'library/composer/vendor/guzzlehttp/guzzle/src/Exception/TransferException.php',
            'library/composer/vendor/guzzlehttp/guzzle/src/Exception/RequestException.php',
            'library/composer/vendor/guzzlehttp/guzzle/src/Exception/ClientException.php',
            'library/composer/vendor/guzzlehttp/guzzle/src/Exception/BadResponseException.php',
            'library/composer/vendor/guzzlehttp/guzzle/src/Handler/MockHandler.php',
            'library/composer/vendor/guzzlehttp/guzzle/src/Handler/CurlMultiHandler.php',
            'library/composer/vendor/guzzlehttp/guzzle/src/Handler/CurlHandler.php',
            'library/composer/vendor/guzzlehttp/guzzle/src/Handler/Proxy.php',
            'library/composer/vendor/guzzlehttp/guzzle/src/Handler/CurlFactory.php',
            'library/composer/vendor/guzzlehttp/guzzle/src/Handler/EasyHandle.php',
            'library/composer/vendor/guzzlehttp/guzzle/src/Handler/StreamHandler.php',
            'library/composer/vendor/guzzlehttp/guzzle/src/Handler/CurlFactoryInterface.php',
            'library/composer/vendor/guzzlehttp/guzzle/src/functions_include.php',
            'library/composer/vendor/guzzlehttp/guzzle/src/PrepareBodyMiddleware.php',
            'library/composer/vendor/guzzlehttp/guzzle/src/RedirectMiddleware.php',
            'library/composer/vendor/guzzlehttp/guzzle/src/Client.php',
            'library/composer/vendor/guzzlehttp/guzzle/src/RequestOptions.php',
            'library/composer/vendor/guzzlehttp/guzzle/src/MessageFormatter.php',
            'library/composer/vendor/guzzlehttp/guzzle/src/Cookie/CookieJar.php',
            'library/composer/vendor/guzzlehttp/guzzle/src/Cookie/SessionCookieJar.php',
            'library/composer/vendor/guzzlehttp/guzzle/src/Cookie/FileCookieJar.php',
            'library/composer/vendor/guzzlehttp/guzzle/src/Cookie/CookieJarInterface.php',
            'library/composer/vendor/guzzlehttp/guzzle/src/Cookie/SetCookie.php',
            'library/composer/vendor/guzzlehttp/guzzle/src/UriTemplate.php',
            'library/composer/vendor/guzzlehttp/guzzle/src/ClientInterface.php',
            'library/composer/vendor/guzzlehttp/guzzle/src/TransferStats.php',
            'library/composer/vendor/guzzlehttp/guzzle/src/HandlerStack.php',
            'library/composer/vendor/guzzlehttp/guzzle/src/RetryMiddleware.php',
            'library/composer/vendor/guzzlehttp/guzzle/src/Middleware.php',
            'library/composer/vendor/guzzlehttp/guzzle/src/functions.php',
            'library/composer/vendor/guzzlehttp/guzzle/src/Pool.php',
            'library/composer/vendor/zendframework/zend-diactoros/composer.json',
            'library/composer/vendor/zendframework/zend-diactoros/LICENSE.md',
            'library/composer/vendor/zendframework/zend-diactoros/src/Exception/DeprecatedMethodException.php',
            'library/composer/vendor/zendframework/zend-diactoros/src/Exception/ExceptionInterface.php',
            'library/composer/vendor/zendframework/zend-diactoros/src/UploadedFile.php',
            'library/composer/vendor/zendframework/zend-diactoros/src/RelativeStream.php',
            'library/composer/vendor/zendframework/zend-diactoros/src/HeaderSecurity.php',
            'library/composer/vendor/zendframework/zend-diactoros/src/Response/InjectContentTypeTrait.php',
            'library/composer/vendor/zendframework/zend-diactoros/src/Response/HtmlResponse.php',
            'library/composer/vendor/zendframework/zend-diactoros/src/Response/EmitterInterface.php',
            'library/composer/vendor/zendframework/zend-diactoros/src/Response/SapiEmitterTrait.php',
            'library/composer/vendor/zendframework/zend-diactoros/src/Response/RedirectResponse.php',
            'library/composer/vendor/zendframework/zend-diactoros/src/Response/Serializer.php',
            'library/composer/vendor/zendframework/zend-diactoros/src/Response/SapiEmitter.php',
            'library/composer/vendor/zendframework/zend-diactoros/src/Response/JsonResponse.php',
            'library/composer/vendor/zendframework/zend-diactoros/src/Response/SapiStreamEmitter.php',
            'library/composer/vendor/zendframework/zend-diactoros/src/Response/EmptyResponse.php',
            'library/composer/vendor/zendframework/zend-diactoros/src/Response/TextResponse.php',
            'library/composer/vendor/zendframework/zend-diactoros/src/ServerRequest.php',
            'library/composer/vendor/zendframework/zend-diactoros/src/Response.php',
            'library/composer/vendor/zendframework/zend-diactoros/src/AbstractSerializer.php',
            'library/composer/vendor/zendframework/zend-diactoros/src/ServerRequestFactory.php',
            'library/composer/vendor/zendframework/zend-diactoros/src/PhpInputStream.php',
            'library/composer/vendor/zendframework/zend-diactoros/src/Request/Serializer.php',
            'library/composer/vendor/zendframework/zend-diactoros/src/Uri.php',
            'library/composer/vendor/zendframework/zend-diactoros/src/RequestTrait.php',
            'library/composer/vendor/zendframework/zend-diactoros/src/CallbackStream.php',
            'library/composer/vendor/zendframework/zend-diactoros/src/Server.php',
            'library/composer/vendor/zendframework/zend-diactoros/src/Stream.php',
            'library/composer/vendor/zendframework/zend-diactoros/src/MessageTrait.php',
            'library/composer/vendor/zendframework/zend-diactoros/src/Request.php',
            'library/composer/vendor/autoload.php',
            'library/composer/vendor/amzn/amazon-pay-sdk-php/composer.json',
            'library/composer/vendor/amzn/amazon-pay-sdk-php/AmazonPay/HttpCurl.php',
            'library/composer/vendor/amzn/amazon-pay-sdk-php/AmazonPay/Regions.php',
            'library/composer/vendor/amzn/amazon-pay-sdk-php/AmazonPay/Client.php',
            'library/composer/vendor/amzn/amazon-pay-sdk-php/AmazonPay/IpnHandlerInterface.php',
            'library/composer/vendor/amzn/amazon-pay-sdk-php/AmazonPay/IpnHandler.php',
            'library/composer/vendor/amzn/amazon-pay-sdk-php/AmazonPay/ResponseInterface.php',
            'library/composer/vendor/amzn/amazon-pay-sdk-php/AmazonPay/ResponseParser.php',
            'library/composer/vendor/amzn/amazon-pay-sdk-php/AmazonPay/ClientInterface.php',
            'library/composer/vendor/amzn/amazon-pay-sdk-php/AmazonPay/HttpCurlInterface.php',
            'library/composer/vendor/amzn/amazon-pay-sdk-php/dist/amazon-pay.phar',
            'library/composer/vendor/amzn/amazon-pay-sdk-php/LICENSE.txt',
            'library/composer/vendor/amzn/amazon-pay-sdk-php/NOTICE.txt',
            'library/composer/vendor/amzn/amazon-pay-sdk-php/CHANGES.txt',
            'library/composer/vendor/amzn/amazon-pay-sdk-php/Psr/Log/AbstractLogger.php',
            'library/composer/vendor/amzn/amazon-pay-sdk-php/Psr/Log/NullLogger.php',
            'library/composer/vendor/amzn/amazon-pay-sdk-php/Psr/Log/LoggerAwareInterface.php',
            'library/composer/vendor/amzn/amazon-pay-sdk-php/Psr/Log/InvalidArgumentException.php',
            'library/composer/vendor/amzn/amazon-pay-sdk-php/Psr/Log/LoggerAwareTrait.php',
            'library/composer/vendor/amzn/amazon-pay-sdk-php/Psr/Log/LoggerTrait.php',
            'library/composer/vendor/amzn/amazon-pay-sdk-php/Psr/Log/LogLevel.php',
            'library/composer/vendor/amzn/amazon-pay-sdk-php/Psr/Log/Test/LoggerInterfaceTest.php',
            'library/composer/vendor/amzn/amazon-pay-sdk-php/Psr/Log/LoggerInterface.php',
            'library/composer/vendor/amzn/amazon-pay-sdk-php/create-amazon-pay-phar.php',
            'library/composer/vendor/lcobucci/jwt/composer.json',
            'library/composer/vendor/lcobucci/jwt/LICENSE',
            'library/composer/vendor/lcobucci/jwt/composer.lock',
            'library/composer/vendor/lcobucci/jwt/src/Claim/GreaterOrEqualsTo.php',
            'library/composer/vendor/lcobucci/jwt/src/Claim/Factory.php',
            'library/composer/vendor/lcobucci/jwt/src/Claim/EqualsTo.php',
            'library/composer/vendor/lcobucci/jwt/src/Claim/Validatable.php',
            'library/composer/vendor/lcobucci/jwt/src/Claim/Basic.php',
            'library/composer/vendor/lcobucci/jwt/src/Claim/LesserOrEqualsTo.php',
            'library/composer/vendor/lcobucci/jwt/src/Signer/Rsa/Sha512.php',
            'library/composer/vendor/lcobucci/jwt/src/Signer/Rsa/Sha384.php',
            'library/composer/vendor/lcobucci/jwt/src/Signer/Rsa/Sha256.php',
            'library/composer/vendor/lcobucci/jwt/src/Signer/Keychain.php',
            'library/composer/vendor/lcobucci/jwt/src/Signer/Hmac/Sha512.php',
            'library/composer/vendor/lcobucci/jwt/src/Signer/Hmac/Sha384.php',
            'library/composer/vendor/lcobucci/jwt/src/Signer/Hmac/Sha256.php',
            'library/composer/vendor/lcobucci/jwt/src/Signer/Key.php',
            'library/composer/vendor/lcobucci/jwt/src/Signer/BaseSigner.php',
            'library/composer/vendor/lcobucci/jwt/src/Signer/Ecdsa.php',
            'library/composer/vendor/lcobucci/jwt/src/Signer/Rsa.php',
            'library/composer/vendor/lcobucci/jwt/src/Signer/Hmac.php',
            'library/composer/vendor/lcobucci/jwt/src/Signer/Ecdsa/Sha512.php',
            'library/composer/vendor/lcobucci/jwt/src/Signer/Ecdsa/Sha384.php',
            'library/composer/vendor/lcobucci/jwt/src/Signer/Ecdsa/Sha256.php',
            'library/composer/vendor/lcobucci/jwt/src/Signer/Ecdsa/KeyParser.php',
            'library/composer/vendor/lcobucci/jwt/src/Signer.php',
            'library/composer/vendor/lcobucci/jwt/src/Parsing/Decoder.php',
            'library/composer/vendor/lcobucci/jwt/src/Parsing/Encoder.php',
            'library/composer/vendor/lcobucci/jwt/src/Builder.php',
            'library/composer/vendor/lcobucci/jwt/src/Parser.php',
            'library/composer/vendor/lcobucci/jwt/src/ValidationData.php',
            'library/composer/vendor/lcobucci/jwt/src/Token.php',
            'library/composer/vendor/lcobucci/jwt/src/Signature.php',
            'library/composer/vendor/lcobucci/jwt/src/Claim.php',
            'library/composer/vendor/container-interop/container-interop/composer.json',
            'library/composer/vendor/container-interop/container-interop/LICENSE',
            'library/composer/vendor/container-interop/container-interop/src/Interop/Container/Exception/ContainerException.php',
            'library/composer/vendor/container-interop/container-interop/src/Interop/Container/Exception/NotFoundException.php',
            'library/composer/vendor/container-interop/container-interop/src/Interop/Container/ContainerInterface.php',
            'library/composer/vendor/slim/slim/Slim/Exception/SlimException.php',
            'library/composer/vendor/slim/slim/Slim/Exception/ContainerValueNotFoundException.php',
            'library/composer/vendor/slim/slim/Slim/Exception/MethodNotAllowedException.php',
            'library/composer/vendor/slim/slim/Slim/Exception/InvalidMethodException.php',
            'library/composer/vendor/slim/slim/Slim/Exception/ContainerException.php',
            'library/composer/vendor/slim/slim/Slim/Exception/NotFoundException.php',
            'library/composer/vendor/slim/slim/Slim/DeferredCallable.php',
            'library/composer/vendor/slim/slim/Slim/App.php',
            'library/composer/vendor/slim/slim/Slim/Handlers/NotAllowed.php',
            'library/composer/vendor/slim/slim/Slim/Handlers/PhpError.php',
            'library/composer/vendor/slim/slim/Slim/Handlers/Strategies/RequestResponse.php',
            'library/composer/vendor/slim/slim/Slim/Handlers/Strategies/RequestResponseArgs.php',
            'library/composer/vendor/slim/slim/Slim/Handlers/AbstractHandler.php',
            'library/composer/vendor/slim/slim/Slim/Handlers/AbstractError.php',
            'library/composer/vendor/slim/slim/Slim/Handlers/NotFound.php',
            'library/composer/vendor/slim/slim/Slim/Handlers/Error.php',
            'library/composer/vendor/slim/slim/Slim/Container.php',
            'library/composer/vendor/slim/slim/Slim/Route.php',
            'library/composer/vendor/slim/slim/Slim/Router.php',
            'library/composer/vendor/slim/slim/Slim/CallableResolver.php',
            'library/composer/vendor/slim/slim/Slim/Interfaces/RouterInterface.php',
            'library/composer/vendor/slim/slim/Slim/Interfaces/RouteGroupInterface.php',
            'library/composer/vendor/slim/slim/Slim/Interfaces/RouteInterface.php',
            'library/composer/vendor/slim/slim/Slim/Interfaces/CallableResolverInterface.php',
            'library/composer/vendor/slim/slim/Slim/Interfaces/InvocationStrategyInterface.php',
            'library/composer/vendor/slim/slim/Slim/Interfaces/Http/CookiesInterface.php',
            'library/composer/vendor/slim/slim/Slim/Interfaces/Http/HeadersInterface.php',
            'library/composer/vendor/slim/slim/Slim/Interfaces/Http/EnvironmentInterface.php',
            'library/composer/vendor/slim/slim/Slim/Interfaces/CollectionInterface.php',
            'library/composer/vendor/slim/slim/Slim/CallableResolverAwareTrait.php',
            'library/composer/vendor/slim/slim/Slim/Routable.php',
            'library/composer/vendor/slim/slim/Slim/RouteGroup.php',
            'library/composer/vendor/slim/slim/Slim/Collection.php',
            'library/composer/vendor/slim/slim/Slim/Http/Headers.php',
            'library/composer/vendor/slim/slim/Slim/Http/UploadedFile.php',
            'library/composer/vendor/slim/slim/Slim/Http/Cookies.php',
            'library/composer/vendor/slim/slim/Slim/Http/Body.php',
            'library/composer/vendor/slim/slim/Slim/Http/Environment.php',
            'library/composer/vendor/slim/slim/Slim/Http/RequestBody.php',
            'library/composer/vendor/slim/slim/Slim/Http/StatusCode.php',
            'library/composer/vendor/slim/slim/Slim/Http/Response.php',
            'library/composer/vendor/slim/slim/Slim/Http/Message.php',
            'library/composer/vendor/slim/slim/Slim/Http/Uri.php',
            'library/composer/vendor/slim/slim/Slim/Http/Stream.php',
            'library/composer/vendor/slim/slim/Slim/Http/Request.php',
            'library/composer/vendor/slim/slim/Slim/MiddlewareAwareTrait.php',
            'library/composer/vendor/slim/slim/Slim/DefaultServicesProvider.php',
            'library/composer/vendor/slim/slim/composer.json',
            'library/composer/vendor/slim/slim/LICENSE.md',
            'library/composer/composer.lock',
            'library/class-ftp-pure.php',
            'library/ccvs.php',
            'library/class-ftp.php',
            'library/class-ftp-sockets.php',
            'library/pear/Crypt/DES.php',
            'library/pear/Crypt/AES.php',
            'library/pear/Crypt/RSA.php',
            'library/pear/Crypt/Base.php',
            'library/pear/Crypt/Random.php',
            'library/pear/Crypt/TripleDES.php',
            'library/pear/Crypt/Hash.php',
            'library/pear/Crypt/Blowfish.php',
            'library/pear/Crypt/RC4.php',
            'library/pear/Crypt/Blowfish/DefaultKey.php',
            'library/pear/Crypt/Rijndael.php',
            'library/pear/Net/SFTP.php',
            'library/pear/Net/SSH2.php',
            'library/pear/Archive/Tar.php',
            'library/pear/Math/BigInteger.php',
            'setup/sql-country.sql',
            'setup/sql-state.sql',

            'application/reward-points/module.xml',
            'application/cart/module.xml',
            'application/webhooks/module.xml',
            'application/subusers/module.xml',
            'application/subusers/views/public/img/icons/detach.png',
            'application/archive/module.xml',
            'application/newsletter/db.xml',
            'application/newsletter/module.xml',
            'application/newsletter/plugins/madmimi-full.php',
            'application/newsletter/library/Am/Newsletter/Plugin/Standard.php',
            'application/upsell/module.xml',
            'application/api/module.xml',

            'application/default/models/ErrorLog.php',
            'application/default/models/SavedReport.php',
            'application/default/models/UserDeleteRequest.php',
            'application/default/models/Video.php',
            'application/default/models/Button.php',
            'application/default/models/CurrencyExchange.php',
            'application/default/models/ProductProductCategory.php',
            'application/default/models/AccessLog.php',
            'application/default/models/Page.php',
            'application/default/models/MailQueue.php',
            'application/default/models/BillingPlan.php',
            'application/default/models/ResourceAbstractFile.php',
            'application/default/models/CouponBatch.php',
            'application/default/models/Admin.php',
            'application/default/models/FileDownload.php',
            'application/default/models/Access.php',
            'application/default/models/Integration.php',
            'application/default/models/Invoice.php',
            'application/default/models/CcRebill.php',
            'application/default/models/ResourceAccess.php',
            'application/default/models/AdminLog.php',
            'application/default/models/InvoiceRefund.php',
            'application/default/models/DebugLog.php',
            'application/default/models/UserConsent.php',
            'application/default/models/EmailTemplate.php',
            'application/default/models/UserNote.php',
            'application/default/models/IProduct.php',
            'application/default/models/EmailTemplateLayout.php',
            'application/default/models/ResourceAbstract.php',
            'application/default/models/EmailSent.php',
            'application/default/models/SavedPass.php',
            'application/default/models/Agreement.php',
            'application/default/models/Charge.php',
            'application/default/models/Folder.php',
            'application/default/models/ProductCategory.php',
            'application/default/models/Country.php',
            'application/default/models/File.php',
            'application/default/models/CcRecord.php',
            'application/default/models/InvoiceLog.php',
            'application/default/models/Upload.php',
            'application/default/models/User.php',
            'application/default/models/SavedForm.php',
            'application/default/models/Ban.php',
            'application/default/models/ProductUpgrade.php',
            'application/default/models/State.php',
            'application/default/models/UserStatus.php',
            'application/default/models/ProductOption.php',
            'application/default/models/Product.php',
            'application/default/models/Link.php',
            'application/default/models/InvoicePayment.php',
            'application/default/models/Coupon.php',
            'application/default/models/UserGroup.php',
            'application/default/models/Translation.php',
            'application/default/models/InvoiceItem.php',
            'application/default/models/EcheckRecord.php',
            'application/default/models/ResourceCategory.php',
            'application/default/controllers/AdminBackupController.php',
            'application/default/controllers/CancelController.php',
            'application/default/controllers/CustomFieldController.php',
            'application/default/controllers/AdminDirbrowserController.php',
            'application/default/controllers/AdminMenuController.php',
            'application/default/controllers/AdminFieldsController.php',
            'application/default/controllers/AdminImportWordpressMagicMembersController.php',
            'application/default/controllers/AdminBuyNowController.php',
            'application/default/controllers/AdminDeletePersonalDataController.php',
            'application/default/controllers/FileController.php',
            'application/default/controllers/AdminVatGroupController.php',
            'application/default/controllers/AdminLicenseController.php',
            'application/default/controllers/AdminAuthController.php',
            'application/default/controllers/LogAccessController.php',
            'application/default/controllers/AdminImport3Controller.php',
            'application/default/controllers/IndexController.php',
            'application/default/controllers/AdminUserPaymentsController.php',
            'application/default/controllers/AudioController.php',
            'application/default/controllers/AdminImportIpbNexusController.php',
            'application/default/controllers/AdminInfoController.php',
            'application/default/controllers/AdminBuildDemoController.php',
            'application/default/controllers/AdminImportDrupalMsController.php',
            'application/default/controllers/AdminReportsController.php',
            'application/default/controllers/AdminAgreementController.php',
            'application/default/controllers/AdminUserGroupsController.php',
            'application/default/controllers/AjaxController.php',
            'application/default/controllers/AdminEmailTemplatesController.php',
            'application/default/controllers/AdminClearController.php',
            'application/default/controllers/AdminImportWordpressMembershipController.php',
            'application/default/controllers/AdminAdminsController.php',
            'application/default/controllers/AdminLogsController.php',
            'application/default/controllers/AdminVatReportController.php',
            'application/default/controllers/PayController.php',
            'application/default/controllers/UnsubscribeController.php',
            'application/default/controllers/AdminPluginMakerController.php',
            'application/default/controllers/AdminEmailController.php',
            'application/default/controllers/AdminCountriesController.php',
            'application/default/controllers/AdminImportOss6Controller.php',
            'application/default/controllers/UploadController.php',
            'application/default/controllers/MemberController.php',
            'application/default/controllers/AdminEmailTemplateLayoutController.php',
            'application/default/controllers/BuyController.php',
            'application/default/controllers/AdminImportWordpressOptimizeMemberController.php',
            'application/default/controllers/TestController.php',
            'application/default/controllers/AdminUserConsentController.php',
            'application/default/controllers/PersonalDataController.php',
            'application/default/controllers/ContentController.php',
            'application/default/controllers/VideoController.php',
            'application/default/controllers/AdminStatesController.php',
            'application/default/controllers/AdminPaymentsController.php',
            'application/default/controllers/AdminSavedFormController.php',
            'application/default/controllers/AgreementController.php',
            'application/default/controllers/AdminCouponsController.php',
            'application/default/controllers/AdminPlayerConfigController.php',
            'application/default/controllers/AdminProductsController.php',
            'application/default/controllers/DirectController.php',
            'application/default/controllers/AdminUserNoteController.php',
            'application/default/controllers/AdminRestoreController.php',
            'application/default/controllers/AdminBanController.php',
            'application/default/controllers/AdminFileDownloadController.php',
            'application/default/controllers/ErrorController.php',
            'application/default/controllers/AdminCurrencyExchangeController.php',
            'application/default/controllers/AdminUpgradeDbController.php',
            'application/default/controllers/AdminRepairTablesController.php',
            'application/default/controllers/AdminImportController.php',
            'application/default/controllers/AdminImportDapController.php',
            'application/default/controllers/BackupController.php',
            'application/default/controllers/SignupController.php',
            'application/default/controllers/ProfileController.php',
            'application/default/controllers/AdminImportYourMembersController.php',
            'application/default/controllers/AdminChangePassController.php',
            'application/default/controllers/AdminImportWordpressMemberMouseController.php',
            'application/default/controllers/AdminRebuildController.php',
            'application/default/controllers/NoAccessController.php',
            'application/default/controllers/AdminResourceCategoriesController.php',
            'application/default/controllers/MediaController.php',
            'application/default/controllers/AdminTransGlobalController.php',
            'application/default/controllers/AdminTransLocalController.php',
            'application/default/controllers/CronController.php',
            'application/default/controllers/AdminUploadController.php',
            'application/default/controllers/AdminProductCategoriesController.php',
            'application/default/plugins/protect/wordpress/Karma/layout.phtml',
            'application/default/plugins/protect/wordpress/Divi/layout.phtml',
            'application/default/plugins/protect/wordpress/tptheme/layout.phtml',
            'application/default/plugins/protect/wordpress/Nexus/layout.phtml',
            'application/default/plugins/protect/wordpress/twentyfourteen/layout.phtml',
            'application/default/plugins/protect/wordpress/upload_to_wordpress/wp-content/plugins/amember4/languages/amember4.pot',
            'application/default/plugins/protect/wordpress/upload_to_wordpress/wp-content/plugins/amember4/shortcode_select.php',
            'application/default/plugins/protect/wordpress/upload_to_wordpress/wp-content/plugins/amember4/shortcodes.php',
            'application/default/plugins/protect/wordpress/upload_to_wordpress/wp-content/plugins/amember4/menu.php',
            'application/default/plugins/protect/wordpress/upload_to_wordpress/wp-content/plugins/amember4/views/settings.phtml',
            'application/default/plugins/protect/wordpress/upload_to_wordpress/wp-content/plugins/amember4/views/admin_styles.css',
            'application/default/plugins/protect/wordpress/upload_to_wordpress/wp-content/plugins/amember4/views/shortcode.js',
            'application/default/plugins/protect/wordpress/upload_to_wordpress/wp-content/plugins/amember4/views/widget_protection.phtml',
            'application/default/plugins/protect/wordpress/upload_to_wordpress/wp-content/plugins/amember4/views/post_protection.phtml',
            'application/default/plugins/protect/wordpress/upload_to_wordpress/wp-content/plugins/amember4/views/errormessages.phtml',
            'application/default/plugins/protect/wordpress/upload_to_wordpress/wp-content/plugins/amember4/views/widget_login_form.phtml',
            'application/default/plugins/protect/wordpress/upload_to_wordpress/wp-content/plugins/amember4/views/shortcode_am4guest.phtml',
            'application/default/plugins/protect/wordpress/upload_to_wordpress/wp-content/plugins/amember4/views/styles.phtml',
            'application/default/plugins/protect/wordpress/upload_to_wordpress/wp-content/plugins/amember4/views/protection.phtml',
            'application/default/plugins/protect/wordpress/upload_to_wordpress/wp-content/plugins/amember4/views/bulk_action.js',
            'application/default/plugins/protect/wordpress/upload_to_wordpress/wp-content/plugins/amember4/views/shortcode_am4user.phtml',
            'application/default/plugins/protect/wordpress/upload_to_wordpress/wp-content/plugins/amember4/views/shortcode_am4afflink.phtml',
            'application/default/plugins/protect/wordpress/upload_to_wordpress/wp-content/plugins/amember4/views/widget_after_login.phtml',
            'application/default/plugins/protect/wordpress/upload_to_wordpress/wp-content/plugins/amember4/views/category.phtml',
            'application/default/plugins/protect/wordpress/upload_to_wordpress/wp-content/plugins/amember4/views/jquery.outerClick.js',
            'application/default/plugins/protect/wordpress/upload_to_wordpress/wp-content/plugins/amember4/views/bulk_protection.phtml',
            'application/default/plugins/protect/wordpress/upload_to_wordpress/wp-content/plugins/amember4/views/tag.phtml',
            'application/default/plugins/protect/wordpress/upload_to_wordpress/wp-content/plugins/amember4/views/shortcodes_help.phtml',
            'application/default/plugins/protect/wordpress/upload_to_wordpress/wp-content/plugins/amember4/views/page_protection.phtml',
            'application/default/plugins/protect/wordpress/upload_to_wordpress/wp-content/plugins/amember4/views/jquery.textarea.js',
            'application/default/plugins/protect/wordpress/upload_to_wordpress/wp-content/plugins/amember4/views/shortcode_am4info.phtml',
            'application/default/plugins/protect/wordpress/upload_to_wordpress/wp-content/plugins/amember4/views/shortcode_am4show.phtml',
            'application/default/plugins/protect/wordpress/upload_to_wordpress/wp-content/plugins/amember4/views/shortcode_am4aff.phtml',
            'application/default/plugins/protect/wordpress/upload_to_wordpress/wp-content/plugins/amember4/views/resourceaccess.js',
            'application/default/plugins/protect/wordpress/upload_to_wordpress/wp-content/plugins/amember4/img/ajax-loader.gif',
            'application/default/plugins/protect/wordpress/upload_to_wordpress/wp-content/plugins/amember4/img/lock.png',
            'application/default/plugins/protect/wordpress/upload_to_wordpress/wp-content/plugins/amember4/protection.php',
            'application/default/plugins/protect/wordpress/upload_to_wordpress/wp-content/plugins/amember4/widgets.php',
            'application/default/plugins/protect/wordpress/upload_to_wordpress/wp-content/plugins/amember4/notifications.php',
            'application/default/plugins/protect/wordpress/upload_to_wordpress/wp-content/plugins/amember4/js/jquery.ui.autocomplete.js',
            'application/default/plugins/protect/wordpress/upload_to_wordpress/wp-content/plugins/amember4/js/dirbrowser.js',
            'application/default/plugins/protect/wordpress/upload_to_wordpress/wp-content/plugins/amember4/js/tinymce.js',
            'application/default/plugins/protect/wordpress/upload_to_wordpress/wp-content/plugins/amember4/amember4.php',
            'application/default/plugins/protect/wordpress/upload_to_wordpress/wp-content/plugins/amember4/includes/utils.php',
            'application/default/plugins/protect/wordpress/upload_to_wordpress/wp-content/plugins/amember4/includes/plugin.php',
            'application/default/plugins/protect/wordpress/upload_to_wordpress/wp-content/plugins/amember4/includes/access.php',
            'application/default/plugins/protect/wordpress/upload_to_wordpress/wp-content/plugins/amember4/includes/view.php',
            'application/default/plugins/protect/wordpress/upload_to_wordpress/wp-content/plugins/amember4/includes/options.php',
            'application/default/plugins/protect/wordpress/upload_to_wordpress/wp-content/plugins/amember4/includes/controller.php',
            'application/default/plugins/protect/wordpress/upload_to_wordpress/wp-content/plugins/amember4/tinymce.php',
            'application/default/plugins/protect/wordpress/thesis/layout.phtml',
            'application/default/plugins/protect/wordpress/default/layout.phtml',
            'application/default/plugins/protect/wordpress/profitstheme/layout.phtml',
            'application/default/plugins/protect/wordpress/twentyseventeen/layout.phtml',
            'application/default/plugins/protect/wordpress/catalyst/layout.phtml',
            'application/default/plugins/protect/wordpress/orion/layout.phtml',
            'application/default/plugins/misc/sales-notification/views/public/js/notify.min.js',
            'application/default/plugins/misc/sales-notification/sales-notification.php',
            'application/downloads/module.xml',
            'application/network/module.xml',
            'application/self-service/module.xml',
            'application/schedule-emails/module.xml',
            'application/schedule-emails/views/public/img/icons/content-scheduleemails.png',
            'application/aff/module.xml',
            'application/aff/views/public/css/aff.css',
            'application/cc/module.xml',
            'application/softsale/module.xml',
            'application/directory/module.xml',
            'application/helpdesk/module.xml',
            'application/helpdesk/views/public/img/arrow.png',
            'application/helpdesk/views/public/css/helpdesk-admin.css',
            'application/helpdesk/views/public/css/helpdesk-user.css',
            'application/ab-signup/module.xml',
            'application/ab-signup/views/public/img/icons/ab-signup.png',
        ];
    }

    function getKnownPluginFileList()
    {
        return [
            'application/default/plugins/protect/drupal8.php',
            'application/default/plugins/protect/pap/pap-bricks.php',
            'application/default/plugins/protect/pap/pap.php',
            'application/default/plugins/protect/testing.php',
            'application/default/plugins/protect/xcart5.php',
            'application/default/plugins/protect/stockboxphoto.php',
            'application/default/plugins/protect/zencart.php',
            'application/default/plugins/protect/architect.php',
            'application/default/plugins/protect/silverstrype/silverstrype.php',
            'application/default/plugins/protect/silverstrype/ss_classes.php',
            'application/default/plugins/protect/phpprobid.php',
            'application/default/plugins/protect/efront/efront.php',
            'application/default/plugins/protect/trellis.php',
            'application/default/plugins/protect/htpasswd.php',
            'application/default/plugins/protect/dolphin.php',
            'application/default/plugins/protect/osticket.php',
            'application/default/plugins/protect/gallery2.php',
            'application/default/plugins/protect/dokeos.php',
            'application/default/plugins/protect/phpsound.php',
            'application/default/plugins/protect/mailwizz.php',
            'application/default/plugins/protect/projectbox.php',
            'application/default/plugins/protect/coaching-cloud.php',
            'application/default/plugins/protect/phplist.php',
            'application/default/plugins/protect/adultvideoscript.php',
            'application/default/plugins/protect/mediawiki.php',
            'application/default/plugins/protect/socialninja.php',
            'application/default/plugins/protect/phpmydirectory.php',
            'application/default/plugins/protect/phpsfp.php',
            'application/default/plugins/protect/ocportal.php',
            'application/default/plugins/protect/e107.php',
            'application/default/plugins/protect/invision4.php',
            'application/default/plugins/protect/joomla/amember-plugin15/amember.php',
            'application/default/plugins/protect/joomla/amember-plugin15/amember.xml',
            'application/default/plugins/protect/joomla/amember-plugin/amember.php',
            'application/default/plugins/protect/joomla/amember-plugin/index.html',
            'application/default/plugins/protect/joomla/amember-plugin/amember.xml',
            'application/default/plugins/protect/joomla/amember-plugin15.zip',
            'application/default/plugins/protect/joomla/amember-plugin.zip',
            'application/default/plugins/protect/joomla/joomla.php',
            'application/default/plugins/protect/joomla/joomla_cb/readme.txt',
            'application/default/plugins/protect/joomla/joomla_cb/plug_amemberconnector/amemberconnector.xml',
            'application/default/plugins/protect/joomla/joomla_cb/plug_amemberconnector/api.php',
            'application/default/plugins/protect/joomla/joomla_cb/plug_amemberconnector/index.html',
            'application/default/plugins/protect/joomla/joomla_cb/plug_amemberconnector/amemberconnector.php',
            'application/default/plugins/protect/joomla/joomla_cb/joomla_cb_amember.zip',
            'application/default/plugins/protect/coppermine.php',
            'application/default/plugins/protect/gototraining.php',
            'application/default/plugins/protect/onarcade.php',
            'application/default/plugins/protect/vbulletin/vbulletin.php',
            'application/default/plugins/protect/vbulletin/product-amember.xml',
            'application/default/plugins/protect/magento.php',
            'application/default/plugins/protect/ldap.php',
            'application/default/plugins/protect/typo3.php',
            'application/default/plugins/protect/skadate.php',
            'application/default/plugins/protect/owncloud/owncloud.php',
            'application/default/plugins/protect/socialengine.php',
            'application/default/plugins/protect/magoware.php',
            'application/default/plugins/protect/ladesk.php',
            'application/default/plugins/protect/tubescript.php',
            'application/default/plugins/protect/concrete.php',
            'application/default/plugins/protect/wordpress/network.php',
            'application/default/plugins/protect/wordpress/bricks.php',
            'application/default/plugins/protect/wordpress/amember.php',
            'application/default/plugins/protect/wordpress/api.php',
            'application/default/plugins/protect/wordpress/wordpress.php',
            'application/default/plugins/protect/new-rewrite.php',
            'application/default/plugins/protect/expressionengine.php',
            'application/default/plugins/protect/machform.php',
            'application/default/plugins/protect/oscommerce.php',
            'application/default/plugins/protect/vanilla.php',
            'application/default/plugins/protect/xcart.php',
            'application/default/plugins/protect/cmsbuilder.php',
            'application/default/plugins/protect/kayako/kayako.php',
            'application/default/plugins/protect/appointmind.php',
            'application/default/plugins/protect/smf.php',
            'application/default/plugins/protect/chamelion-social.php',
            'application/default/plugins/protect/mybb/mybb.php',
            'application/default/plugins/protect/xoops.php',
            'application/default/plugins/protect/filerun.php',
            'application/default/plugins/protect/drupal.php',
            'application/default/plugins/protect/jamroom.php',
            'application/default/plugins/protect/4images.php',
            'application/default/plugins/protect/xenforo/xenforo2_plugin/Amember-1.zip',
            'application/default/plugins/protect/xenforo/xenforo1_plugin/addon-Amember.xml',
            'application/default/plugins/protect/xenforo/xenforo1_plugin/Amember/Redirect.php',
            'application/default/plugins/protect/xenforo/xenforo.php',
            'application/default/plugins/protect/cerb5.php',
            'application/default/plugins/protect/imathas.php',
            'application/default/plugins/protect/modx2.php',
            'application/default/plugins/protect/chamilo.php',
            'application/default/plugins/protect/serendipity.php',
            'application/default/plugins/protect/userecho.php',
            'application/default/plugins/protect/quotemedia.php',
            'application/default/plugins/protect/prestashop.php',
            'application/default/plugins/protect/redmine.php',
            'application/default/plugins/protect/summercart.php',
            'application/default/plugins/protect/phpbb.php',
            'application/default/plugins/protect/atmail.php',
            'application/default/plugins/protect/minibb.php',
            'application/default/plugins/protect/oldmoodle/oldmoodle.php',
            'application/default/plugins/protect/oldmoodle/auth/amember/config.html',
            'application/default/plugins/protect/oldmoodle/auth/amember/auth.php',
            'application/default/plugins/protect/oldmoodle/auth/amember/lang/en_utf8/auth_amember.php',
            'application/default/plugins/protect/moodle/Am_Form_Protect_Moodle.php',
            'application/default/plugins/protect/moodle/moodle/blocks/amember_login/settings.php',
            'application/default/plugins/protect/moodle/moodle/blocks/amember_login/block_amember_login.php',
            'application/default/plugins/protect/moodle/moodle/blocks/amember_login/version.php',
            'application/default/plugins/protect/moodle/moodle/blocks/amember_login/lang/en/block_amember_login.php',
            'application/default/plugins/protect/moodle/moodle.php',
            'application/default/plugins/protect/free-radius.php',
            'application/default/plugins/protect/punbb.php',
            'application/default/plugins/protect/photopost.php',
            'application/default/plugins/protect/phpfox.php',
            'application/default/plugins/protect/youtubify.php',
            'application/default/plugins/protect/modx.php',
            'application/default/plugins/protect/invision.php',
            'application/default/plugins/protect/zendesk.php',
            'application/default/plugins/protect/fbinboxer.php',
            'application/default/plugins/protect/photoshow.php',
            'application/default/plugins/protect/activecollab.php',
            'application/default/plugins/protect/click-suit.php',
            'application/default/plugins/payment/ccavenue/ccavenue.php',
            'application/default/plugins/payment/ccavenue/ccavutil.jar',
            'application/default/plugins/payment/dragonpay.php',
            'application/default/plugins/payment/warrior-plus.php',
            'application/default/plugins/payment/verotel.php',
            'application/default/plugins/payment/moneris.php',
            'application/default/plugins/payment/dibs-payment-window.php',
            'application/default/plugins/payment/gate2shop.php',
            'application/default/plugins/payment/opennode.php',
            'application/default/plugins/payment/okpay.php',
            'application/default/plugins/payment/digital-goods-store.php',
            'application/default/plugins/payment/payza.php',
            'application/default/plugins/payment/xfers.php',
            'application/default/plugins/payment/amazon-instant-access/amazon-instant-access.php',
            'application/default/plugins/payment/amazon-instant-access/AmLogger.php',
            'application/default/plugins/payment/securetrading.php',
            'application/default/plugins/payment/paysafecard/scripts/payment-paysafecard-cancel.phtml',
            'application/default/plugins/payment/paysafecard/SOPGClassicMerchantClient.php',
            'application/default/plugins/payment/paysafecard/Validators.php',
            'application/default/plugins/payment/paysafecard/paysafecard.php',
            'application/default/plugins/payment/paygol.php',
            'application/default/plugins/payment/avangate.php',
            'application/default/plugins/payment/quaderno-checkout/scripts/quaderno.phtml',
            'application/default/plugins/payment/quaderno-checkout/quaderno-checkout.php',
            'application/default/plugins/payment/bitpay.php',
            'application/default/plugins/payment/dwolla.php',
            'application/default/plugins/payment/gocardless.php',
            'application/default/plugins/payment/g2a-pay.php',
            'application/default/plugins/payment/fortumo-hosted-dcb.php',
            'application/default/plugins/payment/thrive-cart.php',
            'application/default/plugins/payment/paypro.php',
            'application/default/plugins/payment/payone.php',
            'application/default/plugins/payment/migs.php',
            'application/default/plugins/payment/myshortcart-bca.php',
            'application/default/plugins/payment/micropayment/scripts/micropayment-confirm.phtml',
            'application/default/plugins/payment/micropayment/micropayment.php',
            'application/default/plugins/payment/boleto-bancario.php',
            'application/default/plugins/payment/selz/scripts/selz.phtml',
            'application/default/plugins/payment/selz/selz.php',
            'application/default/plugins/payment/allopass/apikit/exception/AllopassApiFalseResponseSignatureException.php',
            'application/default/plugins/payment/allopass/apikit/exception/AllopassApiMissingHashFeatureException.php',
            'application/default/plugins/payment/allopass/apikit/exception/AllopassApiException.php',
            'application/default/plugins/payment/allopass/apikit/exception/AllopassApiConfAccountNotFoundException.php',
            'application/default/plugins/payment/allopass/apikit/exception/AllopassApiRemoteErrorException.php',
            'application/default/plugins/payment/allopass/apikit/exception/AllopassApiMissingXMLFeatureException.php',
            'application/default/plugins/payment/allopass/apikit/exception/AllopassApiConfFileMissingException.php',
            'application/default/plugins/payment/allopass/apikit/exception/AllopassApiMissingNetworkFeatureException.php',
            'application/default/plugins/payment/allopass/apikit/exception/AllopassApiConfFileMissingSectionException.php',
            'application/default/plugins/payment/allopass/apikit/exception/AllopassApiConfFileCorruptedException.php',
            'application/default/plugins/payment/allopass/apikit/exception/AllopassApiUnavailableRessourceException.php',
            'application/default/plugins/payment/allopass/apikit/exception/AllopassApiWrongFormatResponseException.php',
            'application/default/plugins/payment/allopass/apikit/exception/AllopassApiMissingCompressionFeatureException.php',
            'application/default/plugins/payment/allopass/apikit/conf/conf.xml',
            'application/default/plugins/payment/allopass/apikit/model/AllopassSubscriptionDetailRequest.php',
            'application/default/plugins/payment/allopass/apikit/model/AllopassOnetimeButtonResponse.php',
            'application/default/plugins/payment/allopass/apikit/model/AllopassOnetimeDiscreteButtonRequest.php',
            'application/default/plugins/payment/allopass/apikit/model/AllopassPartner.php',
            'application/default/plugins/payment/allopass/apikit/model/AllopassOnetimePricingResponse.php',
            'application/default/plugins/payment/allopass/apikit/model/AllopassTransactionDetailResponse.php',
            'application/default/plugins/payment/allopass/apikit/model/AllopassPricepoint.php',
            'application/default/plugins/payment/allopass/apikit/model/AllopassApiRequest.php',
            'application/default/plugins/payment/allopass/apikit/model/AllopassApiPlainResponse.php',
            'application/default/plugins/payment/allopass/apikit/model/AllopassPhoneNumber.php',
            'application/default/plugins/payment/allopass/apikit/model/AllopassOnetimeButtonRequest.php',
            'application/default/plugins/payment/allopass/apikit/model/AllopassApiResponse.php',
            'application/default/plugins/payment/allopass/apikit/model/AllopassSubscriptionDetailResponse.php',
            'application/default/plugins/payment/allopass/apikit/model/AllopassPeriodicity.php',
            'application/default/plugins/payment/allopass/apikit/model/AllopassOnetimeDiscretePricingRequest.php',
            'application/default/plugins/payment/allopass/apikit/model/AllopassOffer.php',
            'application/default/plugins/payment/allopass/apikit/model/AllopassCountry.php',
            'application/default/plugins/payment/allopass/apikit/model/AllopassSubscriptionLoginRequest.php',
            'application/default/plugins/payment/allopass/apikit/model/AllopassOnetimeValidateCodesResponse.php',
            'application/default/plugins/payment/allopass/apikit/model/AllopassTransactionDetailRequest.php',
            'application/default/plugins/payment/allopass/apikit/model/AllopassSubscriptionLoginResponse.php',
            'application/default/plugins/payment/allopass/apikit/model/AllopassCode.php',
            'application/default/plugins/payment/allopass/apikit/model/AllopassOnetimePricingRequest.php',
            'application/default/plugins/payment/allopass/apikit/model/AllopassPayout.php',
            'application/default/plugins/payment/allopass/apikit/model/AllopassTransactionPrepareRequest.php',
            'application/default/plugins/payment/allopass/apikit/model/AllopassMarket.php',
            'application/default/plugins/payment/allopass/apikit/model/AllopassTransactionPrepareResponse.php',
            'application/default/plugins/payment/allopass/apikit/model/AllopassProductDetailRequest.php',
            'application/default/plugins/payment/allopass/apikit/model/AllopassOnetimeValidateCodesRequest.php',
            'application/default/plugins/payment/allopass/apikit/model/AllopassApiConf.php',
            'application/default/plugins/payment/allopass/apikit/model/AllopassProduct.php',
            'application/default/plugins/payment/allopass/apikit/model/AllopassTransactionMerchantRequest.php',
            'application/default/plugins/payment/allopass/apikit/model/AllopassWebsite.php',
            'application/default/plugins/payment/allopass/apikit/model/AllopassDate.php',
            'application/default/plugins/payment/allopass/apikit/model/AllopassPrice.php',
            'application/default/plugins/payment/allopass/apikit/model/AllopassRegion.php',
            'application/default/plugins/payment/allopass/apikit/model/AllopassKeyword.php',
            'application/default/plugins/payment/allopass/apikit/model/AllopassProductDetailResponse.php',
            'application/default/plugins/payment/allopass/apikit/model/AllopassApiMappingResponse.php',
            'application/default/plugins/payment/allopass/apikit/api/AllopassAPI.php',
            'application/default/plugins/payment/allopass/apikit/tools/AllopassApiTools.php',
            'application/default/plugins/payment/allopass/allopass.php',
            'application/default/plugins/payment/dotpay.php',
            'application/default/plugins/payment/gumroad.php',
            'application/default/plugins/payment/paypal.php',
            'application/default/plugins/payment/ebs.php',
            'application/default/plugins/payment/cashenvoy/cashenvoy.php',
            'application/default/plugins/payment/cashenvoy/scripts/confirm.phtml',
            'application/default/plugins/payment/checkout-enets.php',
            'application/default/plugins/payment/paypal-plus/paypal-plus.php',
            'application/default/plugins/payment/paypal-plus/scripts/confirm.phtml',
            'application/default/plugins/payment/charge2000.php',
            'application/default/plugins/payment/gocoin.php',
            'application/default/plugins/payment/a1pay.php',
            'application/default/plugins/payment/i-payout.php',
            'application/default/plugins/payment/algocharge.php',
            'application/default/plugins/payment/centili.php',
            'application/default/plugins/payment/dalpay-checkout.php',
            'application/default/plugins/payment/multisafepay/MultiSafepay.class.php',
            'application/default/plugins/payment/multisafepay/multisafepay.php',
            'application/default/plugins/payment/epayment.php',
            'application/default/plugins/payment/paddle/paddle.php',
            'application/default/plugins/payment/paddle/paddle.phtml',
            'application/default/plugins/payment/yandex.php',
            'application/default/plugins/payment/mollie-ideal/public/mollie_logo.gif',
            'application/default/plugins/payment/mollie-ideal/public/betaalscherm-bg-1.jpg',
            'application/default/plugins/payment/mollie-ideal/public/style.css',
            'application/default/plugins/payment/mollie-ideal/public/ideal.gif',
            'application/default/plugins/payment/mollie-ideal/scripts/payment-mollie-ideal-redirect.phtml',
            'application/default/plugins/payment/mollie-ideal/scripts/payment-mollie-ideal-thanks.phtml',
            'application/default/plugins/payment/mollie-ideal/Mollie/Ideal.php',
            'application/default/plugins/payment/mollie-ideal/mollie-ideal.php',
            'application/default/plugins/payment/payanyway.php',
            'application/default/plugins/payment/clickbank.php',
            'application/default/plugins/payment/metacharge.php',
            'application/default/plugins/payment/pay-nl/composer.json',
            'application/default/plugins/payment/pay-nl/pay-nl.php',
            'application/default/plugins/payment/pay-nl/vendor/php-curl-class/php-curl-class/SECURITY.md',
            'application/default/plugins/payment/pay-nl/vendor/php-curl-class/php-curl-class/composer.json',
            'application/default/plugins/payment/pay-nl/vendor/php-curl-class/php-curl-class/LICENSE',
            'application/default/plugins/payment/pay-nl/vendor/php-curl-class/php-curl-class/README.md',
            'application/default/plugins/payment/pay-nl/vendor/php-curl-class/php-curl-class/CHANGELOG.md',
            'application/default/plugins/payment/pay-nl/vendor/php-curl-class/php-curl-class/src/Curl/Decoder.php',
            'application/default/plugins/payment/pay-nl/vendor/php-curl-class/php-curl-class/src/Curl/StringUtil.php',
            'application/default/plugins/payment/pay-nl/vendor/php-curl-class/php-curl-class/src/Curl/CaseInsensitiveArray.php',
            'application/default/plugins/payment/pay-nl/vendor/php-curl-class/php-curl-class/src/Curl/Encoder.php',
            'application/default/plugins/payment/pay-nl/vendor/php-curl-class/php-curl-class/src/Curl/Curl.php',
            'application/default/plugins/payment/pay-nl/vendor/php-curl-class/php-curl-class/src/Curl/Url.php',
            'application/default/plugins/payment/pay-nl/vendor/php-curl-class/php-curl-class/src/Curl/ArrayUtil.php',
            'application/default/plugins/payment/pay-nl/vendor/php-curl-class/php-curl-class/src/Curl/MultiCurl.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/composer.json',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/README.md',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/tests/PaymentmethodsTest.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/tests/HelperTest.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/tests/dummyData/Merchant/addTrademark.json',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/tests/dummyData/Merchant/deleteTrademark.json',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/tests/dummyData/Merchant/addTrademarkError.json',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/tests/dummyData/Merchant/info.json',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/tests/dummyData/Merchant/infoError.json',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/tests/dummyData/Merchant/deleteTrademarkError.json',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/tests/dummyData/Refund/refund.json',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/tests/dummyData/Refund/refundError.json',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/tests/dummyData/Refund/info.json',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/tests/dummyData/Transaction/startOk.json',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/tests/dummyData/Transaction/Result/capture.json',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/tests/dummyData/Transaction/Result/refund.json',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/tests/dummyData/Transaction/Result/transactionVerify.json',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/tests/dummyData/Transaction/Result/void.json',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/tests/dummyData/Transaction/Result/transactionPaid.json',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/tests/dummyData/Transaction/Result/decline.json',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/tests/dummyData/Transaction/Result/approve.json',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/tests/dummyData/Transaction/Result/refundError.json',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/tests/dummyData/currencies.json',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/tests/dummyData/getService.json',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/tests/dummyData/Validate/isPayServerIpNo.json',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/tests/dummyData/Validate/isPayServerIpYes.json',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/tests/MerchantTest.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/tests/RefundTest.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/tests/ConfigTest.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/tests/TransactionTest.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/tests/ValidateTest.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/tests/CurrencyTest.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/.travis.yml',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Config.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/DirectDebit.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Validate.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Refund.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Voucher.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Currency.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Transaction.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/Merchant/AddTrademark.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/Merchant/Info.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/Merchant/DeleteTrademark.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/Merchant/Merchant.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/Refund/Refund.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/Refund/Add.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/Refund/Info.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/Currency/GetAll.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/Currency/Currency.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/Transaction/Refund.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/Transaction/Capture.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/Transaction/GetService.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/Transaction/VoidTransaction.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/Transaction/Approve.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/Transaction/Transaction.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/Transaction/Start.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/Transaction/Decline.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/Transaction/Info.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/Transaction/ConfirmExternalPayment.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/Transaction/Status.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/Transaction/AddRecurring.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/Transaction/QRPayment.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/Instore/ConfirmPayment.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/Instore/GetTransactionTicket.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/Instore/GetAllTerminals.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/Instore/Instore.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/Instore/Status.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/Instore/Payment.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/Service/GetAll.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/Service/GetPayLinkUrl.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/Service/Service.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/DirectDebit/MandateDebit.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/DirectDebit/DirectDebit.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/DirectDebit/MandateAdd.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/DirectDebit/DebitAdd.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/DirectDebit/MandateGet.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/DirectDebit/Delete.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/DirectDebit/DebitGet.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/DirectDebit/RecurringGet.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/DirectDebit/RecurringAdd.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/DirectDebit/Update.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/Api.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/Voucher/Voucher.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/Voucher/Charge.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/Voucher/Balance.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/Voucher/Activate.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/Validate/Validate.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Api/Validate/IsPayServerIp.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Instore.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/StaticUUID.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Error/Required/ApiToken.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Error/Required/ServiceId.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Error/InvalidArgument.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Error/Api.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Error/NotFound.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Error/Required.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Error/Error.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Paymentmethods.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Service.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/DirectDebit/Recurring.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/DirectDebit/Mandate.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Result/Merchant/Info.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Result/Refund/Refund.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Result/Refund/Add.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Result/Result.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Result/Transaction/Refund.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Result/Transaction/Transaction.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Result/Transaction/Start.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Result/Transaction/ConfirmExternalPayment.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Result/Transaction/Status.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Result/Transaction/AddRecurring.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Result/Transaction/QRPayment.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Result/Instore/ConfirmPayment.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Result/Instore/Terminals.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Result/Instore/Status.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Result/Instore/Receipt.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Result/Instore/Payment.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Result/DirectDebit/Recurring/Add.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Result/DirectDebit/Recurring/Get.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Result/DirectDebit/Mandate/AddTransaction.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Result/DirectDebit/Mandate/Add.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Result/DirectDebit/Mandate/Get.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Result/DirectDebit/Add.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Result/DirectDebit/Get.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Result/Voucher/Voucher.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Merchant.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/DynamicUUID.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Curl/CurlInterface.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Curl/Dummy.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/src/Helper.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/samples/exchange.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/samples/config.sample.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/samples/instore/payment.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/samples/instore/getAllTerminals.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/samples/instore/getReceipt.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/samples/instore/confirmPayment.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/samples/instore/status.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/samples/instore/simple-transaction.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/samples/DynamicUUID/encode.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/samples/DynamicUUID/validate.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/samples/DynamicUUID/decode.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/samples/merchant/addTradeName.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/samples/merchant/deleteTradeName.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/samples/merchant/info.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/samples/merchant/getTradeNames.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/samples/validate/isPayServerIp.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/samples/refund/get.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/samples/directDebit/mandate/get.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/samples/directDebit/mandate/add.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/samples/directDebit/mandate/addTransaction.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/samples/directDebit/get.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/samples/directDebit/recurring/get.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/samples/directDebit/recurring/add.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/samples/directDebit/add.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/samples/service/getAll.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/samples/service/getPaylinkUrl.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/samples/return.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/samples/voucher/charge.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/samples/voucher/activate.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/samples/voucher/balance.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/samples/transaction/void.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/samples/transaction/get.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/samples/transaction/qrPayment.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/samples/transaction/capture.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/samples/transaction/refund.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/samples/transaction/start.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/samples/transaction/addRecurring.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/samples/transaction/paymentMethods.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/samples/transaction/start-minimum.php',
            'application/default/plugins/payment/pay-nl/vendor/paynl/sdk/.gitignore',
            'application/default/plugins/payment/pay-nl/vendor/composer/installed.json',
            'application/default/plugins/payment/pay-nl/vendor/composer/LICENSE',
            'application/default/plugins/payment/pay-nl/vendor/composer/autoload_real.php',
            'application/default/plugins/payment/pay-nl/vendor/composer/ClassLoader.php',
            'application/default/plugins/payment/pay-nl/vendor/composer/autoload_classmap.php',
            'application/default/plugins/payment/pay-nl/vendor/composer/autoload_static.php',
            'application/default/plugins/payment/pay-nl/vendor/composer/autoload_psr4.php',
            'application/default/plugins/payment/pay-nl/vendor/composer/autoload_namespaces.php',
            'application/default/plugins/payment/pay-nl/vendor/autoload.php',
            'application/default/plugins/payment/pay-nl/composer.lock',
            'application/default/plugins/payment/bluesnap.php',
            'application/default/plugins/payment/touchnet-upay.php',
            'application/default/plugins/payment/voguepay.php',
            'application/default/plugins/payment/maksekeskus-redirect.php',
            'application/default/plugins/payment/ecsuite.php',
            'application/default/plugins/payment/nab.php',
            'application/default/plugins/payment/paymentwall.php',
            'application/default/plugins/payment/wepay.php',
            'application/default/plugins/payment/eway-sp.php',
            'application/default/plugins/payment/sliiing/scripts/sliiing-confirm.phtml',
            'application/default/plugins/payment/sliiing/sliiing.php',
            'application/default/plugins/payment/payeer.php',
            'application/default/plugins/payment/orbitalpay-form.php',
            'application/default/plugins/payment/2pay4you.php',
            'application/default/plugins/payment/darren.php',
            'application/default/plugins/payment/netdebits/netdebits.php',
            'application/default/plugins/payment/netdebits/scripts/payment-netdebit-redirect.phtml',
            'application/default/plugins/payment/gourl/gourl.php',
            'application/default/plugins/payment/gourl/gourl.phtml',
            'application/default/plugins/payment/epdq.php',
            'application/default/plugins/payment/walletone.php',
            'application/default/plugins/payment/swreg.php',
            'application/default/plugins/payment/jambopay.php',
            'application/default/plugins/payment/limelight.php',
            'application/default/plugins/payment/postfinance.php',
            'application/default/plugins/payment/netbilling-form.php',
            'application/default/plugins/payment/dineromail.php',
            'application/default/plugins/payment/offline.php',
            'application/default/plugins/payment/mollie.php',
            'application/default/plugins/payment/senangpay.php',
            'application/default/plugins/payment/payssion/payssion.php',
            'application/default/plugins/payment/payssion/scripts/payssion.phtml',
            'application/default/plugins/payment/payssion/lib/cacert.pem',
            'application/default/plugins/payment/payssion/lib/PayssionClient.php',
            'application/default/plugins/payment/sagepay-form.php',
            'application/default/plugins/payment/easypaydirect.php',
            'application/default/plugins/payment/certopay.php',
            'application/default/plugins/payment/dibs.php',
            'application/default/plugins/payment/justclick.php',
            'application/default/plugins/payment/korta.php',
            'application/default/plugins/payment/e-ghl.php',
            'application/default/plugins/payment/mikro-odeme.php',
            'application/default/plugins/payment/payflow-link.php',
            'application/default/plugins/payment/paypal-hosted.php',
            'application/default/plugins/payment/checkout/checkout.php',
            'application/default/plugins/payment/checkout/scripts/payment-checkout-redirect.phtml',
            'application/default/plugins/payment/inet-cash/scripts/inet-cash.phtml',
            'application/default/plugins/payment/inet-cash/inet-cash.php',
            'application/default/plugins/payment/ccbill.php',
            'application/default/plugins/payment/ipaymu.php',
            'application/default/plugins/payment/coinsnap.php',
            'application/default/plugins/payment/coinbase-commerce.php',
            'application/default/plugins/payment/1shoppingcart.php',
            'application/default/plugins/payment/myshortcart/myshortcartbase.php',
            'application/default/plugins/payment/myshortcart/transaction.php',
            'application/default/plugins/payment/myshortcart/myshortcart.php',
            'application/default/plugins/payment/rocketgate.php',
            'application/default/plugins/payment/psigate.php',
            'application/default/plugins/payment/interkassa.php',
            'application/default/plugins/payment/jvzoo.php',
            'application/default/plugins/payment/deal-guardian.php',
            'application/default/plugins/payment/fastspring-contextual.php',
            'application/default/plugins/payment/free.php',
            'application/default/plugins/payment/ipaydna.php',
            'application/default/plugins/payment/plimus.php',
            'application/default/plugins/payment/zaxaa.php',
            'application/default/plugins/payment/warrior-payments.php',
            'application/default/plugins/payment/realexpayments.php',
            'application/default/plugins/payment/paytrail.php',
            'application/default/plugins/payment/smart-debit-dl.php',
            'application/default/plugins/payment/clickbetter.php',
            'application/default/plugins/payment/paydotcom.php',
            'application/default/plugins/payment/payfast.php',
            'application/default/plugins/payment/pagseguro-v2.php',
            'application/default/plugins/payment/redsys.php',
            'application/default/plugins/payment/epay-bg.php',
            'application/default/plugins/payment/zombaio.php',
            'application/default/plugins/payment/epoch.php',
            'application/default/plugins/payment/fastspring.php',
            'application/default/plugins/payment/cl3ar.php',
            'application/default/plugins/payment/safecharge.php',
            'application/default/plugins/payment/bitpay/Bitpay/ApplicationInterface.php',
            'application/default/plugins/payment/bitpay/Bitpay/Config/Configuration.php',
            'application/default/plugins/payment/bitpay/Bitpay/Schedule.php',
            'application/default/plugins/payment/bitpay/Bitpay/PointInterface.php',
            'application/default/plugins/payment/bitpay/Bitpay/Payout.php',
            'application/default/plugins/payment/bitpay/Bitpay/ItemInterface.php',
            'application/default/plugins/payment/bitpay/Bitpay/ScheduleInterface.php',
            'application/default/plugins/payment/bitpay/Bitpay/Key.php',
            'application/default/plugins/payment/bitpay/Bitpay/SinKey.php',
            'application/default/plugins/payment/bitpay/Bitpay/PayoutInstruction.php',
            'application/default/plugins/payment/bitpay/Bitpay/Item.php',
            'application/default/plugins/payment/bitpay/Bitpay/Invoice.php',
            'application/default/plugins/payment/bitpay/Bitpay/Bill.php',
            'application/default/plugins/payment/bitpay/Bitpay/Application.php',
            'application/default/plugins/payment/bitpay/Bitpay/PayoutTransactionInterface.php',
            'application/default/plugins/payment/bitpay/Bitpay/CurrencyInterface.php',
            'application/default/plugins/payment/bitpay/Bitpay/BillInterface.php',
            'application/default/plugins/payment/bitpay/Bitpay/KeyManager.php',
            'application/default/plugins/payment/bitpay/Bitpay/Network/Testnet.php',
            'application/default/plugins/payment/bitpay/Bitpay/Network/Livenet.php',
            'application/default/plugins/payment/bitpay/Bitpay/Network/NetworkInterface.php',
            'application/default/plugins/payment/bitpay/Bitpay/Network/NetworkAware.php',
            'application/default/plugins/payment/bitpay/Bitpay/Network/Customnet.php',
            'application/default/plugins/payment/bitpay/Bitpay/Network/NetworkAwareInterface.php',
            'application/default/plugins/payment/bitpay/Bitpay/DependencyInjection/BitpayExtension.php',
            'application/default/plugins/payment/bitpay/Bitpay/DependencyInjection/services.xml',
            'application/default/plugins/payment/bitpay/Bitpay/DependencyInjection/Loader/ArrayLoader.php',
            'application/default/plugins/payment/bitpay/Bitpay/PayoutInterface.php',
            'application/default/plugins/payment/bitpay/Bitpay/Bitpay.php',
            'application/default/plugins/payment/bitpay/Bitpay/Currency.php',
            'application/default/plugins/payment/bitpay/Bitpay/BuyerInterface.php',
            'application/default/plugins/payment/bitpay/Bitpay/Util/Base58.php',
            'application/default/plugins/payment/bitpay/Bitpay/Util/Fingerprint.php',
            'application/default/plugins/payment/bitpay/Bitpay/Util/SecureRandom.php',
            'application/default/plugins/payment/bitpay/Bitpay/Util/Secp256k1.php',
            'application/default/plugins/payment/bitpay/Bitpay/Util/Util.php',
            'application/default/plugins/payment/bitpay/Bitpay/Util/CurveParameterInterface.php',
            'application/default/plugins/payment/bitpay/Bitpay/Util/Error.php',
            'application/default/plugins/payment/bitpay/Bitpay/TokenInterface.php',
            'application/default/plugins/payment/bitpay/Bitpay/Autoloader.php',
            'application/default/plugins/payment/bitpay/Bitpay/PublicKey.php',
            'application/default/plugins/payment/bitpay/Bitpay/Client/Client.php',
            'application/default/plugins/payment/bitpay/Bitpay/Client/RequestInterface.php',
            'application/default/plugins/payment/bitpay/Bitpay/Client/ConnectionException.php',
            'application/default/plugins/payment/bitpay/Bitpay/Client/Response.php',
            'application/default/plugins/payment/bitpay/Bitpay/Client/ResponseInterface.php',
            'application/default/plugins/payment/bitpay/Bitpay/Client/ArgumentException.php',
            'application/default/plugins/payment/bitpay/Bitpay/Client/ClientInterface.php',
            'application/default/plugins/payment/bitpay/Bitpay/Client/BitpayException.php',
            'application/default/plugins/payment/bitpay/Bitpay/Client/Adapter/ca-bundle.crt',
            'application/default/plugins/payment/bitpay/Bitpay/Client/Adapter/AdapterInterface.php',
            'application/default/plugins/payment/bitpay/Bitpay/Client/Adapter/CurlAdapter.php',
            'application/default/plugins/payment/bitpay/Bitpay/Client/Request.php',
            'application/default/plugins/payment/bitpay/Bitpay/AccessToken.php',
            'application/default/plugins/payment/bitpay/Bitpay/Buyer.php',
            'application/default/plugins/payment/bitpay/Bitpay/User.php',
            'application/default/plugins/payment/bitpay/Bitpay/Token.php',
            'application/default/plugins/payment/bitpay/Bitpay/PayoutInstructionInterface.php',
            'application/default/plugins/payment/bitpay/Bitpay/KeyInterface.php',
            'application/default/plugins/payment/bitpay/Bitpay/PayoutTransaction.php',
            'application/default/plugins/payment/bitpay/Bitpay/Crypto/OpenSSLExtension.php',
            'application/default/plugins/payment/bitpay/Bitpay/Crypto/CryptoInterface.php',
            'application/default/plugins/payment/bitpay/Bitpay/Crypto/HashExtension.php',
            'application/default/plugins/payment/bitpay/Bitpay/Crypto/McryptExtension.php',
            'application/default/plugins/payment/bitpay/Bitpay/Math/GmpEngine.php',
            'application/default/plugins/payment/bitpay/Bitpay/Math/EngineInterface.php',
            'application/default/plugins/payment/bitpay/Bitpay/Math/Math.php',
            'application/default/plugins/payment/bitpay/Bitpay/Math/BcEngine.php',
            'application/default/plugins/payment/bitpay/Bitpay/Point.php',
            'application/default/plugins/payment/bitpay/Bitpay/PrivateKey.php',
            'application/default/plugins/payment/bitpay/Bitpay/InvoiceInterface.php',
            'application/default/plugins/payment/bitpay/Bitpay/AccessTokenInterface.php',
            'application/default/plugins/payment/bitpay/Bitpay/Storage/StorageInterface.php',
            'application/default/plugins/payment/bitpay/Bitpay/Storage/FilesystemStorage.php',
            'application/default/plugins/payment/bitpay/Bitpay/Storage/MockStorage.php',
            'application/default/plugins/payment/bitpay/Bitpay/Storage/EncryptedFilesystemStorage.php',
            'application/default/plugins/payment/bitpay/Bitpay/UserInterface.php',
            'application/default/plugins/payment/ccnow.php',
            'application/default/plugins/payment/google-checkout.php',
            'application/default/plugins/payment/junglepay/scripts/payment-junglepay-iframe.phtml',
            'application/default/plugins/payment/junglepay/junglepay.php',
            'application/default/plugins/payment/multicards.php',
            'application/default/plugins/payment/itransact.php',
            'application/default/plugins/payment/alipay.php',
            'application/default/plugins/payment/blockchain/blockchain.php',
            'application/default/plugins/payment/paypal-express.php',
            'application/default/plugins/payment/worldpay.php',
            'application/default/plugins/payment/myshortcart-alfa.php',
            'application/default/plugins/payment/flexpay.php',
            'application/default/plugins/payment/fortumo/scripts/fortumo-payment.phtml',
            'application/default/plugins/payment/fortumo/fortumo.php',
            'application/default/plugins/payment/safecart.php',
            'application/default/plugins/payment/bankart.php',
            'application/default/plugins/payment/first-atlantic-commerce.php',
            'application/default/plugins/payment/officeautopilot.php',
            'application/default/plugins/payment/fasapay.php',
            'application/default/plugins/payment/premiumwebcart.php',
            'application/default/plugins/payment/toyyib-pay.php',
            'application/default/plugins/payment/internet-secure.php',
            'application/default/plugins/payment/paypoint.php',
            'application/default/plugins/payment/przelewy24.php',
            'application/default/plugins/payment/btcpay/btcpay.php',
            'application/default/plugins/payment/btcpay/Bitpay/ApplicationInterface.php',
            'application/default/plugins/payment/btcpay/Bitpay/Config/Configuration.php',
            'application/default/plugins/payment/btcpay/Bitpay/Schedule.php',
            'application/default/plugins/payment/btcpay/Bitpay/PointInterface.php',
            'application/default/plugins/payment/btcpay/Bitpay/Payout.php',
            'application/default/plugins/payment/btcpay/Bitpay/ItemInterface.php',
            'application/default/plugins/payment/btcpay/Bitpay/ScheduleInterface.php',
            'application/default/plugins/payment/btcpay/Bitpay/Key.php',
            'application/default/plugins/payment/btcpay/Bitpay/SinKey.php',
            'application/default/plugins/payment/btcpay/Bitpay/PayoutInstruction.php',
            'application/default/plugins/payment/btcpay/Bitpay/Item.php',
            'application/default/plugins/payment/btcpay/Bitpay/Invoice.php',
            'application/default/plugins/payment/btcpay/Bitpay/Bill.php',
            'application/default/plugins/payment/btcpay/Bitpay/Application.php',
            'application/default/plugins/payment/btcpay/Bitpay/PayoutTransactionInterface.php',
            'application/default/plugins/payment/btcpay/Bitpay/CurrencyInterface.php',
            'application/default/plugins/payment/btcpay/Bitpay/BillInterface.php',
            'application/default/plugins/payment/btcpay/Bitpay/KeyManager.php',
            'application/default/plugins/payment/btcpay/Bitpay/Network/Testnet.php',
            'application/default/plugins/payment/btcpay/Bitpay/Network/Livenet.php',
            'application/default/plugins/payment/btcpay/Bitpay/Network/NetworkInterface.php',
            'application/default/plugins/payment/btcpay/Bitpay/Network/NetworkAware.php',
            'application/default/plugins/payment/btcpay/Bitpay/Network/Customnet.php',
            'application/default/plugins/payment/btcpay/Bitpay/Network/NetworkAwareInterface.php',
            'application/default/plugins/payment/btcpay/Bitpay/DependencyInjection/BitpayExtension.php',
            'application/default/plugins/payment/btcpay/Bitpay/DependencyInjection/services.xml',
            'application/default/plugins/payment/btcpay/Bitpay/DependencyInjection/Loader/ArrayLoader.php',
            'application/default/plugins/payment/btcpay/Bitpay/PayoutInterface.php',
            'application/default/plugins/payment/btcpay/Bitpay/Bitpay.php',
            'application/default/plugins/payment/btcpay/Bitpay/Currency.php',
            'application/default/plugins/payment/btcpay/Bitpay/BuyerInterface.php',
            'application/default/plugins/payment/btcpay/Bitpay/Util/Base58.php',
            'application/default/plugins/payment/btcpay/Bitpay/Util/Fingerprint.php',
            'application/default/plugins/payment/btcpay/Bitpay/Util/SecureRandom.php',
            'application/default/plugins/payment/btcpay/Bitpay/Util/Secp256k1.php',
            'application/default/plugins/payment/btcpay/Bitpay/Util/Util.php',
            'application/default/plugins/payment/btcpay/Bitpay/Util/CurveParameterInterface.php',
            'application/default/plugins/payment/btcpay/Bitpay/Util/Error.php',
            'application/default/plugins/payment/btcpay/Bitpay/TokenInterface.php',
            'application/default/plugins/payment/btcpay/Bitpay/Autoloader.php',
            'application/default/plugins/payment/btcpay/Bitpay/PublicKey.php',
            'application/default/plugins/payment/btcpay/Bitpay/Client/Client.php',
            'application/default/plugins/payment/btcpay/Bitpay/Client/RequestInterface.php',
            'application/default/plugins/payment/btcpay/Bitpay/Client/ConnectionException.php',
            'application/default/plugins/payment/btcpay/Bitpay/Client/Response.php',
            'application/default/plugins/payment/btcpay/Bitpay/Client/ResponseInterface.php',
            'application/default/plugins/payment/btcpay/Bitpay/Client/ArgumentException.php',
            'application/default/plugins/payment/btcpay/Bitpay/Client/ClientInterface.php',
            'application/default/plugins/payment/btcpay/Bitpay/Client/BitpayException.php',
            'application/default/plugins/payment/btcpay/Bitpay/Client/Adapter/ca-bundle.crt',
            'application/default/plugins/payment/btcpay/Bitpay/Client/Adapter/AdapterInterface.php',
            'application/default/plugins/payment/btcpay/Bitpay/Client/Adapter/CurlAdapter.php',
            'application/default/plugins/payment/btcpay/Bitpay/Client/Request.php',
            'application/default/plugins/payment/btcpay/Bitpay/AccessToken.php',
            'application/default/plugins/payment/btcpay/Bitpay/Buyer.php',
            'application/default/plugins/payment/btcpay/Bitpay/User.php',
            'application/default/plugins/payment/btcpay/Bitpay/Token.php',
            'application/default/plugins/payment/btcpay/Bitpay/PayoutInstructionInterface.php',
            'application/default/plugins/payment/btcpay/Bitpay/KeyInterface.php',
            'application/default/plugins/payment/btcpay/Bitpay/PayoutTransaction.php',
            'application/default/plugins/payment/btcpay/Bitpay/Crypto/OpenSSLExtension.php',
            'application/default/plugins/payment/btcpay/Bitpay/Crypto/CryptoInterface.php',
            'application/default/plugins/payment/btcpay/Bitpay/Crypto/HashExtension.php',
            'application/default/plugins/payment/btcpay/Bitpay/Crypto/McryptExtension.php',
            'application/default/plugins/payment/btcpay/Bitpay/Math/GmpEngine.php',
            'application/default/plugins/payment/btcpay/Bitpay/Math/EngineInterface.php',
            'application/default/plugins/payment/btcpay/Bitpay/Math/Math.php',
            'application/default/plugins/payment/btcpay/Bitpay/Math/BcEngine.php',
            'application/default/plugins/payment/btcpay/Bitpay/Point.php',
            'application/default/plugins/payment/btcpay/Bitpay/PrivateKey.php',
            'application/default/plugins/payment/btcpay/Bitpay/InvoiceInterface.php',
            'application/default/plugins/payment/btcpay/Bitpay/AccessTokenInterface.php',
            'application/default/plugins/payment/btcpay/Bitpay/Storage/StorageInterface.php',
            'application/default/plugins/payment/btcpay/Bitpay/Storage/FilesystemStorage.php',
            'application/default/plugins/payment/btcpay/Bitpay/Storage/MockStorage.php',
            'application/default/plugins/payment/btcpay/Bitpay/Storage/EncryptedFilesystemStorage.php',
            'application/default/plugins/payment/btcpay/Bitpay/UserInterface.php',
            'application/default/plugins/payment/gocardlesspro.php',
            'application/default/plugins/payment/molpay.php',
            'application/default/plugins/payment/verotel-flexpay.php',
            'application/default/plugins/payment/snappy-checkout.php',
            'application/default/plugins/payment/authorize-sim.php',
            'application/default/plugins/payment/razorpay/scripts/form.phtml',
            'application/default/plugins/payment/razorpay/razorpay.php',
            'application/default/plugins/payment/nanacast.php',
            'application/default/plugins/payment/ideal/public/style.css',
            'application/default/plugins/payment/ideal/public/ideal.gif',
            'application/default/plugins/payment/ideal/scripts/payment-ideal-redirect.phtml',
            'application/default/plugins/payment/ideal/lib/Exceptions/iDEALException.php',
            'application/default/plugins/payment/ideal/lib/Exceptions/SecurityException.php',
            'application/default/plugins/payment/ideal/lib/Exceptions/SerializationException.php',
            'application/default/plugins/payment/ideal/lib/Exceptions/ConnectorException.php',
            'application/default/plugins/payment/ideal/lib/Exceptions/ValidationException.php',
            'application/default/plugins/payment/ideal/lib/Libraries/xmlseclibs.php',
            'application/default/plugins/payment/ideal/lib/Validation/EntityValidator.php',
            'application/default/plugins/payment/ideal/lib/Log/LogLevel.php',
            'application/default/plugins/payment/ideal/lib/Log/IConnectorLog.php',
            'application/default/plugins/payment/ideal/lib/Log/DefaultLog.php',
            'application/default/plugins/payment/ideal/lib/Entities/AbstractRequest.php',
            'application/default/plugins/payment/ideal/lib/Entities/Transaction.php',
            'application/default/plugins/payment/ideal/lib/Entities/AcquirerStatusResponse.php',
            'application/default/plugins/payment/ideal/lib/Entities/Country.php',
            'application/default/plugins/payment/ideal/lib/Entities/AcquirerTransactionRequest.php',
            'application/default/plugins/payment/ideal/lib/Entities/Issuer.php',
            'application/default/plugins/payment/ideal/lib/Entities/AcquirerStatusRequest.php',
            'application/default/plugins/payment/ideal/lib/Entities/AcquirerTransactionResponse.php',
            'application/default/plugins/payment/ideal/lib/Entities/DirectoryRequest.php',
            'application/default/plugins/payment/ideal/lib/Entities/DirectoryResponse.php',
            'application/default/plugins/payment/ideal/lib/Entities/Merchant.php',
            'application/default/plugins/payment/ideal/lib/Entities/AbstractResponse.php',
            'application/default/plugins/payment/ideal/lib/iDEALConnector.php',
            'application/default/plugins/payment/ideal/lib/Xml/XmlSecurity.php',
            'application/default/plugins/payment/ideal/lib/Xml/XmlSerializer.php',
            'application/default/plugins/payment/ideal/lib/Configuration/DefaultConfiguration.php',
            'application/default/plugins/payment/ideal/lib/Configuration/IConnectorConfiguration.php',
            'application/default/plugins/payment/ideal/lib/Http/WebRequest.php',
            'application/default/plugins/payment/ideal/certs/iDEAL_How-To-Generate-Certificates.pdf',
            'application/default/plugins/payment/ideal/ideal.php',
            'application/default/plugins/payment/segpay.php',
            'application/default/plugins/payment/robokassa.php',
            'application/default/plugins/payment/paygarden.php',
            'application/default/plugins/payment/hipay/hipay.php',
            'application/default/plugins/payment/hipay/mapi/mapi_product.php',
            'application/default/plugins/payment/hipay/mapi/mapi_multiplepayment.php',
            'application/default/plugins/payment/hipay/mapi/mapi_payment.php',
            'application/default/plugins/payment/hipay/mapi/mapi_lockable.php',
            'application/default/plugins/payment/hipay/mapi/mapi_comm_xml.php',
            'application/default/plugins/payment/hipay/mapi/mapi_item.php',
            'application/default/plugins/payment/hipay/mapi/mapi_utf8.php',
            'application/default/plugins/payment/hipay/mapi/mapi_xml.php',
            'application/default/plugins/payment/hipay/mapi/mapi_utils.php',
            'application/default/plugins/payment/hipay/mapi/mapi_package.php',
            'application/default/plugins/payment/hipay/mapi/mapi_send_xml.php',
            'application/default/plugins/payment/hipay/mapi/mapi_simplepayment.php',
            'application/default/plugins/payment/hipay/mapi/mapi_paymentparams.php',
            'application/default/plugins/payment/hipay/mapi/mapi_affiliate.php',
            'application/default/plugins/payment/hipay/mapi/mapi_order.php',
            'application/default/plugins/payment/hipay/mapi/mapi_installment.php',
            'application/default/plugins/payment/hipay/mapi/mapi_defs.php',
            'application/default/plugins/payment/hipay/mapi/mapi_tax.php',
            'application/default/plugins/payment/hipay/mapi/mapi_exception.php',
            'application/default/plugins/payment/monelib/public/buyCode_fr.png',
            'application/default/plugins/payment/monelib/public/buyCode_en.png',
            'application/default/plugins/payment/monelib/scripts/monelib.phtml',
            'application/default/plugins/payment/monelib/monelib.php',
            'application/default/plugins/payment/amex-hpp.php',
            'application/default/plugins/payment/splitit/scripts/confirm.phtml',
            'application/default/plugins/payment/splitit/splitit.php',
            'application/default/plugins/payment/ogone.php',
            'application/default/plugins/payment/square-checkout.php',
            'application/default/plugins/payment/jvshare.php',
            'application/default/plugins/payment/chinapaymentservices.php',
            'application/default/plugins/payment/twocheckout.php',
            'application/default/plugins/payment/coinbase.php',
            'application/default/plugins/payment/moneybookers.php',
            'application/default/plugins/payment/nochex.php',
            'application/default/plugins/payment/webmoney.php',
            'application/default/plugins/payment/paymento.php',
            'application/default/plugins/payment/pagseguro.php',
            'application/default/plugins/payment/hotmart.php',
            'application/default/plugins/payment/clickfunnels.php',
            'application/default/plugins/payment/pesapal/OAuth.php',
            'application/default/plugins/payment/pesapal/payment-pesapal-confirm.phtml',
            'application/default/plugins/payment/pesapal/payment-pesapal-pending.phtml',
            'application/default/plugins/payment/pesapal/pesapal.php',
            'application/default/plugins/payment/payumoney.php',
            'application/default/plugins/payment/payu.php',
            'application/default/plugins/payment/cashu.php',
            'application/default/plugins/misc/aweber-bypass-api/aweber-bypass-api.php',
            'application/default/plugins/misc/cancel-on-upgrade.php',
            'application/default/plugins/misc/product-required-fields.php',
            'application/default/plugins/misc/lifetime.php',
            'application/default/plugins/misc/paypal-instant-commission/paypal-instant-commission.php',
            'application/default/plugins/misc/paypal-instant-commission/PPAuth.php',
            'application/default/plugins/misc/paypal-instant-commission/views/paypal-instant-commission/paypal-instant-commission.phtml',
            'application/default/plugins/misc/paypal-instant-commission/AuthUtil.php',
            'application/default/plugins/misc/paypal-identity.php',
            'application/default/plugins/misc/product-chain.php',
            'application/default/plugins/misc/freshdesk.php',
            'application/default/plugins/misc/product-ip-limit.php',
            'application/default/plugins/misc/cancel-feedback.php',
            'application/default/plugins/misc/single-login-session.php',
            'application/default/plugins/misc/send-mail-on-invoice.php',
            'application/default/plugins/misc/email-snippet.php',
            'application/default/plugins/misc/shareasale-pixel.php',
            'application/default/plugins/misc/aff-bonus-link.php',
            'application/default/plugins/misc/kunaki.php',
            'application/default/plugins/misc/personal-content.php',
            'application/default/plugins/misc/oto.php',
            'application/default/plugins/misc/shipwire.php',
            'application/default/plugins/misc/external-coupon.php',
            'application/default/plugins/misc/login-monitor.php',
            'application/default/plugins/misc/login-via-ip.php',
            'application/default/plugins/misc/aff-points.php',
            'application/default/plugins/misc/pending-invoice-clear.php',
            'application/default/plugins/misc/invite.php',
            'application/default/plugins/misc/mailgun.php',
            'application/default/plugins/misc/serials.php',
            'application/default/plugins/misc/zoho.php',
            'application/default/plugins/misc/sample-softsale-keygen.php',
            'application/default/plugins/misc/product-auto-hide.php',
            'application/default/plugins/misc/yahoo-signin.php',
            'application/default/plugins/misc/insightly/lib.php',
            'application/default/plugins/misc/insightly/insightly.php',
            'application/default/plugins/misc/supersaas.php',
            'application/default/plugins/misc/gift-card.php',
            'application/default/plugins/misc/xeroapi/xeroapi.php',
            'application/default/plugins/misc/xeroapi/Xero.php',
            'application/default/plugins/misc/thanks-page.php',
            'application/default/plugins/misc/bonus-subscription.php',
            'application/default/plugins/misc/directory-google-maps/directory-google-maps.php',
            'application/default/plugins/misc/one-file-invoices.php',
            'application/default/plugins/misc/directory-search.php',
            'application/default/plugins/misc/billing-plan-country.php',
            'application/default/plugins/misc/jv.php',
            'application/default/plugins/misc/autocoupons.php',
            'application/default/plugins/misc/linkedin.php',
            'application/default/plugins/misc/google-analytics.php',
            'application/default/plugins/misc/schedule-terms-change.php',
            'application/default/plugins/misc/twitch.php',
            'application/default/plugins/misc/conversion-track.php',
            'application/default/plugins/misc/payment-link.php',
            'application/default/plugins/misc/quaderno.php',
            'application/default/plugins/misc/brick-upgrade.php',
            'application/default/plugins/misc/donation.php',
            'application/default/plugins/misc/default-product.php',
            'application/default/plugins/misc/field-revision.php',
            'application/default/plugins/misc/ticket-roster.php',
            'application/default/plugins/misc/gift-vouchers.php',
            'application/default/plugins/misc/login-reminder.php',
            'application/default/plugins/misc/product-password.php',
            'application/default/plugins/misc/billy.php',
            'application/default/plugins/misc/facebook/facebook.php',
            'application/default/plugins/misc/facebook/blocks/fb-signup.phtml',
            'application/default/plugins/misc/facebook/blocks/fb-login.phtml',
            'application/default/plugins/misc/facebook/blocks/fb-like.phtml',
            'application/default/plugins/misc/credits.php',
            'application/default/plugins/misc/aff-bonus.php',
            'application/default/plugins/misc/google-signin.php',
            'application/default/plugins/misc/notification.php',
            'application/default/plugins/misc/afflevels.php',
            'application/default/plugins/misc/mailchimp-resubscribe.php',
            'application/default/plugins/misc/block-pending-invoice.php',
            'application/default/plugins/misc/receiptful.php',
            'application/default/plugins/misc/sendgrid-webhooks.php',
            'application/default/plugins/misc/bundle-discount-adv.php',
            'application/default/plugins/misc/external-signup-overlay/amInvoice.js',
            'application/default/plugins/misc/external-signup-overlay/external-signup-overlay.php',
            'application/default/plugins/misc/pdf-stamping.php',
            'application/default/plugins/misc/thanks-redirect.php',
            'application/default/plugins/misc/two-factor-hotp.php',
            'application/default/plugins/misc/user-report.php',
            'application/default/plugins/misc/two-factor-duosecurity.php',
            'application/default/plugins/misc/milestone.php',
            'application/default/plugins/misc/additional-stripe-sources.php',
            'application/default/plugins/misc/sales-notification.php',
            'application/default/plugins/misc/softsale-rebuild.php',
            'application/default/plugins/misc/link-not-condition.php',
            'application/default/plugins/misc/avatar.php',
            'application/default/plugins/misc/block-disposable-domain.php',
            'application/default/plugins/misc/user-notification.php',
            'application/default/plugins/misc/user-mass-delete.php',
            'application/default/plugins/misc/personal-folder.php',
            'application/default/plugins/misc/shipping-flat.php',
            'application/default/plugins/misc/lifetime-bp.php',
            'application/default/plugins/misc/intercom.php',
            'application/default/plugins/misc/website-toolbox-forum.php',
            'application/default/plugins/misc/aff-auto-assign.php',
            'application/default/plugins/misc/openexchangerates.php',
            'application/default/plugins/misc/dime-sale.php',
            'application/default/plugins/misc/icecast.php',
            'application/default/plugins/misc/infusion-soft/infusion-soft.php',
            'application/default/plugins/misc/fallback.php',
            'application/default/plugins/misc/bundle-discount.php',
            'application/default/plugins/misc/idevaffiliate.php',
            'application/default/plugins/misc/force-i-agree.php',
            'application/default/plugins/misc/email-birthday.php',
            'application/default/plugins/misc/telegram.php',
            'application/default/plugins/misc/subusers-signup-form.php',
            'application/default/plugins/misc/brick-active-subscriptions.php',
            'application/default/plugins/misc/auto-login-placeholder.php',
            'application/default/plugins/misc/widget.php',
            'application/default/plugins/misc/aff-manager.php',
            'application/default/plugins/misc/brick-payment-history.php',
            'application/default/plugins/misc/upsell.php',
            'application/default/plugins/misc/batch-unsubscribe.php',
            'application/default/plugins/misc/drop-me.php',
            'application/default/plugins/misc/misc-campaignmonitor.php',
            'application/default/plugins/misc/access-by-publish-date.php',
            'application/default/plugins/misc/amazon-sns.php',
            'application/default/plugins/misc/stopforumspam.php',
            'application/default/plugins/misc/subscription-limit.php',
            'application/default/plugins/misc/email-lifetime-revenue.php',
            'application/default/plugins/misc/optimize-mail-log.php',
            'application/default/plugins/misc/schedule-access.php',
            'application/default/plugins/misc/maxmind.php',
            'application/default/plugins/misc/block-thanks-page-resources.php',
            'application/default/plugins/misc/getclicky.php',
            'application/default/plugins/misc/aff-leads.php',
            'application/default/plugins/misc/file-upload.php',
            'application/default/plugins/misc/aff-coupons.php',
            'application/default/plugins/misc/two-factor-authy.php',
            'application/default/plugins/misc/adobe-connect.php',
            'application/cc/plugins/comenpay.php',
            'application/cc/plugins/moneris-cc.php',
            'application/cc/plugins/eway-rapid3.php',
            'application/cc/plugins/checkout-com-google-pay.php',
            'application/cc/plugins/graypay.php',
            'application/cc/plugins/networkmerchants-hosted.php',
            'application/cc/plugins/netbanx.php',
            'application/cc/plugins/checkout-com-apple-pay.php',
            'application/cc/plugins/securionpay.php',
            'application/cc/plugins/clicksure.php',
            'application/cc/plugins/vmerchant.php',
            'application/cc/plugins/payeezy-js/payeezy-js.php',
            'application/cc/plugins/payeezy-js/payeezy-js.js',
            'application/cc/plugins/commonpay.php',
            'application/cc/plugins/paymate.php',
            'application/cc/plugins/paymentsgateway-echeck.php',
            'application/cc/plugins/checkout-com.php',
            'application/cc/plugins/bendigo-bank.php',
            'application/cc/plugins/open-gateway.php',
            'application/cc/plugins/whitepayments/whitepayments.php',
            'application/cc/plugins/epay.php',
            'application/cc/plugins/quickpay.php',
            'application/cc/plugins/targetpay-ideal/public/style.css',
            'application/cc/plugins/targetpay-ideal/public/ideal.gif',
            'application/cc/plugins/targetpay-ideal/scripts/payment-targetpay-ideal-redirect.phtml',
            'application/cc/plugins/targetpay-ideal/targetpay-ideal.php',
            'application/cc/plugins/plugnpay.php',
            'application/cc/plugins/redsys-credit-card.php',
            'application/cc/plugins/helcim.php',
            'application/cc/plugins/doku.php',
            'application/cc/plugins/mobiuspay.php',
            'application/cc/plugins/recurly/recurly.php',
            'application/cc/plugins/authorize-echeck.php',
            'application/cc/plugins/eway-iframe/eway-iframe.php',
            'application/cc/plugins/eway-iframe/scripts/eway-iframe.phtml',
            'application/cc/plugins/intuit.php',
            'application/cc/plugins/abnamro.php',
            'application/cc/plugins/paymentsystemsworldwide.php',
            'application/cc/plugins/direct-one.php',
            'application/cc/plugins/eway.php',
            'application/cc/plugins/payonlinesystem.php',
            'application/cc/plugins/commonweb.php',
            'application/cc/plugins/easypaymentgateway.php',
            'application/cc/plugins/bluconnex.php',
            'application/cc/plugins/cybersource.php',
            'application/cc/plugins/evopay.php',
            'application/cc/plugins/tinypass/scripts/tinypass.phtml',
            'application/cc/plugins/tinypass/tinypass.php',
            'application/cc/plugins/tinypass/lib/tinypass.php',
            'application/cc/plugins/system-merchants.php',
            'application/cc/plugins/fhtpay.php',
            'application/cc/plugins/payforit/scripts/payment-payforit-iframe.phtml',
            'application/cc/plugins/payforit/payforit.php',
            'application/cc/plugins/wepay-onsite.php',
            'application/cc/plugins/paystack.php',
            'application/cc/plugins/secure2tech.php',
            'application/cc/plugins/transactium.php',
            'application/cc/plugins/paymentsgateway.php',
            'application/cc/plugins/usaepay.php',
            'application/cc/plugins/securepaycomau.php',
            'application/cc/plugins/bluepay/bp20.php',
            'application/cc/plugins/bluepay/bluepay.php',
            'application/cc/plugins/stripe.php',
            'application/cc/plugins/authorize-cim.php',
            'application/cc/plugins/payment-express.php',
            'application/cc/plugins/4csonline.php',
            'application/cc/plugins/netbilling.php',
            'application/cc/plugins/micropayment-dbt/lib/dispatcher/TServiceDispatcherException.txt',
            'application/cc/plugins/micropayment-dbt/lib/dispatcher/adapter/TDispatchResponseAdapter.php',
            'application/cc/plugins/micropayment-dbt/lib/dispatcher/adapter/IDispatchAdapter.php',
            'application/cc/plugins/micropayment-dbt/lib/dispatcher/adapter/THttpParamsDispatchRequestAdapter.php',
            'application/cc/plugins/micropayment-dbt/lib/dispatcher/adapter/TDispatchAdapterException.txt',
            'application/cc/plugins/micropayment-dbt/lib/dispatcher/adapter/IDispatchRequestAdapter.php',
            'application/cc/plugins/micropayment-dbt/lib/dispatcher/adapter/TNvpDispatchResponseAdapter.php',
            'application/cc/plugins/micropayment-dbt/lib/dispatcher/adapter/IDispatchResponseAdapter.php',
            'application/cc/plugins/micropayment-dbt/lib/dispatcher/adapter/TDispatchAdapter.php',
            'application/cc/plugins/micropayment-dbt/lib/dispatcher/adapter/TDispatchRequestAdapter.php',
            'application/cc/plugins/micropayment-dbt/lib/dispatcher/TServiceDispatcher.php',
            'application/cc/plugins/micropayment-dbt/lib/dispatcher/TNvpServiceDispatcher.php',
            'application/cc/plugins/micropayment-dbt/lib/dispatcher/IServiceDispatcher.php',
            'application/cc/plugins/micropayment-dbt/lib/services/IMcpDebitService_v1_4.php',
            'application/cc/plugins/micropayment-dbt/lib/clients/TSimpleHttpClientException.txt',
            'application/cc/plugins/micropayment-dbt/lib/clients/TSimpleHttpClient.php',
            'application/cc/plugins/micropayment-dbt/lib/common/messages.txt',
            'application/cc/plugins/micropayment-dbt/lib/common/TException.php',
            'application/cc/plugins/micropayment-dbt/lib/common/TServiceProtocol.php',
            'application/cc/plugins/micropayment-dbt/lib/common/ServiceReflection.php',
            'application/cc/plugins/micropayment-dbt/lib/init.php',
            'application/cc/plugins/micropayment-dbt/lib/serializer/TBaseSerializer.php',
            'application/cc/plugins/micropayment-dbt/lib/serializer/ISerializer.php',
            'application/cc/plugins/micropayment-dbt/lib/serializer/TNvpSerializer.php',
            'application/cc/plugins/micropayment-dbt/micropayment-dbt.php',
            'application/cc/plugins/ecorepay.php',
            'application/cc/plugins/ezic.php',
            'application/cc/plugins/iyzico.php',
            'application/cc/plugins/amazon-pay/amazon-pay.php',
            'application/cc/plugins/targetpay-wap.php',
            'application/cc/plugins/bluepay.php',
            'application/cc/plugins/stripe-apple-pay.php',
            'application/cc/plugins/sagepay.php',
            'application/cc/plugins/paypal-pro.php',
            'application/cc/plugins/authorize-dpm.php',
            'application/cc/plugins/clickandbuy/clickandbuy.php',
            'application/cc/plugins/clickandbuy/lib/nusoap.php',
            'application/cc/plugins/sepaone/sepaone.php',
            'application/cc/plugins/sepaone/scripts/sepaone_thanks.phtml',
            'application/cc/plugins/sepaone/scripts/sepaone_info.phtml',
            'application/cc/plugins/networkmerchants.php',
            'application/cc/plugins/ppay.php',
            'application/cc/plugins/slimpay.php',
            'application/cc/plugins/altcharge.php',
            'application/cc/plugins/smart-debit.php',
            'application/cc/plugins/uniteller.php',
            'application/cc/plugins/adyen.php',
            'application/cc/plugins/authorize-aim.php',
            'application/cc/plugins/cc-demo.php',
            'application/cc/plugins/apple-iap.php',
            'application/cc/plugins/allied.php',
            'application/cc/plugins/moip.php',
            'application/cc/plugins/square-up.php',
            'application/cc/plugins/dibs-recurring.php',
            'application/cc/plugins/cardinity.php',
            'application/cc/plugins/swishme.php',
            'application/cc/plugins/innovative.php',
            'application/cc/plugins/payflow.php',
            'application/cc/plugins/skipjack.php',
            'application/cc/plugins/paymill-dd.php',
            'application/cc/plugins/omise.php',
            'application/cc/plugins/beanstream-remote.php',
            'application/cc/plugins/beanstream.php',
            'application/cc/plugins/a6it.php',
            'application/cc/plugins/firstdata/lphp.php',
            'application/cc/plugins/firstdata/firstdata.php',
            'application/cc/plugins/duspay.php',
            'application/cc/plugins/stripe-google-pay.php',
            'application/cc/plugins/braintree/braintree.php',
            'application/cc/plugins/braintree/lib/ssl/www_braintreegateway_com.ca.crt',
            'application/cc/plugins/braintree/lib/ssl/api_braintreegateway_com.ca.crt',
            'application/cc/plugins/braintree/lib/ssl/sandbox_braintreegateway_com.ca.crt',
            'application/cc/plugins/braintree/lib/Braintree/Exception/InvalidSignature.php',
            'application/cc/plugins/braintree/lib/Braintree/Exception/DownForMaintenance.php',
            'application/cc/plugins/braintree/lib/Braintree/Exception/ValidationsFailed.php',
            'application/cc/plugins/braintree/lib/Braintree/Exception/Timeout.php',
            'application/cc/plugins/braintree/lib/Braintree/Exception/TooManyRequests.php',
            'application/cc/plugins/braintree/lib/Braintree/Exception/SSLCaFileNotFound.php',
            'application/cc/plugins/braintree/lib/Braintree/Exception/ServerError.php',
            'application/cc/plugins/braintree/lib/Braintree/Exception/ForgedQueryString.php',
            'application/cc/plugins/braintree/lib/Braintree/Exception/SSLCertificate.php',
            'application/cc/plugins/braintree/lib/Braintree/Exception/InvalidChallenge.php',
            'application/cc/plugins/braintree/lib/Braintree/Exception/Configuration.php',
            'application/cc/plugins/braintree/lib/Braintree/Exception/Authentication.php',
            'application/cc/plugins/braintree/lib/Braintree/Exception/UpgradeRequired.php',
            'application/cc/plugins/braintree/lib/Braintree/Exception/Unexpected.php',
            'application/cc/plugins/braintree/lib/Braintree/Exception/NotFound.php',
            'application/cc/plugins/braintree/lib/Braintree/Exception/Authorization.php',
            'application/cc/plugins/braintree/lib/Braintree/Exception/TestOperationPerformedInProduction.php',
            'application/cc/plugins/braintree/lib/Braintree/UsBankAccount.php',
            'application/cc/plugins/braintree/lib/Braintree/AddOnGateway.php',
            'application/cc/plugins/braintree/lib/Braintree/CredentialsParser.php',
            'application/cc/plugins/braintree/lib/Braintree/AndroidPayCard.php',
            'application/cc/plugins/braintree/lib/Braintree/Modification.php',
            'application/cc/plugins/braintree/lib/Braintree/DisbursementDetails.php',
            'application/cc/plugins/braintree/lib/Braintree/OAuthResult.php',
            'application/cc/plugins/braintree/lib/Braintree/MerchantAccount.php',
            'application/cc/plugins/braintree/lib/Braintree/TransactionSearch.php',
            'application/cc/plugins/braintree/lib/Braintree/TransparentRedirectGateway.php',
            'application/cc/plugins/braintree/lib/Braintree/OAuthGateway.php',
            'application/cc/plugins/braintree/lib/Braintree/Discount.php',
            'application/cc/plugins/braintree/lib/Braintree/EqualityNode.php',
            'application/cc/plugins/braintree/lib/Braintree/PayPalAccount.php',
            'application/cc/plugins/braintree/lib/Braintree/CreditCardGateway.php',
            'application/cc/plugins/braintree/lib/Braintree/ClientTokenGateway.php',
            'application/cc/plugins/braintree/lib/Braintree/Util.php',
            'application/cc/plugins/braintree/lib/Braintree/Plan.php',
            'application/cc/plugins/braintree/lib/Braintree/CreditCardVerificationGateway.php',
            'application/cc/plugins/braintree/lib/Braintree/Gateway.php',
            'application/cc/plugins/braintree/lib/Braintree/Version.php',
            'application/cc/plugins/braintree/lib/Braintree/Transaction/AmexExpressCheckoutCardDetails.php',
            'application/cc/plugins/braintree/lib/Braintree/Transaction/StatusDetails.php',
            'application/cc/plugins/braintree/lib/Braintree/Transaction/ApplePayCardDetails.php',
            'application/cc/plugins/braintree/lib/Braintree/Transaction/EuropeBankAccountDetails.php',
            'application/cc/plugins/braintree/lib/Braintree/Transaction/PayPalDetails.php',
            'application/cc/plugins/braintree/lib/Braintree/Transaction/AddressDetails.php',
            'application/cc/plugins/braintree/lib/Braintree/Transaction/CustomerDetails.php',
            'application/cc/plugins/braintree/lib/Braintree/Transaction/CreditCardDetails.php',
            'application/cc/plugins/braintree/lib/Braintree/Transaction/SubscriptionDetails.php',
            'application/cc/plugins/braintree/lib/Braintree/Transaction/UsBankAccountDetails.php',
            'application/cc/plugins/braintree/lib/Braintree/Transaction/VenmoAccountDetails.php',
            'application/cc/plugins/braintree/lib/Braintree/Transaction/CoinbaseDetails.php',
            'application/cc/plugins/braintree/lib/Braintree/Transaction/AndroidPayCardDetails.php',
            'application/cc/plugins/braintree/lib/Braintree/AddressGateway.php',
            'application/cc/plugins/braintree/lib/Braintree/OAuthCredentials.php',
            'application/cc/plugins/braintree/lib/Braintree/WebhookNotification.php',
            'application/cc/plugins/braintree/lib/Braintree/RiskData.php',
            'application/cc/plugins/braintree/lib/Braintree/MerchantAccountGateway.php',
            'application/cc/plugins/braintree/lib/Braintree/AddOn.php',
            'application/cc/plugins/braintree/lib/Braintree/Exception.php',
            'application/cc/plugins/braintree/lib/Braintree/Customer.php',
            'application/cc/plugins/braintree/lib/Braintree/MultipleValueOrTextNode.php',
            'application/cc/plugins/braintree/lib/Braintree/PayPalAccountGateway.php',
            'application/cc/plugins/braintree/lib/Braintree/Base.php',
            'application/cc/plugins/braintree/lib/Braintree/Transaction.php',
            'application/cc/plugins/braintree/lib/Braintree/TransparentRedirect.php',
            'application/cc/plugins/braintree/lib/Braintree/PaymentMethodNonceGateway.php',
            'application/cc/plugins/braintree/lib/Braintree/CreditCard.php',
            'application/cc/plugins/braintree/lib/Braintree/SettlementBatchSummaryGateway.php',
            'application/cc/plugins/braintree/lib/Braintree/PartialMatchNode.php',
            'application/cc/plugins/braintree/lib/Braintree/Subscription.php',
            'application/cc/plugins/braintree/lib/Braintree/Subscription/StatusDetails.php',
            'application/cc/plugins/braintree/lib/Braintree/ApplePayCard.php',
            'application/cc/plugins/braintree/lib/Braintree/Configuration.php',
            'application/cc/plugins/braintree/lib/Braintree/ClientToken.php',
            'application/cc/plugins/braintree/lib/Braintree/CoinbaseAccount.php',
            'application/cc/plugins/braintree/lib/Braintree/UsBankAccountGateway.php',
            'application/cc/plugins/braintree/lib/Braintree/PaymentMethodGateway.php',
            'application/cc/plugins/braintree/lib/Braintree/AmexExpressCheckoutCard.php',
            'application/cc/plugins/braintree/lib/Braintree/KeyValueNode.php',
            'application/cc/plugins/braintree/lib/Braintree/MultipleValueNode.php',
            'application/cc/plugins/braintree/lib/Braintree/Dispute/TransactionDetails.php',
            'application/cc/plugins/braintree/lib/Braintree/SignatureService.php',
            'application/cc/plugins/braintree/lib/Braintree/IsNode.php',
            'application/cc/plugins/braintree/lib/Braintree/PaymentMethodNonce.php',
            'application/cc/plugins/braintree/lib/Braintree/RangeNode.php',
            'application/cc/plugins/braintree/lib/Braintree/DiscountGateway.php',
            'application/cc/plugins/braintree/lib/Braintree/Xml/Generator.php',
            'application/cc/plugins/braintree/lib/Braintree/Xml/Parser.php',
            'application/cc/plugins/braintree/lib/Braintree/Disbursement.php',
            'application/cc/plugins/braintree/lib/Braintree/Digest.php',
            'application/cc/plugins/braintree/lib/Braintree/Error/ErrorCollection.php',
            'application/cc/plugins/braintree/lib/Braintree/Error/Validation.php',
            'application/cc/plugins/braintree/lib/Braintree/Error/Codes.php',
            'application/cc/plugins/braintree/lib/Braintree/Error/ValidationErrorCollection.php',
            'application/cc/plugins/braintree/lib/Braintree/CreditCardVerificationSearch.php',
            'application/cc/plugins/braintree/lib/Braintree/Xml.php',
            'application/cc/plugins/braintree/lib/Braintree/PaymentMethod.php',
            'application/cc/plugins/braintree/lib/Braintree/EuropeBankAccount.php',
            'application/cc/plugins/braintree/lib/Braintree/Http.php',
            'application/cc/plugins/braintree/lib/Braintree/Test/MerchantAccount.php',
            'application/cc/plugins/braintree/lib/Braintree/Test/VenmoSdk.php',
            'application/cc/plugins/braintree/lib/Braintree/Test/Nonces.php',
            'application/cc/plugins/braintree/lib/Braintree/Test/CreditCardNumbers.php',
            'application/cc/plugins/braintree/lib/Braintree/Test/Transaction.php',
            'application/cc/plugins/braintree/lib/Braintree/Test/TransactionAmounts.php',
            'application/cc/plugins/braintree/lib/Braintree/TransactionGateway.php',
            'application/cc/plugins/braintree/lib/Braintree/VenmoAccount.php',
            'application/cc/plugins/braintree/lib/Braintree/TestingGateway.php',
            'application/cc/plugins/braintree/lib/Braintree/CustomerGateway.php',
            'application/cc/plugins/braintree/lib/Braintree/FacilitatorDetails.php',
            'application/cc/plugins/braintree/lib/Braintree/Instance.php',
            'application/cc/plugins/braintree/lib/Braintree/PlanGateway.php',
            'application/cc/plugins/braintree/lib/Braintree/Dispute.php',
            'application/cc/plugins/braintree/lib/Braintree/SubscriptionStatus.php',
            'application/cc/plugins/braintree/lib/Braintree/Result/Successful.php',
            'application/cc/plugins/braintree/lib/Braintree/Result/Error.php',
            'application/cc/plugins/braintree/lib/Braintree/Result/CreditCardVerification.php',
            'application/cc/plugins/braintree/lib/Braintree/Collection.php',
            'application/cc/plugins/braintree/lib/Braintree/ThreeDSecureInfo.php',
            'application/cc/plugins/braintree/lib/Braintree/CustomerSearch.php',
            'application/cc/plugins/braintree/lib/Braintree/PaymentInstrumentType.php',
            'application/cc/plugins/braintree/lib/Braintree/MerchantAccount/FundingDetails.php',
            'application/cc/plugins/braintree/lib/Braintree/MerchantAccount/BusinessDetails.php',
            'application/cc/plugins/braintree/lib/Braintree/MerchantAccount/IndividualDetails.php',
            'application/cc/plugins/braintree/lib/Braintree/MerchantAccount/AddressDetails.php',
            'application/cc/plugins/braintree/lib/Braintree/ResourceCollection.php',
            'application/cc/plugins/braintree/lib/Braintree/WebhookTesting.php',
            'application/cc/plugins/braintree/lib/Braintree/SubscriptionSearch.php',
            'application/cc/plugins/braintree/lib/Braintree/Merchant.php',
            'application/cc/plugins/braintree/lib/Braintree/PartnerMerchant.php',
            'application/cc/plugins/braintree/lib/Braintree/TextNode.php',
            'application/cc/plugins/braintree/lib/Braintree/CreditCardVerification.php',
            'application/cc/plugins/braintree/lib/Braintree/AccountUpdaterDailyReport.php',
            'application/cc/plugins/braintree/lib/Braintree/SettlementBatchSummary.php',
            'application/cc/plugins/braintree/lib/Braintree/SubscriptionGateway.php',
            'application/cc/plugins/braintree/lib/Braintree/UnknownPaymentMethod.php',
            'application/cc/plugins/braintree/lib/Braintree/Address.php',
            'application/cc/plugins/braintree/lib/Braintree/Descriptor.php',
            'application/cc/plugins/braintree/lib/Braintree/MerchantGateway.php',
            'application/cc/plugins/braintree/lib/autoload.php',
            'application/cc/plugins/braintree/lib/Braintree.php',
            'application/cc/plugins/merchantanywhere.php',
            'application/cc/plugins/networkmerchants-ach.php',
            'application/cc/plugins/psigate-am.php',
            'application/cc/plugins/firstdata-e4.php',
            'application/cc/plugins/eprocessingnetwork.php',
            'application/cc/plugins/epg.php',
            'application/cc/plugins/paymill.php',
        ];
    }

}