<?php
/**
 * Podcast player playpause button.
 *
 * This template can be overridden by copying it to yourtheme/podcast-player/misc/buttons/list.php.
 *
 * HOWEVER, on occasion Podcast Player will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @package Podcast Player
 * @version 1.0.0
 * @since   3.3.0
 */

use Podcast_Player\Helper\Functions\Markup as Markup_Fn;
?>

<div class="ppjs__button"><button class="pp-list-btn">
	<span class="ppjs__offscreen"><?php esc_html_e( 'Show Episodes List', 'podcast-player' ); ?></span>
	<span class="btn-icon-wrap">
		<?php Markup_Fn::the_icon( array( 'icon' => 'pp-show-list' ) ); ?>
		<?php Markup_Fn::the_icon( array( 'icon' => 'pp-hide-list' ) ); ?>
	</span>
</button></div>
