class ImageUpload {

	/**
	 * Manage Feed editor options.
	 * 
	 * @since 5.3
	 */
	constructor() {

		// Define variables.
		this.data = window.ppjsAdminOpt || {};
		this.text = this.data.messages;
		this.fileFrame  = wp.media.frames.fileFrame = wp.media({
			title: this.text.setimg,
			button: { text: this.text.btn_text },
			multiple: false,
		});

		// Run methods.
		this.events();
	}

	// Event handling.
	events() {
		const _this = this;
		const doc   = jQuery(document);

		doc.on('click', '.pp-upload-image-btn', function(e) {
			e.preventDefault();
			_this.addImage(jQuery(this));
		});

		doc.on('click', '.pp-remove-image-btn', function(e) {
			e.preventDefault();
			_this.removeImage(jQuery(this));
		});
	}

	/**
	 * Set an image for the widget.
	 * 
	 * @since 3.3.0
	 * 
	 * @param Obj obj
	 */
	addImage(obj) {
		const _this = this;
		// When an image is selected, run a callback.
		this.fileFrame.on( 'select', function() {
			const attachment = _this.fileFrame.state().get( 'selection' ).first().toJSON();
			const imgUrl = attachment.url;
			const imgId = attachment.id;
			const featuredImg = document.createElement( 'img' );
			featuredImg.src = imgUrl;
			featuredImg.className = 'pp-image';
			obj.html( featuredImg );
			if (! obj.next().hasClass('pp-remove-image-btn')) {
				const removeBtn = `<button type="button" class="pp-remove-image-btn">${_this.text.removeFeatured}</button>`;
				obj.after(jQuery(removeBtn));
			}
			obj.nextAll('input').val(imgId).trigger('change');
		});

		// Finally, open the modal
		this.fileFrame.open();
	}

	/**
	 * Remove an image for the widget.
	 * 
	 * @since 5.3.0
	 * 
	 * @param Obj obj
	 */
	removeImage(obj) {
		const uploadBtn  = obj.prev('.pp-upload-image-btn');
		const uploadText = `
		<div class="pp-no-image">
			<span class="dashicon dashicons dashicons-format-image"></span>
			${this.text.uploadFeatured}
		</div>
		`;
		uploadBtn.html(jQuery(uploadText));
		obj.siblings('input').val('').trigger('change');
		obj.remove();

	}
}

export default ImageUpload;
