<?php
/**
 * Podcast player toolkit page
 *
 * @package Podcast Player
 * @since 5.1.0
 */

use PP_Pro\Admin\Templates\Toolkit\Helper\Getters as Toolkit_Fn;
use PP_Pro\Helper\Functions\Getters as PP_Get_Fn;
?>

<h3 class="pp-toolkit-title">Feed Editor Tool</h3>
<div class="pp-toolkit-content">
	<div class="pp-notice-info"><?php esc_html_e( 'This tool will help to override podcast feed data. These changes will only visible on this website WITHOUT changing original feed data.', 'podcast-player' ); ?></div>
	<?php if ( $feed_index && is_array( $feed_index ) ) : ?>
		<?php
		$feed_index = array_merge(
			$feed_index,
			array( '' => esc_html__( 'Select a Podcast to Edit', 'podcast-player' ) )
		);
		?>
		<select id="pp-feed-edit-index" name="pp-feed-index" class="select-pp-feed-edit-index">
			<?php
			foreach ( $feed_index as $key => $label ) {
				if ( is_array( $label ) ) {
					$label = isset( $label['title'] ) ? $label['title'] : '';
				}
				echo '<option value="' . esc_attr( $key ) . '">' . esc_html( $label ) . '</option>';
			}
			?>
		</select>
		<h4 class="pp-index-optional" style="padding: 0 20px;"><?php esc_html_e( 'OR', 'podcast-player' ); ?></h4>
	<?php endif; ?>
	<div class="feed-edit-url">
		<label class="label-feed-edit">
			<input class="pp-toolkit-url" type="url" placeholder="Enter Your Podcast Feed URL" title="Feed Editor">
		</label>
		<button class="button feed-url-edit-btn"><span class="dashicons dashicons-editor-break"></span></button>
	</div>
	<div class="pp-toolkit-editor"></div>
	<div class="pp-toolkit-feedback">
		<span class="dashicons dashicons-update"></span>
		<span class="dashicons dashicons-yes"></span>
		<span class="dashicons dashicons-no"></span>
		<span class="pp-feedback"></span>
	</div>
</div>
